/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.controller;

import hmi.bml.ext.bmlt.BMLTParameter;
import hmi.physics.controller.ControllerParameterException;
import hmi.physics.controller.PhysicalController;
import hmi.xml.XMLScanException;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class XMLController
extends XMLStructureAdapter {
    private String id;
    private String className;
    private PhysicalController controller;
    private static final String XMLTAG = "Controller";

    public String getId() {
        return this.id;
    }

    public PhysicalController getController() {
        return this.controller;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag(BMLTParameter.xmlTag())) {
            BMLTParameter nextParam = new BMLTParameter();
            nextParam.readXML(tokenizer);
            try {
                this.controller.setParameterValue(nextParam.name, nextParam.value);
            }
            catch (ControllerParameterException e) {
                XMLScanException ex = new XMLScanException();
                ex.initCause((Throwable)e);
                throw ex;
            }
        }
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.id = this.getRequiredAttribute("id", attrMap, tokenizer);
        this.className = this.getRequiredAttribute("class", attrMap, tokenizer);
        super.decodeAttributes(attrMap, tokenizer);
        try {
            this.controller = (PhysicalController)Class.forName(this.className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

