/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.animation.VJoint;
import hmi.math.Quat4f;
import java.util.ArrayList;
import java.util.List;

public class AdditiveRotationBlend {
    private List<Blender> blenders = new ArrayList<Blender>();
    private float[] q1 = new float[4];
    private float[] q2 = new float[4];
    private float[] qOut = new float[4];

    public AdditiveRotationBlend(VJoint v1, VJoint v2, VJoint vOut) {
        int i = 0;
        for (VJoint vO : vOut.getParts()) {
            VJoint vj1 = (VJoint)v1.getParts().get(i);
            VJoint vj2 = (VJoint)v2.getParts().get(i);
            Blender b = new Blender(vj1, vj2, vO);
            this.blenders.add(b);
            ++i;
        }
    }

    public void blend() {
        for (Blender b : this.blenders) {
            b.v1.getRotation(this.q1);
            b.v2.getRotation(this.q2);
            Quat4f.mul((float[])this.qOut, (float[])this.q1, (float[])this.q2);
            b.vOut.setRotation(this.qOut);
        }
    }

    private static final class Blender {
        public final VJoint v1;
        public final VJoint v2;
        public final VJoint vOut;

        public Blender(VJoint vj1, VJoint vj2, VJoint vO) {
            this.v1 = vj1;
            this.v2 = vj2;
            this.vOut = vO;
        }
    }
}

