/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.elckerlyc.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.speechengine.SpeechUnit;
import hmi.elckerlyc.speechengine.WavClipUnit;
import hmi.tts.Bookmark;
import hmi.tts.TTSGenerator;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;

public class WavSpeechUnit
extends SpeechUnit {
    protected WavClipUnit wavUnit;
    private File tempFile;
    private ArrayList<Bookmark> progressHandled = new ArrayList();

    public WavSpeechUnit(String text, String id, String bmlId, TTSGenerator ttsGen) {
        super(text, id, bmlId, ttsGen);
    }

    @Override
    public void sendProgress(double playTime, double time) {
        for (Bookmark b : this.bookmarks) {
            if (playTime >= (double)b.offset / 1000.0) {
                if (this.progressHandled.contains(b)) continue;
                double bmTime = (double)System.nanoTime() / 1.0E9;
                String bmlId = this.bmlBlockId;
                String behaviorId = this.id;
                String syncId = b.name;
                String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
                double timeStamp = this.bmlStartTime + (bmTime - this.systemStartTime);
                this.feedback(new BMLSyncPointProgressFeedback(id, this.bmlBlockId, behaviorId, syncId, timeStamp));
                this.progressHandled.add(b);
                continue;
            }
            if (!this.progressHandled.contains(b)) continue;
            this.progressHandled.remove(b);
        }
    }

    @Override
    public void speak(double time) {
        if (!this.stop) {
            if (!this.playing) {
                this.sendStartProgress(time);
                this.bmlStartTime = time;
                this.systemStartTime = (double)System.nanoTime() / 1.0E9;
                this.playing = true;
            }
            double playTime = time - this.getStartTime();
            this.wavUnit.play(playTime);
            this.sendProgress(playTime, time);
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.progressHandled.clear();
        this.wavUnit.stop();
    }

    @Override
    public void reset() {
        super.reset();
        this.progressHandled.clear();
        if (this.wavUnit != null) {
            this.wavUnit.reset();
        }
    }

    @Override
    public void setPlaying(boolean play) {
        super.setPlaying(play);
        if (this.wavUnit != null) {
            this.wavUnit.setPlaying(play);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setupCache() {
        try {
            this.wavUnit = new WavClipUnit(this.tempFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        finally {
            if (this.tempFile == null || !this.tempFile.delete()) {
                // empty if block
            }
        }
    }

    @Override
    protected void getTiming() {
        String fileName = this.bmlBlockId + "-" + this.id;
        try {
            this.tempFile = File.createTempFile(fileName, ".wav");
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.ttsGenerator.speakBMLToFile(this.speechText, this.tempFile.getAbsolutePath());
        this.progressHandled.clear();
    }

    @Override
    public void setParameterValue(String parameter, float value) {
        System.out.println("Setting wav su volume");
        this.wavUnit.setParameterValue(parameter, value);
    }
}

