/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.bml.Behaviour;
import hmi.bml.SpeechBehaviour;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.Planner;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimePegAndConstraint;
import hmi.elckerlyc.faceengine.FacePlanner;
import hmi.elckerlyc.faceengine.VisemeUnit;
import hmi.elckerlyc.feedback.BMLFeedbackListener;
import hmi.elckerlyc.speechengine.SpeechUnit;
import hmi.elckerlyc.speechengine.SpeechUnitFactory;
import hmi.elckerlyc.speechengine.VerbalPlayer;
import hmi.tts.Bookmark;
import hmi.tts.TTSGenerator;
import hmi.tts.Visime;
import java.util.ArrayList;
import java.util.List;

public class VerbalPlanner
implements Planner {
    private VerbalPlayer player;
    private TTSGenerator ttsGenerator;
    private SpeechUnitFactory suFactory;
    protected ArrayList<BMLFeedbackListener> feedbackListeners = new ArrayList();
    private static final double TIMEPEG_TOLERANCE = 0.003;
    private FacePlanner facePlanner = null;

    public VerbalPlanner(SpeechUnitFactory suf, VerbalPlayer p, TTSGenerator ttsGen) {
        this(suf, p, ttsGen, null);
    }

    public VerbalPlanner(SpeechUnitFactory suf, VerbalPlayer p, TTSGenerator ttsGen, FacePlanner fp) {
        this.suFactory = suf;
        this.ttsGenerator = ttsGen;
        this.player = p;
        this.facePlanner = fp;
    }

    public void addFeedbackListener(BMLFeedbackListener fb) {
        this.feedbackListeners.add(fb);
    }

    public void removeAllFeedbackListeners() {
        this.feedbackListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpeaker(String speaker) {
        TTSGenerator tTSGenerator = this.ttsGenerator;
        synchronized (tTSGenerator) {
            this.ttsGenerator.setSpeaker(speaker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getVoices() {
        TTSGenerator tTSGenerator = this.ttsGenerator;
        synchronized (tTSGenerator) {
            return this.ttsGenerator.getVoices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpeechUnit createSpeechUnit(Behaviour b) {
        SpeechBehaviour bSpeech = (SpeechBehaviour)b;
        SpeechUnit bs = this.suFactory.createSpeechUnit(bSpeech.getContent(), bSpeech.id, bSpeech.fullId.split(":")[0], this.ttsGenerator);
        TTSGenerator tTSGenerator = this.ttsGenerator;
        synchronized (tTSGenerator) {
            bs.setup();
        }
        System.out.println("Creating speech unit " + b.id + " duration: " + bs.getPreferedDuration());
        return bs;
    }

    @Override
    public List<SyncAndTimePeg> addBehaviour(Behaviour b, ArrayList<TimePegAndConstraint> sacs, Object planElement) throws BehaviourPlanningException {
        TimePeg p;
        ArrayList<SyncAndTimePeg> satp = new ArrayList<SyncAndTimePeg>();
        SpeechUnit bs = planElement == null ? this.createSpeechUnit(b) : (SpeechUnit)planElement;
        for (TimePegAndConstraint sac : sacs) {
            if (sac.id.equals("start")) {
                if (sac.offset == 0.0) {
                    bs.setStart(sac.peg);
                    satp.add(new SyncAndTimePeg("start", b.id, b.bmlId, sac.peg));
                } else {
                    p = new OffsetPeg(sac.peg, -sac.offset);
                    bs.setStart(p);
                    satp.add(new SyncAndTimePeg("start", b.id, b.bmlId, p));
                }
            }
            if (!sac.id.equals("end")) continue;
            if (sac.offset == 0.0) {
                bs.setEnd(sac.peg);
                satp.add(new SyncAndTimePeg("end", b.id, b.bmlId, sac.peg));
                continue;
            }
            p = new OffsetPeg(sac.peg, -sac.offset);
            bs.setEnd(p);
            satp.add(new SyncAndTimePeg("end", b.id, b.bmlId, p));
        }
        this.linkBookmarks(bs, sacs, bs.getStartTime(), b);
        for (Bookmark bm : bs.getBookmarks()) {
            p = bs.getBookMarkTimePeg(bm);
            if (p == null) continue;
            satp.add(new SyncAndTimePeg(bm.name, b.id, b.bmlId, p));
        }
        if (this.facePlanner != null) {
            double totalDuration = 0.0;
            int i = 0;
            VisemeUnit vu = new VisemeUnit(-1, -1, -1, 0.0, new OffsetPeg(bs.getStartPeg(), 0.0), "visSTART", bs.getId(), bs.getBMLId());
            this.facePlanner.addVisemeUnit(vu);
            for (Visime vis : bs.getVisimes()) {
                OffsetPeg vpeg = new OffsetPeg(bs.getStartPeg(), totalDuration / 1000.0);
                totalDuration += (double)vis.duration;
                vu = new VisemeUnit(-1, vis.number, -1, vis.duration, vpeg, "vis" + i++, bs.getId(), bs.getBMLId());
                this.facePlanner.addVisemeUnit(vu);
            }
            vu = new VisemeUnit(-1, -1, -1, 0.0, new OffsetPeg(bs.getStartPeg(), totalDuration), "visEND", bs.getId(), bs.getBMLId());
            this.facePlanner.addVisemeUnit(vu);
        }
        for (BMLFeedbackListener fb : this.feedbackListeners) {
            bs.addFeedbackListener(fb);
        }
        this.player.addSpeechUnit(bs);
        return satp;
    }

    @Override
    public Object resolveSynchs(Behaviour b, ArrayList<TimePegAndConstraint> sacs) throws BehaviourPlanningException {
        SpeechUnit bs = this.createSpeechUnit(b);
        double startTime = 0.0;
        boolean startFound = false;
        for (TimePegAndConstraint sac : sacs) {
            if (!sac.id.equals("start") || sac.peg.getValue() == -2.147483647E9) continue;
            startTime = sac.peg.getValue() - sac.offset;
            startFound = true;
        }
        if (!startFound) {
            for (TimePegAndConstraint sac : sacs) {
                if (sac.peg.getValue() == -2.147483647E9) continue;
                for (Bookmark bm : bs.getBookmarks()) {
                    if (!bm.name.equals(sac.id)) continue;
                    startTime = sac.peg.getValue() - (double)bm.offset * 0.001 - sac.offset;
                    System.out.println("Setting start time based on bookmark " + sac.id + ", startTime: " + startTime);
                    System.out.println("Setting start time based on bookmark, sac.offset: " + sac.offset);
                    System.out.println("Setting start time based on bookmark, bm.offset: " + bm.offset);
                    break;
                }
                if (!sac.id.equals("end") || sac.peg.getValue() == -2.147483647E9) continue;
                startTime = sac.peg.getValue() - bs.getPreferedDuration() - sac.offset;
                break;
            }
        }
        this.linkBookmarks(bs, sacs, startTime, b);
        TimePegAndConstraint sacNotStart = null;
        for (TimePegAndConstraint sac : sacs) {
            if (sac.id.equals("start")) continue;
            sacNotStart = sac;
            break;
        }
        for (TimePegAndConstraint sac : sacs) {
            if (sac.id.equals("end")) {
                if (sac.peg.getValue() == -2.147483647E9) {
                    sac.peg.setValue(bs.getPreferedDuration() + startTime + sac.offset);
                } else if (Math.abs(sac.peg.getValue() - (startTime + bs.getPreferedDuration() + sac.offset)) > 0.003) {
                    throw new BehaviourPlanningException(b, "Stretching speech is not supported yet. Possibly this can be solved by moving the speech behavior up in the BML spec? Behavior omitted.");
                }
            }
            if (!sac.id.equals("start") || sac.peg.getValue() != -2.147483647E9) continue;
            if (sac.resolveAsStartOffset) {
                OffsetPeg p = (OffsetPeg)sac.peg;
                p.setLink(sacNotStart.peg);
                p.setOffset(startTime - sacNotStart.peg.getValue());
                continue;
            }
            sac.peg.setValue(startTime + sac.offset);
        }
        return bs;
    }

    public ArrayList<String> getInvalidBehaviours() {
        return this.player.getInvalidBehaviours();
    }

    @Override
    public void clearAll() {
        this.player.clearAll();
    }

    private void linkBookmarks(SpeechUnit su, ArrayList<TimePegAndConstraint> sacs, double startTime, Behaviour b) throws BehaviourPlanningException {
        for (Bookmark bm : su.getBookmarks()) {
            for (TimePegAndConstraint sac : sacs) {
                if (!sac.id.equals(bm.name)) continue;
                if (sac.peg.getValue() == -2.147483647E9) {
                    System.out.println("Setting time for bookmark " + bm.name + ":" + (-sac.offset + startTime + (double)bm.offset * 0.001));
                    sac.peg.setValue(sac.offset + startTime + (double)bm.offset * 0.001);
                    if (sac.offset == 0.0) {
                        su.setTimePeg(bm, sac.peg);
                        continue;
                    }
                    su.setTimePeg(bm, new OffsetPeg(sac.peg, -sac.offset));
                    continue;
                }
                if (Math.abs(sac.peg.getValue() - sac.offset - (startTime + (double)bm.offset * 0.001)) > 0.1) {
                    throw new BehaviourPlanningException(b, "Can't set bookmark timing for bookmark: " + bm.name + ", functionality not yet supported. Desired time: " + (sac.peg.getValue() - sac.offset) + " Speech time: " + (startTime + (double)((float)bm.offset * 0.001f)) + ". Behavior omitted.");
                }
                if (sac.offset == 0.0) {
                    su.setTimePeg(bm, sac.peg);
                    continue;
                }
                OffsetPeg p = new OffsetPeg(sac.peg, -sac.offset);
                su.setTimePeg(bm, p);
            }
        }
    }

    @Override
    public void removeBehaviour(String behaviourId, String BMLId) {
        this.player.removeSpeechUnit(behaviourId, BMLId);
        if (this.facePlanner != null) {
            this.facePlanner.removeVisemeUnitsForSpeechUnit(behaviourId, BMLId);
        }
    }

    public VerbalPlayer getVerbalPlayer() {
        return this.player;
    }
}

