/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.elckerlyc.speechengine.SpeechUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.jcip.annotations.GuardedBy;

public class VerbalPlanPlayer {
    @GuardedBy(value="speechUnits")
    private double time;
    @GuardedBy(value="speechUnits")
    private ArrayList<SpeechUnit> speechUnits = new ArrayList();
    @GuardedBy(value="speechUnits")
    private boolean doStop = false;
    private Future<?> speechRunner = null;
    private static final ExecutorService exec = Executors.newSingleThreadExecutor();

    public void setSpeechParameter(String id, String bmlId, String parameter, float value) {
        System.out.println("Setting speech param");
        SpeechUnit su = this.getSpeechUnit(id, bmlId);
        if (su != null) {
            su.setParameterValue(parameter, value);
        } else {
            System.out.println("su not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpeechUnit getSpeechUnit(String id, String bmlId) {
        ArrayList<SpeechUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            for (SpeechUnit sp : this.speechUnits) {
                if (!sp.getId().equals(id) || !sp.getBMLId().equals(bmlId)) continue;
                return sp;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSpeechUnit(SpeechUnit su) {
        ArrayList<SpeechUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            this.speechUnits.add(su);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfSpeechUnits() {
        ArrayList<SpeechUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            return this.speechUnits.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSpeechUnit(SpeechUnit su) {
        ArrayList<SpeechUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            su.stop();
            this.speechUnits.remove(su);
        }
    }

    public void removeSpeechUnit(String id, String bmlId) {
        SpeechUnit su = this.getSpeechUnit(id, bmlId);
        if (su != null) {
            this.removeSpeechUnit(su);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(double t) {
        ArrayList<SpeechUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            this.time = t;
        }
        if (this.speechRunner == null || this.speechRunner.isDone()) {
            this.speechRunner = exec.submit(new SpeechRunner());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleStop() {
        ArrayList<SpeechUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            this.doStop = true;
        }
        if (this.speechRunner != null) {
            try {
                this.speechRunner.get();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        arrayList = this.speechUnits;
        synchronized (arrayList) {
            this.doStop = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        System.out.println("VPP stop()");
        ArrayList<SpeechUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            System.out.println("Stopping speechunits");
            for (SpeechUnit su : this.speechUnits) {
                su.stop();
            }
        }
        this.scheduleStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ArrayList<SpeechUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            for (SpeechUnit su : this.speechUnits) {
                su.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getInvalidBehaviors() {
        ArrayList<SpeechUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            ArrayList<String> invalidBehaviors = new ArrayList<String>();
            for (SpeechUnit su : this.speechUnits) {
                if (su.hasValidTiming()) continue;
                invalidBehaviors.add(su.getBMLId() + ":" + su.getId());
            }
            return invalidBehaviors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        ArrayList<SpeechUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            System.out.println("Stopping speechunits");
            for (SpeechUnit su : this.speechUnits) {
                su.stop();
            }
            System.out.println("Clearing speechunits");
            this.speechUnits.clear();
        }
        System.out.println("Schedule VPP stop");
        this.scheduleStop();
        System.out.println("VPP cleared");
    }

    class SpeechRunner
    implements Runnable {
        SpeechRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.out.println("start verbalplanplayer");
            ArrayList speechUnitsCache = new ArrayList();
            block3: while (true) {
                double t;
                ArrayList arrayList = VerbalPlanPlayer.this.speechUnits;
                synchronized (arrayList) {
                    if (VerbalPlanPlayer.this.doStop) {
                        System.out.println("break");
                        break;
                    }
                    t = VerbalPlanPlayer.this.time;
                    speechUnitsCache.clear();
                    speechUnitsCache.addAll(VerbalPlanPlayer.this.speechUnits);
                }
                Iterator i$ = speechUnitsCache.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block3;
                    SpeechUnit su = (SpeechUnit)i$.next();
                    if (!(t >= su.getStartTime())) continue;
                    boolean resetPlaying = true;
                    if (t < su.getEndTime() || su.getEndTime() == -2.147483647E9 && t < su.getStartTime() + su.getPreferedDuration()) {
                        su.speak(t);
                        resetPlaying = false;
                    } else if (su.isPlaying()) {
                        su.sendEndProgress(t);
                        su.sendProgress(su.getEndTime() - su.getStartTime() + 1.0, t);
                    }
                    if (!resetPlaying) continue;
                    su.playing = false;
                    su.stop = false;
                }
                break;
            }
            System.out.println("stop verbalplanplayer");
        }
    }
}

