/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.feedback.BMLFeedbackListener;
import hmi.elckerlyc.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.speechengine.SpeechUnitInterface;
import hmi.tts.Bookmark;
import hmi.tts.TTSGenerator;
import hmi.tts.Visime;
import java.util.ArrayList;
import java.util.TreeMap;

public abstract class SpeechUnit
implements SpeechUnitInterface {
    protected String bmlBlockId;
    protected String speechText;
    protected TTSGenerator ttsGenerator;
    protected double duration;
    protected volatile boolean playing = false;
    public boolean stop = false;
    protected String id;
    protected ArrayList<Bookmark> bookmarks;
    protected ArrayList<Visime> visimes;
    protected TimePeg startSync = new TimePeg();
    protected TimePeg endSync = new TimePeg();
    public int prevVisime;
    public int curVisime;
    public int nextVisime;
    public double visimeDuration;
    protected double systemStartTime;
    protected double bmlStartTime;
    protected TreeMap<Bookmark, TimePeg> pegs = new TreeMap();
    protected ArrayList<BMLFeedbackListener> feedbackListeners = new ArrayList();

    @Override
    public abstract void speak(double var1);

    @Override
    public abstract void setParameterValue(String var1, float var2);

    public SpeechUnit(String text, String id, String bmlId, TTSGenerator ttsGen) {
        this.speechText = text;
        this.id = id;
        this.bmlBlockId = bmlId;
        this.ttsGenerator = ttsGen;
        this.bookmarks = new ArrayList();
        this.visimes = new ArrayList();
        this.playing = false;
        this.stop = false;
    }

    @Override
    public String getBMLId() {
        return this.bmlBlockId;
    }

    public void feedback(BMLSyncPointProgressFeedback fb) {
        for (BMLFeedbackListener fbl : this.feedbackListeners) {
            fbl.syncProgress(fb);
        }
    }

    public TimePeg getBookMarkTimePeg(String bmid) {
        for (Bookmark b : this.bookmarks) {
            if (!b.name.equals(bmid) || this.pegs.get(b) == null) continue;
            return this.pegs.get(b);
        }
        return null;
    }

    public double getBookMarkTime(Bookmark b) {
        TimePeg p = this.pegs.get(b);
        if (p == null) {
            return -2.147483647E9;
        }
        return p.getValue();
    }

    public TimePeg getBookMarkTimePeg(Bookmark b) {
        if (this.pegs.get(b) != null) {
            return this.pegs.get(b);
        }
        return null;
    }

    public double getBookMarkTime(String bmid) {
        for (Bookmark b : this.bookmarks) {
            if (!b.name.equals(bmid) || this.pegs.get(b) == null) continue;
            return this.pegs.get(b).getValue();
        }
        return -2.147483647E9;
    }

    @Override
    public void addFeedbackListener(BMLFeedbackListener fb) {
        this.feedbackListeners.add(fb);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.stop = true;
        this.playing = false;
    }

    @Override
    public void reset() {
        this.stop = false;
        this.playing = false;
    }

    @Override
    public double getStartTime() {
        return this.startSync.getValue();
    }

    @Override
    public double getEndTime() {
        double startTime;
        double endTime = this.endSync.getValue();
        if (endTime == -2.147483647E9 && (startTime = this.getStartTime()) != -2.147483647E9) {
            return startTime + this.duration;
        }
        return this.endSync.getValue();
    }

    public TimePeg getEndPeg() {
        return this.endSync;
    }

    public TimePeg getStartPeg() {
        return this.startSync;
    }

    @Override
    public boolean hasValidTiming() {
        if (this.getStartTime() > this.getEndTime()) {
            return false;
        }
        if (Math.abs(this.getEndTime() - this.getStartTime() - this.getPreferedDuration()) > 1.0E-4) {
            System.out.println("End time: " + this.getEndTime());
            System.out.println("Start time: " + this.getStartTime());
            System.out.println("End-start: " + (this.getEndTime() - this.getStartTime()));
            System.out.println("Duration: " + this.getPreferedDuration());
            return false;
        }
        for (Bookmark b : this.getBookmarks()) {
            double bmTime = this.getBookMarkTime(b);
            if (bmTime == -2.147483647E9 || !(Math.abs((double)b.offset * 0.001 + this.getStartTime() - bmTime) > 1.0E-4)) continue;
            System.out.println("(b.offset*0.001+getStartTime())=" + ((double)b.offset * 0.001 + this.getStartTime()));
            System.out.println("bookmarktime=" + bmTime);
            return false;
        }
        return true;
    }

    public void setStart(TimePeg s) {
        this.startSync = s;
    }

    public void setEnd(TimePeg s) {
        this.endSync = s;
    }

    @Override
    public double getPreferedDuration() {
        return this.duration;
    }

    protected abstract void getTiming();

    protected void setupCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup() {
        TTSGenerator tTSGenerator = this.ttsGenerator;
        synchronized (tTSGenerator) {
            this.ttsGenerator.setCallback(null);
            this.getTiming();
            this.duration = this.ttsGenerator.getDuration();
            this.playing = false;
            this.stop = false;
            this.bookmarks.clear();
            this.ttsGenerator.getBookmarks(this.bookmarks);
            this.visimes.clear();
            this.ttsGenerator.getVisimes(this.visimes);
            this.setupCache();
        }
    }

    protected void sendStartProgress(double time) {
        String bmlId = this.bmlBlockId;
        String behaviorId = this.id;
        String syncId = "start";
        String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, time));
        syncId = "ready";
        id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, time));
        syncId = "stroke-start";
        id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, time));
        syncId = "stroke";
        id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, time));
    }

    public abstract void sendProgress(double var1, double var3);

    public void sendEndProgress(double time) {
        String bmlId = this.bmlBlockId;
        String behaviorId = this.id;
        String syncId = "stroke-end";
        String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, time));
        syncId = "relax";
        id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, time));
        syncId = "end";
        id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, time));
    }

    public void setPlaying(boolean play) {
        this.playing = play;
    }

    public void setTimePeg(Bookmark bm, TimePeg sp) {
        this.pegs.put(bm, sp);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ArrayList<Bookmark> getBookmarks() {
        return this.bookmarks;
    }

    public ArrayList<Visime> getVisimes() {
        return this.visimes;
    }

    public boolean isPlaying() {
        return this.playing;
    }
}

