/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.elckerlyc.feedback.BMLFeedbackListener;
import hmi.elckerlyc.speechengine.SpeechUnitInterface;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;

public class JLabelSpeechUnit
implements SpeechUnitInterface {
    private final JLabel label;
    private final String id;
    private final String bmlId;
    private final String[] words;
    private final String text;
    private final Map<String, Integer> syncMap = new HashMap<String, Integer>();
    private static final double SPEECH_RATE = 2.0;

    public JLabelSpeechUnit(String text, String id, String bmlId, JLabel l) {
        String textNoSync = text.replaceAll("<sync.*>", "");
        textNoSync = textNoSync.replaceAll("</sync>", "");
        this.words = textNoSync.split(" ");
        int index = text.indexOf("<sync");
        while (index != -1) {
            String str = text.substring(0, index);
            String strAfter = text.substring(index, str.length());
            String syncId = strAfter.replaceAll("<sync\\s+id\\s*=\\s*\"", "");
            syncId = id.replaceAll(".*\"", "");
            System.out.println("syncId " + syncId);
            String strNoSync = str.replaceAll("<sync.*>", "");
            strNoSync = textNoSync.replaceAll("</sync>", "");
            String[] strSplit = strNoSync.split(" ");
            if (strSplit.length == this.words.length) {
                // empty if block
            }
            index = text.indexOf("<sync", index + 1);
        }
        this.text = textNoSync;
        this.id = id;
        this.bmlId = bmlId;
        this.label = l;
    }

    @Override
    public void addFeedbackListener(BMLFeedbackListener fb) {
    }

    @Override
    public String getBMLId() {
        return this.bmlId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public double getPreferedDuration() {
        return (double)this.words.length * 0.5;
    }

    @Override
    public boolean hasValidTiming() {
        return true;
    }

    @Override
    public void reset() {
        this.label.setText("");
    }

    @Override
    public void setParameterValue(String paramater, float value) {
    }

    @Override
    public void speak(double time) {
        double playTime = time - this.getStartTime();
        double d = playTime / this.getPreferedDuration();
        if (d > 1.0) {
            d = 1.0;
        }
        String str = this.text.substring(0, (int)(d * (double)this.text.length()));
        this.label.setText(str);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public double getStartTime() {
        return 0.0;
    }

    @Override
    public double getEndTime() {
        return 0.0;
    }
}

