/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.elckerlyc.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.speechengine.SpeechUnit;
import hmi.tts.TTSCallback;
import hmi.tts.TTSGenerator;

public class DirectSpeechUnit
extends SpeechUnit {
    public DirectSpeechUnit(String text, String id, String bmlId, TTSGenerator ttsGen) {
        super(text, id, bmlId, ttsGen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void speak(double time) {
        if (!this.playing && !this.stop) {
            this.playing = true;
            TTSGenerator tTSGenerator = this.ttsGenerator;
            synchronized (tTSGenerator) {
                this.sendStartProgress(time);
                this.bmlStartTime = time;
                this.systemStartTime = (double)System.nanoTime() / 1.0E9;
                this.ttsGenerator.setCallback((TTSCallback)new MyTTSCallback());
                this.ttsGenerator.speakBML(this.speechText);
            }
        }
    }

    @Override
    protected void getTiming() {
        this.ttsGenerator.getBMLTiming(this.speechText);
    }

    @Override
    public void sendProgress(double playTime, double time) {
    }

    @Override
    public void setParameterValue(String parameter, float value) {
        if (parameter.equals("volume")) {
            // empty if block
        }
    }

    protected class MyTTSCallback
    implements TTSCallback {
        protected MyTTSCallback() {
        }

        public void bookmarkCallback(String bookmark) {
            double bmTime = (double)System.nanoTime() / 1.0E9;
            String bmlId = DirectSpeechUnit.this.bmlBlockId;
            String behaviorId = DirectSpeechUnit.this.id;
            String syncId = bookmark;
            String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
            double timeStamp = DirectSpeechUnit.this.bmlStartTime + (bmTime - DirectSpeechUnit.this.systemStartTime);
            DirectSpeechUnit.this.feedback(new BMLSyncPointProgressFeedback(id, DirectSpeechUnit.this.bmlBlockId, behaviorId, syncId, timeStamp));
        }

        public void phonemeCallback(int phoneme, int dur, int nextPhoneme, boolean stress) {
        }

        public void sentenceBoundryCallback(int offset, int length) {
        }

        public boolean stopCallback() {
            return DirectSpeechUnit.this.stop;
        }

        public void visimeCallback(int visime, int duration, int nextVis, boolean stress) {
            DirectSpeechUnit.this.prevVisime = DirectSpeechUnit.this.curVisime;
            DirectSpeechUnit.this.curVisime = visime;
            DirectSpeechUnit.this.nextVisime = nextVis;
            DirectSpeechUnit.this.visimeDuration = (double)duration / 1000.0;
        }

        public void wordBoundryCallback(int offset, int length) {
        }
    }
}

