/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.faceengine;

import hmi.elckerlyc.faceengine.VisemeUnit;
import hmi.graphics.opengl.scenegraph.GLScene;
import java.util.ArrayList;

public class FacePlanPlayer {
    public static String[] visemeMappingToArmandia = new String[]{"", "Body_NG-mesh-morpher-A-2", "Body_NG-mesh-morpher-A-2", "Body_NG-mesh-morpher-A-2", "Body_NG-mesh-morpher-E-5", "Body_NG-mesh-morpher-E-5", "Body_NG-mesh-morpher-I-6", "Body_NG-mesh-morpher-U-4", "Body_NG-mesh-morpher-O-3", "Body_NG-mesh-morpher-A-2", "Body_NG-mesh-morpher-O-3", "Body_NG-mesh-morpher-A-2", "Body_NG-mesh-morpher-E-5", "Body_NG-mesh-morpher-E-5", "Body_NG-mesh-morpher-E-5", "", "", "", "Body_NG-mesh-morpher-P_B-8", "", "Body_NG-mesh-morpher-E-5", "Body_NG-mesh-morpher-P_B-8"};
    private ArrayList<VisemeUnit> visemeUnits = new ArrayList();
    public ArrayList<String> morphTargetNames = new ArrayList();
    public ArrayList<Float> morphTargetWeights = new ArrayList();
    private GLScene theGLScene;

    public FacePlanPlayer(ArrayList<VisemeUnit> vus, GLScene gls) {
        this.theGLScene = gls;
        this.visemeUnits = vus;
    }

    public void play(double t) {
        if (this.visemeUnits.size() == 0) {
            return;
        }
        VisemeUnit prevViseme = null;
        VisemeUnit nextViseme = null;
        for (VisemeUnit vu : this.visemeUnits) {
            if (vu.getTimePeg().getValue() <= t && prevViseme == null) {
                prevViseme = vu;
            }
            if (vu.getTimePeg().getValue() > t && nextViseme == null) {
                nextViseme = vu;
            }
            if (vu.getTimePeg().getValue() <= t && vu.getTimePeg().getValue() > prevViseme.getTimePeg().getValue()) {
                prevViseme = vu;
            }
            if (!(vu.getTimePeg().getValue() > t) || !(vu.getTimePeg().getValue() < nextViseme.getTimePeg().getValue())) continue;
            nextViseme = vu;
        }
        double alpha = 0.0;
        alpha = nextViseme == null ? 0.0 : (prevViseme == null ? 1.0 : (prevViseme.getTimePeg().getValue() == nextViseme.getTimePeg().getValue() ? 1.0 : (t - prevViseme.getTimePeg().getValue()) / (nextViseme.getTimePeg().getValue() - prevViseme.getTimePeg().getValue())));
        String[] names = new String[this.morphTargetNames.size()];
        float[] weights = new float[this.morphTargetNames.size()];
        for (int i = 0; i < this.morphTargetNames.size(); ++i) {
            names[i] = this.morphTargetNames.get(i);
            weights[i] = this.morphTargetWeights.get(i).floatValue();
        }
        this.theGLScene.removeMorphTargets(names, weights);
        this.morphTargetNames.clear();
        this.morphTargetWeights.clear();
        int vis = 0;
        if (prevViseme != null) {
            vis = prevViseme.curViseme;
            if (vis == -1) {
                vis = 0;
            }
            if (alpha != 1.0 && !visemeMappingToArmandia[vis].equals("")) {
                this.morphTargetNames.add(visemeMappingToArmandia[vis]);
                this.morphTargetWeights.add(new Float(1.0f - (float)alpha));
            }
        }
        if (nextViseme != null) {
            vis = nextViseme.curViseme;
            if (vis == -1) {
                vis = 0;
            }
            if (alpha != 1.0 && !visemeMappingToArmandia[vis].equals("")) {
                this.morphTargetNames.add(visemeMappingToArmandia[vis]);
                this.morphTargetWeights.add(new Float((float)alpha));
            }
        }
        names = new String[this.morphTargetNames.size()];
        weights = new float[this.morphTargetNames.size()];
        for (int i = 0; i < this.morphTargetNames.size(); ++i) {
            names[i] = this.morphTargetNames.get(i);
            weights[i] = this.morphTargetWeights.get(i).floatValue();
        }
        this.theGLScene.addMorphTargets(names, weights);
    }
}

