/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.audioengine;

import hmi.elckerlyc.audioengine.WavUnit;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class WavClipUnit
implements WavUnit {
    private final AudioInputStream audioStream;
    private final AudioFormat audioFormat;
    private final long audioLength;
    private int audioReadPos = 0;
    private byte[] audioData = null;
    private static final int AUDIO_READ_BUFFER_SIZE = 65535;
    private static final double AUDIOPOSITION_UPDATE_DELTA = 0.066;
    private Clip outputLine;
    private final Object clipLock = new Object();
    public volatile boolean playing = false;
    public volatile boolean stop = false;
    private boolean firstPlay = false;

    public WavClipUnit(URL url) {
        try {
            this.audioStream = AudioSystem.getAudioInputStream(url);
        }
        catch (UnsupportedAudioFileException e1) {
            e1.printStackTrace();
            throw new RuntimeException(e1);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            throw new RuntimeException(e1);
        }
        this.audioLength = this.audioStream.getFrameLength() * (long)this.audioStream.getFormat().getFrameSize();
        this.audioData = new byte[(int)this.audioLength];
        this.audioFormat = this.audioStream.getFormat();
        this.audioReadPos = 0;
        while ((long)this.audioReadPos < this.audioLength) {
            long size = 65535L;
            if (size > this.audioLength - (long)this.audioReadPos) {
                size = this.audioLength - (long)this.audioReadPos;
            }
            try {
                this.audioReadPos += this.audioStream.read(this.audioData, this.audioReadPos, (int)size);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.audioStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public double getDuration() {
        System.out.println("WAVUNIT AUDIO LENGTH: " + this.audioLength);
        System.out.println("WAVUNIT SAMPLERATE: " + this.audioFormat.getSampleRate());
        return (double)this.audioLength / (double)this.audioFormat.getSampleRate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameterValue(String parameter, float value) {
        if (parameter.equals("volume")) {
            Object object = this.clipLock;
            synchronized (object) {
                System.out.println("Setting wav volume");
                FloatControl volume = (FloatControl)this.outputLine.getControl(FloatControl.Type.MASTER_GAIN);
                volume.setValue(value);
            }
        }
    }

    @Override
    public void setPlaying(boolean play) {
        this.playing = play;
    }

    @Override
    public void reset() {
        this.stop = false;
        this.playing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.stop = true;
        this.playing = false;
        System.out.println("WavUnit stop");
        Object object = this.clipLock;
        synchronized (object) {
            if (this.outputLine != null) {
                System.out.println("Stop output line");
                this.outputLine.stop();
                this.outputLine = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play(double relTime) {
        if (this.stop) {
            return;
        }
        Object object = this.clipLock;
        synchronized (object) {
            if (this.outputLine == null) {
                DataLine.Info info = new DataLine.Info(Clip.class, this.audioFormat);
                if (!AudioSystem.isLineSupported(info)) {
                    System.err.println("!AudioSystem.isLineSupported");
                }
                try {
                    this.outputLine = (Clip)AudioSystem.getLine(info);
                    this.outputLine.open(this.audioFormat, this.audioData, 0, this.audioData.length);
                }
                catch (LineUnavailableException ex) {
                    ex.printStackTrace();
                    return;
                }
                this.outputLine.setMicrosecondPosition((long)(relTime * 1000000.0));
                this.outputLine.start();
                this.firstPlay = true;
            } else if (Math.abs((double)this.outputLine.getMicrosecondPosition() * 1.0E-6 - relTime) > 0.066 || this.firstPlay) {
                if (!this.firstPlay) {
                    System.err.println("WavUnit asynchrony:" + ((double)this.outputLine.getMicrosecondPosition() * 1.0E-6 - relTime) + "s, " + (int)(((double)this.outputLine.getMicrosecondPosition() * 1.0E-6 - relTime) * (double)this.audioFormat.getSampleRate() + 0.5) + "frames, skipping to correct play position");
                }
                this.outputLine.setMicrosecondPosition((long)(relTime * 1000000.0));
                this.firstPlay = false;
            }
        }
    }
}

