/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.audioengine;

import hmi.elckerlyc.audioengine.AudioUnit;
import hmi.elckerlyc.audioengine.WavClipUnit;
import java.io.File;
import java.net.MalformedURLException;

public class WavAudioUnit
extends AudioUnit {
    protected WavClipUnit wavUnit;

    public WavAudioUnit(String fname, String id, String bmlId) {
        super(fname, id, bmlId);
    }

    @Override
    public void sendProgress(double playTime, double time) {
    }

    @Override
    public void play(double time) {
        if (!this.stop) {
            if (!this.playing) {
                this.sendStartProgress(time);
                this.bmlStartTime = time;
                this.systemStartTime = (double)System.nanoTime() / 1.0E9;
                this.playing = true;
            }
            double playTime = time - this.getStartTime();
            this.wavUnit.play(playTime);
            this.sendProgress(playTime, time);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.wavUnit != null) {
            this.wavUnit.stop();
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.wavUnit != null) {
            this.wavUnit.reset();
        }
    }

    @Override
    public void setPlaying(boolean play) {
        super.setPlaying(play);
        if (this.wavUnit != null) {
            this.wavUnit.setPlaying(play);
        }
    }

    @Override
    protected void setupCache() {
        try {
            this.wavUnit = new WavClipUnit(new File(this.fileName).toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.duration = this.wavUnit.getDuration();
        System.out.println("WAVUNIT DURATION: " + this.duration);
    }

    @Override
    public void setParameterValue(String parameter, float value) {
        System.out.println("Setting wav au volume");
        this.wavUnit.setParameterValue(parameter, value);
    }
}

