/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.audioengine;

import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.feedback.BMLFeedbackListener;
import hmi.elckerlyc.feedback.BMLSyncPointProgressFeedback;
import java.util.ArrayList;

public abstract class AudioUnit {
    protected String fileName;
    protected String bmlBlockId;
    protected double duration;
    protected volatile boolean playing = false;
    public boolean stop = false;
    protected String id;
    protected TimePeg startSync = new TimePeg();
    protected TimePeg endSync = new TimePeg();
    protected double systemStartTime;
    protected double bmlStartTime;
    protected ArrayList<BMLFeedbackListener> feedbackListeners = new ArrayList();

    public abstract void play(double var1);

    public abstract void setParameterValue(String var1, float var2);

    public AudioUnit(String fname, String id, String bmlId) {
        this.fileName = fname;
        this.id = id;
        this.bmlBlockId = bmlId;
        this.playing = false;
        this.stop = false;
    }

    public String getBMLId() {
        return this.bmlBlockId;
    }

    public void feedback(BMLSyncPointProgressFeedback fb) {
        for (BMLFeedbackListener fbl : this.feedbackListeners) {
            fbl.syncProgress(fb);
        }
    }

    public void addFeedbackListener(BMLFeedbackListener fb) {
        this.feedbackListeners.add(fb);
    }

    public void stop() {
        this.stop = true;
        this.playing = false;
    }

    public void reset() {
        this.stop = false;
        this.playing = false;
    }

    public double getStartTime() {
        return this.startSync.getValue();
    }

    public double getEndTime() {
        double startTime;
        double endTime = this.endSync.getValue();
        if (endTime == -2.147483647E9 && (startTime = this.getStartTime()) != -2.147483647E9) {
            return startTime + this.duration;
        }
        return this.endSync.getValue();
    }

    public TimePeg getEndPeg() {
        return this.endSync;
    }

    public TimePeg getStartPeg() {
        return this.startSync;
    }

    public boolean hasValidTiming() {
        if (this.getStartTime() > this.getEndTime()) {
            return false;
        }
        if (Math.abs(this.getEndTime() - this.getStartTime() - this.getPreferedDuration()) > 1.0E-4) {
            System.out.println("End time: " + this.getEndTime());
            System.out.println("Start time: " + this.getStartTime());
            System.out.println("End-start: " + (this.getEndTime() - this.getStartTime()));
            System.out.println("Duration: " + this.getPreferedDuration());
            return false;
        }
        return true;
    }

    public void setStart(TimePeg s) {
        this.startSync = s;
    }

    public void setEnd(TimePeg s) {
        this.endSync = s;
    }

    public double getPreferedDuration() {
        return this.duration;
    }

    protected void setupCache() {
    }

    public void setup() {
        this.playing = false;
        this.stop = false;
        this.setupCache();
    }

    protected void sendStartProgress(double time) {
        String bmlId = this.bmlBlockId;
        String behaviorId = this.id;
        String syncId = "start";
        String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, time));
        syncId = "ready";
        id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, time));
        syncId = "stroke-start";
        id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, time));
        syncId = "stroke";
        id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, time));
    }

    public abstract void sendProgress(double var1, double var3);

    public void sendEndProgress(double time) {
        String bmlId = this.bmlBlockId;
        String behaviorId = this.id;
        String syncId = "stroke-end";
        String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, time));
        syncId = "relax";
        id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, time));
        syncId = "end";
        id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, time));
    }

    public void setPlaying(boolean play) {
        this.playing = play;
    }

    public String getId() {
        return this.id;
    }

    public boolean isPlaying() {
        return this.playing;
    }
}

