/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.audioengine;

import hmi.bml.Behaviour;
import hmi.bmlt.BMLTAudioFileBehaviour;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.Planner;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.TimePegAndConstraint;
import hmi.elckerlyc.audioengine.AudioPlayer;
import hmi.elckerlyc.audioengine.AudioUnit;
import hmi.elckerlyc.audioengine.WavAudioUnit;
import hmi.elckerlyc.feedback.BMLFeedbackListener;
import java.util.ArrayList;
import java.util.List;

public class AudioPlanner
implements Planner {
    private AudioPlayer player;
    protected ArrayList<BMLFeedbackListener> feedbackListeners = new ArrayList();
    private static final double TIMEPEG_TOLERANCE = 0.003;

    public AudioPlanner(AudioPlayer p) {
        this.player = p;
    }

    public void addFeedbackListener(BMLFeedbackListener fb) {
        this.feedbackListeners.add(fb);
    }

    public void removeAllFeedbackListeners() {
        this.feedbackListeners.clear();
    }

    private AudioUnit createAudioUnit(Behaviour b) {
        BMLTAudioFileBehaviour bAudio = (BMLTAudioFileBehaviour)b;
        WavAudioUnit au = new WavAudioUnit(bAudio.getStringParameterValue("fileName"), bAudio.id, bAudio.fullId.split(":")[0]);
        au.setup();
        System.out.println("Creating audio unit " + b.id + " duration: " + au.getPreferedDuration());
        return au;
    }

    @Override
    public List<SyncAndTimePeg> addBehaviour(Behaviour b, ArrayList<TimePegAndConstraint> sacs, Object planElement) throws BehaviourPlanningException {
        ArrayList<SyncAndTimePeg> satp = new ArrayList<SyncAndTimePeg>();
        AudioUnit au = planElement == null ? this.createAudioUnit(b) : (AudioUnit)planElement;
        for (TimePegAndConstraint sac : sacs) {
            OffsetPeg p;
            if (sac.id.equals("start")) {
                if (sac.offset == 0.0) {
                    au.setStart(sac.peg);
                    satp.add(new SyncAndTimePeg("start", b.id, b.bmlId, sac.peg));
                } else {
                    p = new OffsetPeg(sac.peg, -sac.offset);
                    au.setStart(p);
                    satp.add(new SyncAndTimePeg("start", b.id, b.bmlId, p));
                }
            }
            if (!sac.id.equals("end")) continue;
            if (sac.offset == 0.0) {
                au.setEnd(sac.peg);
                satp.add(new SyncAndTimePeg("end", b.id, b.bmlId, sac.peg));
                continue;
            }
            p = new OffsetPeg(sac.peg, -sac.offset);
            au.setEnd(p);
            satp.add(new SyncAndTimePeg("end", b.id, b.bmlId, p));
        }
        for (BMLFeedbackListener fb : this.feedbackListeners) {
            au.addFeedbackListener(fb);
        }
        this.player.addAudioUnit(au);
        return satp;
    }

    @Override
    public Object resolveSynchs(Behaviour b, ArrayList<TimePegAndConstraint> sacs) throws BehaviourPlanningException {
        AudioUnit au = this.createAudioUnit(b);
        double startTime = 0.0;
        boolean startFound = false;
        for (TimePegAndConstraint sac : sacs) {
            if (!sac.id.equals("start") || sac.peg.getValue() == -2.147483647E9) continue;
            startTime = sac.peg.getValue() - sac.offset;
            startFound = true;
        }
        if (!startFound) {
            for (TimePegAndConstraint sac : sacs) {
                if (sac.peg.getValue() == -2.147483647E9 || !sac.id.equals("end") || sac.peg.getValue() == -2.147483647E9) continue;
                startTime = sac.peg.getValue() - au.getPreferedDuration() - sac.offset;
                break;
            }
        }
        TimePegAndConstraint sacNotStart = null;
        for (TimePegAndConstraint sac : sacs) {
            if (sac.id.equals("start")) continue;
            sacNotStart = sac;
            break;
        }
        for (TimePegAndConstraint sac : sacs) {
            if (sac.id.equals("end")) {
                if (sac.peg.getValue() == -2.147483647E9) {
                    sac.peg.setValue(au.getPreferedDuration() + startTime + sac.offset);
                } else if (Math.abs(sac.peg.getValue() - (startTime + au.getPreferedDuration() + sac.offset)) > 0.003) {
                    throw new BehaviourPlanningException(b, "Stretching audio fragments is not supported yet. Should not be too hard to do, though. Behavior omitted.");
                }
            }
            if (!sac.id.equals("start") || sac.peg.getValue() != -2.147483647E9) continue;
            if (sac.resolveAsStartOffset) {
                OffsetPeg p = (OffsetPeg)sac.peg;
                p.setLink(sacNotStart.peg);
                p.setOffset(startTime - sacNotStart.peg.getValue());
                continue;
            }
            sac.peg.setValue(startTime + sac.offset);
        }
        return au;
    }

    public ArrayList<String> getInvalidBehaviours() {
        return this.player.getInvalidBehaviours();
    }

    @Override
    public void clearAll() {
        this.player.clearAll();
    }

    @Override
    public void removeBehaviour(String behaviourId, String BMLId) {
        this.player.removeAudioUnit(behaviourId, BMLId);
    }

    public AudioPlayer getAudioPlayer() {
        return this.player;
    }
}

