/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.audioengine;

import hmi.elckerlyc.audioengine.AudioUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.jcip.annotations.GuardedBy;

public class AudioPlanPlayer {
    @GuardedBy(value="audioUnits")
    private double time;
    @GuardedBy(value="audioUnits")
    private ArrayList<AudioUnit> audioUnits = new ArrayList();
    @GuardedBy(value="audioUnits")
    private boolean doStop = false;
    private Future<?> audioRunner = null;
    private static final ExecutorService exec = Executors.newSingleThreadExecutor();

    public void setAudioParameter(String id, String bmlId, String parameter, float value) {
        System.out.println("Setting audio param");
        AudioUnit au = this.getAudioUnit(id, bmlId);
        if (au != null) {
            au.setParameterValue(parameter, value);
        } else {
            System.out.println("au not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AudioUnit getAudioUnit(String id, String bmlId) {
        ArrayList<AudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            for (AudioUnit au : this.audioUnits) {
                if (!au.getId().equals(id) || !au.getBMLId().equals(bmlId)) continue;
                return au;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAudioUnit(AudioUnit au) {
        ArrayList<AudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            this.audioUnits.add(au);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAudioUnits() {
        ArrayList<AudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            return this.audioUnits.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAudioUnit(AudioUnit au) {
        ArrayList<AudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            au.stop();
            this.audioUnits.remove(au);
        }
    }

    public void removeAudioUnit(String id, String bmlId) {
        AudioUnit au = this.getAudioUnit(id, bmlId);
        if (au != null) {
            this.removeAudioUnit(au);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(double t) {
        ArrayList<AudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            this.time = t;
        }
        if (this.audioRunner == null || this.audioRunner.isDone()) {
            this.audioRunner = exec.submit(new AudioRunner());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleStop() {
        ArrayList<AudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            this.doStop = true;
        }
        if (this.audioRunner != null) {
            try {
                this.audioRunner.get();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        arrayList = this.audioUnits;
        synchronized (arrayList) {
            this.doStop = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        System.out.println("AudioPP stop()");
        ArrayList<AudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            System.out.println("Stopping audiounits");
            for (AudioUnit au : this.audioUnits) {
                au.stop();
            }
        }
        this.scheduleStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ArrayList<AudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            for (AudioUnit au : this.audioUnits) {
                au.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getInvalidBehaviors() {
        ArrayList<AudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            ArrayList<String> invalidBehaviors = new ArrayList<String>();
            for (AudioUnit au : this.audioUnits) {
                if (au.hasValidTiming()) continue;
                invalidBehaviors.add(au.getBMLId() + ":" + au.getId());
            }
            return invalidBehaviors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        ArrayList<AudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            System.out.println("Stopping audiounits");
            for (AudioUnit au : this.audioUnits) {
                au.stop();
            }
            System.out.println("Clearing audiounits");
            this.audioUnits.clear();
        }
        System.out.println("Schedule AudioPP stop");
        this.scheduleStop();
        System.out.println("AudioPP cleared");
    }

    class AudioRunner
    implements Runnable {
        AudioRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.out.println("start audioplanplayer");
            ArrayList audioUnitsCache = new ArrayList();
            block3: while (true) {
                double t;
                ArrayList arrayList = AudioPlanPlayer.this.audioUnits;
                synchronized (arrayList) {
                    if (AudioPlanPlayer.this.doStop) {
                        System.out.println("break");
                        break;
                    }
                    t = AudioPlanPlayer.this.time;
                    audioUnitsCache.clear();
                    audioUnitsCache.addAll(AudioPlanPlayer.this.audioUnits);
                }
                Iterator i$ = audioUnitsCache.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block3;
                    AudioUnit au = (AudioUnit)i$.next();
                    if (!(t >= au.getStartTime())) continue;
                    boolean resetPlaying = true;
                    if (t < au.getEndTime() || au.getEndTime() == -2.147483647E9 && t < au.getStartTime() + au.getPreferedDuration()) {
                        au.play(t);
                        resetPlaying = false;
                    } else if (au.isPlaying()) {
                        au.sendEndProgress(t);
                        au.sendProgress(au.getEndTime() - au.getStartTime() + 1.0, t);
                    }
                    if (!resetPlaying) continue;
                    au.playing = false;
                    au.stop = false;
                }
                break;
            }
            System.out.println("stop audioplanplayer");
        }
    }
}

