/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.procanimation;

import hmi.animation.VJoint;
import hmi.elckerlyc.animationengine.procanimation.Keyframe;
import hmi.math.Quat4f;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import org.lsmp.djep.xjep.XJep;

public class Keyframes
extends XMLStructureAdapter {
    private String target = "";
    private String encoding = "";
    private ArrayList<Keyframe> frames = new ArrayList();
    private Keyframe prev = null;
    private Keyframe next = null;
    private VJoint joint;
    private float[] qNext = new float[4];
    private float[] qPrev = new float[4];
    private double startT = 0.0;
    private double endT = 0.0;
    private XJep parser;

    public void setTarget(VJoint h) {
        this.joint = h.getPart(this.target);
        for (Keyframe f : this.frames) {
            f.setJoint(this.joint);
        }
    }

    public void clear() {
        this.frames.clear();
        this.prev = null;
        this.next = null;
    }

    public void setJoint(VJoint j) {
        this.joint = j;
        for (Keyframe f : this.frames) {
            f.setJoint(this.joint);
            this.target = this.joint.getSid();
        }
    }

    public VJoint getJoint() {
        return this.joint;
    }

    public Keyframes(XJep p) {
        this.parser = p;
        this.target = null;
    }

    public Keyframes(XJep p, String t) {
        this.parser = p;
        this.target = t;
    }

    public void set(Keyframes kfs) {
        this.joint = kfs.joint;
        this.target = kfs.target;
        this.endT = kfs.endT;
        this.startT = kfs.startT;
        this.frames.clear();
        for (Keyframe kf : kfs.frames) {
            Keyframe k = new Keyframe(kf);
            this.frames.add(k);
        }
        this.prev = kfs.prev;
        this.next = kfs.next;
    }

    public Keyframes deepCopy() {
        Keyframes copy = new Keyframes(this.parser, "" + this.target);
        copy.set(this);
        return copy;
    }

    public Vector findParameters(Vector v) {
        for (Keyframe f : this.frames) {
            f.findParameters(v);
        }
        return v;
    }

    public boolean evaluate(double t, float[] goal, VJoint human) {
        Keyframe start = null;
        Keyframe end = null;
        for (Keyframe f : this.frames) {
            if ((double)f.getTime() <= t) {
                start = f;
                continue;
            }
            end = f;
            break;
        }
        if (end == null && start == null) {
            return false;
        }
        if (start == null) {
            end.evaluate(goal, human);
            return true;
        }
        if (end == null) {
            start.evaluate(goal, human);
            return true;
        }
        if (start == this.next) {
            Quat4f.set((float[])this.qPrev, (float[])this.qNext);
            this.startT = this.endT;
        } else if (start != this.prev) {
            start.evaluate(this.qPrev, human);
            this.startT = start.getTime();
        }
        this.endT = end.getTime();
        end.evaluate(this.qNext, human);
        this.next = end;
        this.prev = start;
        Quat4f.interpolate((float[])goal, (float[])this.qPrev, (float[])this.qNext, (float)((float)((t - this.startT) / (this.endT - this.startT))));
        return true;
    }

    public String getTarget() {
        return this.target;
    }

    public StringBuilder appendContent(StringBuilder buf, int tab) {
        for (Keyframe kf : this.frames) {
            kf.appendXML(buf);
        }
        return buf;
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        Keyframes.appendAttribute((StringBuilder)buf, (String)"target", (String)this.target);
        Keyframes.appendAttribute((StringBuilder)buf, (String)"encoding", (String)this.encoding);
        return buf;
    }

    public boolean decodeAttribute(String attrName, String attrValue) {
        if (attrName.equals("target")) {
            this.target = attrValue;
        } else if (attrName.equals("encoding")) {
            this.encoding = attrValue;
        }
        return false;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (!tokenizer.atETag()) {
            if (!tokenizer.atSTag("Keyframe")) continue;
            Keyframe kf = new Keyframe(this.parser, this.encoding);
            kf.readXML(tokenizer);
            this.frames.add(kf);
        }
        Collections.sort(this.frames);
    }

    public boolean decodeAttribute(String attrName, String attrValue, XMLTokenizer tokenizer) {
        return this.decodeAttribute(attrName, attrValue);
    }

    public String getXMLTag() {
        return "Keyframes";
    }

    public String getEncoding() {
        return this.encoding;
    }
}

