/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.procanimation;

import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.Vector;
import org.lsmp.djep.xjep.XJep;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;

public class EndEffector
extends XMLStructureAdapter {
    private Node[] nodeTrans = new Node[3];
    private Node nodeSwivel;
    private String[] transFormula = new String[3];
    private String swivelFormula = "";
    private String target = "";
    private boolean local = false;
    private XJep parser;

    public EndEffector(XJep p) {
        this.parser = p;
        this.target = null;
    }

    public EndEffector(XJep parser, String target) {
        this.parser = parser;
        this.target = target;
    }

    public void set(EndEffector eff) {
        for (int i = 0; i < 3; ++i) {
            this.setTranslation(i, eff.transFormula[i]);
        }
        this.setSwivel(eff.swivelFormula);
        this.target = eff.target;
        this.local = eff.local;
    }

    public String getTarget() {
        return this.target;
    }

    public String getTranslationFormula(int i) {
        return this.transFormula[i];
    }

    public void setTranslation(int i, String translation) {
        this.transFormula[i] = translation;
        try {
            this.nodeTrans[i] = this.parser.simplify(this.parser.preprocess(this.parser.parse(translation)));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getSwivel() {
        return this.swivelFormula;
    }

    public void setSwivel(String s) {
        if (s == null || s.equals("")) {
            this.nodeSwivel = null;
            return;
        }
        this.swivelFormula = s;
        try {
            this.nodeSwivel = this.parser.simplify(this.parser.preprocess(this.parser.parse(s)));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public double evaluateSwivel() {
        if (this.nodeSwivel != null) {
            try {
                return (Double)this.parser.evaluate(this.nodeSwivel);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return 0.0;
    }

    public void evaluateTrans(float[] dst, double t) {
        Variable tVar = this.parser.getVar("t");
        tVar.setValue((Object)t);
        for (int i = 0; i < 3; ++i) {
            if (this.nodeTrans[i] != null) {
                try {
                    dst[i] = ((Double)this.parser.evaluate(this.nodeTrans[i])).floatValue();
                    continue;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            dst[i] = 0.0f;
        }
    }

    public void evaluateTrans(float[] dst) {
        for (int i = 0; i < 3; ++i) {
            if (this.nodeTrans[i] != null) {
                try {
                    dst[i] = ((Double)this.parser.evaluate(this.nodeTrans[i])).floatValue();
                    continue;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            dst[i] = 0.0f;
        }
    }

    public double evaluateSingleIndex(int target) {
        if (this.nodeTrans[target] != null) {
            try {
                return (Double)this.parser.evaluate(this.nodeTrans[target]);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return 0.0;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public EndEffector deepCopy() {
        EndEffector copy = new EndEffector(this.parser, "" + this.target);
        copy.set(this);
        return copy;
    }

    public Vector findParameters(Vector v) {
        for (int i = 0; i < 3; ++i) {
            if (this.nodeTrans[i] == null) continue;
            v = this.parser.getVarsInEquation(this.nodeTrans[i], v);
        }
        if (this.nodeSwivel != null) {
            v = this.parser.getVarsInEquation(this.nodeSwivel, v);
        }
        return v;
    }

    public boolean decodeAttribute(String attrName, String attrValue) {
        if (attrName.equals("target")) {
            this.target = attrValue;
        } else if (attrName.equals("local")) {
            this.local = Boolean.parseBoolean(attrValue);
        } else if (attrName.equals("translation")) {
            String str = attrValue;
            this.transFormula = str.split(";");
            this.setTranslation(0, this.transFormula[0]);
            this.setTranslation(1, this.transFormula[1]);
            this.setTranslation(2, this.transFormula[2]);
        } else if (attrName.equals("swivel")) {
            String str = attrValue;
            this.setSwivel(str);
        } else {
            return false;
        }
        return true;
    }

    public boolean decodeAttribute(String attrName, String attrValue, XMLTokenizer tokenizer) {
        return this.decodeAttribute(attrName, attrValue);
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
    }

    public StringBuilder appendContent(StringBuilder buf, int tab) {
        return buf;
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        EndEffector.appendAttribute((StringBuilder)buf, (String)"local", (boolean)this.local);
        if (this.transFormula[0] != null) {
            String str = this.transFormula[0] + ";" + this.transFormula[1] + ";" + this.transFormula[2];
            EndEffector.appendAttribute((StringBuilder)buf, (String)"translation", (String)str);
        }
        if (this.swivelFormula != null) {
            EndEffector.appendAttribute((StringBuilder)buf, (String)"swivel", (String)this.swivelFormula);
        }
        EndEffector.appendAttribute((StringBuilder)buf, (String)"target", (String)this.target);
        return buf;
    }

    public String getXMLTag() {
        return "EndEffector";
    }
}

