/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.motionunit;

import hmi.animation.VJoint;
import hmi.bml.BMLSync;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.animationengine.motionunit.MUPlayException;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.motionunit.TMUPlayException;
import hmi.elckerlyc.feedback.BMLFeedbackListener;
import hmi.elckerlyc.feedback.BMLSyncPointProgressFeedback;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class TimedMotionUnit {
    public MotionUnit mu;
    protected String id;
    protected String bmlBlockId;
    protected TimePeg start = new TimePeg();
    protected TimePeg end = new TimePeg();
    protected ArrayList<BMLFeedbackListener> feedbackListeners = new ArrayList();
    protected ArrayList<KeyPosition> progressHandled = new ArrayList();
    protected Map<KeyPosition, TimePeg> pegs = new TreeMap<KeyPosition, TimePeg>();
    protected boolean playing = false;

    public TimedMotionUnit(String i, String bmlId, MotionUnit m) {
        this.id = i;
        this.bmlBlockId = bmlId;
        this.mu = m;
    }

    public boolean hasValidTiming() {
        double prevTime = 0.0;
        for (KeyPosition kp : this.pegs.keySet()) {
            TimePeg p = this.pegs.get(kp);
            System.out.println("Checking validity of timing " + this.id + " " + kp.id + ":" + p);
            if (p.getValue() == -2.147483647E9) continue;
            if (p.getValue() < prevTime) {
                return false;
            }
            prevTime = p.getValue();
        }
        return true;
    }

    public KeyPosition getKeyPosition(TimePeg sp) {
        for (KeyPosition kp : this.pegs.keySet()) {
            if (this.pegs.get(kp) == sp) {
                return kp;
            }
            if (this.pegs.get(kp) == sp.getLink()) {
                return kp;
            }
            if (this.pegs.get(kp).getLink() != sp) continue;
            return kp;
        }
        return null;
    }

    public TimePeg getTimePeg(String pid) {
        KeyPosition kp = this.getKeyPosition(pid);
        if (kp != null) {
            return this.pegs.get(kp);
        }
        return null;
    }

    public double getPrevPegTime(String pid) {
        KeyPosition kpCur = this.getKeyPosition(pid);
        BMLSync curSync = BMLSync.get((String)pid);
        double prevTime = -2.147483647E9;
        for (KeyPosition kp : this.pegs.keySet()) {
            System.out.println("getPrevPegTime " + kp.id + " for " + pid);
            BMLSync sync = BMLSync.get((String)kp.id);
            if (curSync != null && sync != null && sync.isAfter(curSync) || kp == kpCur) break;
            TimePeg tp = this.pegs.get(kp);
            if (tp == null || tp.getValue() == -2.147483647E9) continue;
            prevTime = tp.getValue();
        }
        return prevTime;
    }

    public double getNextPegTime(String pid) {
        KeyPosition kpCur = this.getKeyPosition(pid);
        boolean getNext = false;
        BMLSync curSync = BMLSync.get((String)pid);
        for (KeyPosition kp : this.pegs.keySet()) {
            TimePeg tp;
            BMLSync sync = BMLSync.get((String)kp.id);
            if (curSync != null && sync != null && sync.isAfter(curSync)) {
                getNext = true;
            }
            if (getNext && (tp = this.pegs.get(kp)) != null && tp.getValue() != -2.147483647E9) {
                return tp.getValue();
            }
            if (kp != kpCur) continue;
            getNext = true;
        }
        return -2.147483647E9;
    }

    public double getPegTime(String pid) {
        KeyPosition kp = this.getKeyPosition(pid);
        if (kp == null) {
            return -2.147483647E9;
        }
        TimePeg p = this.pegs.get(kp);
        if (p == null) {
            return -2.147483647E9;
        }
        return p.getValue();
    }

    public KeyPosition getKeyPosition(String kid) {
        for (KeyPosition kp : this.mu.getKeyPositions()) {
            if (!kp.id.equals(kid)) continue;
            return kp;
        }
        return null;
    }

    public TimedMotionUnit getPredictor(VJoint vPredict) {
        MotionUnit muPred = this.mu.getPredictor(vPredict);
        if (muPred != null) {
            TimedMotionUnit copy = muPred.createTMU(this.id + "-pred", this.bmlBlockId);
            copy.start = this.start;
            copy.end = this.end;
            copy.playing = false;
            copy.pegs = this.pegs;
            return copy;
        }
        return null;
    }

    public void setStart(TimePeg s) {
        KeyPosition p = this.getKeyPosition("start");
        if (p == null) {
            p = new KeyPosition("start", 0.0, 1.0);
        }
        this.pegs.put(p, s);
        this.start = s;
    }

    public void setEnd(TimePeg s) {
        KeyPosition p = this.getKeyPosition("end");
        if (p == null) {
            p = new KeyPosition("end", 1.0, 1.0);
        }
        this.pegs.put(p, s);
        this.end = s;
    }

    public void setTimePeg(int kpIndex, TimePeg sp) {
        KeyPosition kp = this.mu.getKeyPositions().get(kpIndex);
        if (kp != null) {
            this.pegs.put(kp, sp);
        }
    }

    public void setTimePeg(KeyPosition kp, TimePeg sp) {
        this.pegs.put(kp, sp);
        if (kp.id.equals("start")) {
            this.setStart(sp);
        }
        if (kp.id.equals("end")) {
            this.setEnd(sp);
        }
    }

    public double getStartTime() {
        return this.start.getValue();
    }

    public TimePeg getStartPeg() {
        return this.start;
    }

    public TimePeg getEndPeg() {
        return this.end;
    }

    public double getEndTime() {
        return this.end.getValue();
    }

    protected boolean shouldPlay(double time) {
        return time >= this.start.getValue() && (time < this.end.getValue() || this.end.getValue() == -2.147483647E9) && this.start.getValue() != -2.147483647E9;
    }

    private void sendProgress(double t, double time) {
        for (KeyPosition k : this.mu.getKeyPositions()) {
            if (k.time <= t) {
                if (this.progressHandled.contains(k)) continue;
                String bmlId = this.bmlBlockId;
                String behaviorId = this.id;
                String syncId = k.id;
                String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
                this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, time));
                this.progressHandled.add(k);
                continue;
            }
            if (!this.progressHandled.contains(k)) continue;
            this.progressHandled.remove(k);
        }
    }

    public void play(double time) throws TMUPlayException {
        if (this.shouldPlay(time)) {
            double startSegmentTime = this.start.getValue();
            double startKeyTime = 0.0;
            double endSegmentTime = this.end.getValue();
            double endKeyTime = 1.0;
            for (KeyPosition k : this.pegs.keySet()) {
                TimePeg s = this.pegs.get(k);
                if (s == null || s.getValue() == -2.147483647E9) continue;
                if (s.getValue() <= time) {
                    startSegmentTime = s.getValue();
                    startKeyTime = k.time;
                    continue;
                }
                endSegmentTime = s.getValue();
                endKeyTime = k.time;
                break;
            }
            if (endSegmentTime == -2.147483647E9) {
                endSegmentTime = startSegmentTime;
                endKeyTime = startKeyTime;
            }
            double realDuration = endSegmentTime - startSegmentTime;
            double canDuration = endKeyTime - startKeyTime;
            double t = (time - startSegmentTime) / realDuration * canDuration + startKeyTime;
            try {
                this.mu.play(t);
            }
            catch (MUPlayException ex) {
                throw new TMUPlayException(ex.getLocalizedMessage(), this);
            }
            this.start(time);
            this.sendProgress(t, time);
        } else {
            this.stop(time);
        }
    }

    public void feedback(BMLSyncPointProgressFeedback fb) {
        for (BMLFeedbackListener fbl : this.feedbackListeners) {
            fbl.syncProgress(fb);
        }
    }

    public void addFeedbackListener(BMLFeedbackListener fb) {
        this.feedbackListeners.add(fb);
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void start(double time) {
        if (!this.playing) {
            this.progressHandled.clear();
        }
        this.playing = true;
    }

    public void stop(double time) {
        if (this.playing) {
            this.sendProgress(1.0, time);
        }
        this.playing = false;
    }

    public MotionUnit getMotionUnit() {
        return this.mu;
    }

    public Map<KeyPosition, TimePeg> getPegs() {
        return this.pegs;
    }

    public String getId() {
        return this.id;
    }

    public String getBMLId() {
        return this.bmlBlockId;
    }
}

