/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.keyframe;

import hmi.animation.SkeletonInterpolator;
import hmi.animation.VJoint;
import hmi.animation.VObject;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import java.util.ArrayList;
import java.util.HashMap;

public class KeyframeMU
implements MotionUnit {
    private SkeletonInterpolator ip;
    private ArrayList<KeyPosition> keyPositions = new ArrayList();
    private HashMap<String, String> parameters = new HashMap();

    public KeyframeMU(SkeletonInterpolator si) {
        this.ip = si;
    }

    @Override
    public ArrayList<KeyPosition> getKeyPositions() {
        return this.keyPositions;
    }

    @Override
    public double getPreferedDuration() {
        return this.ip.getEndTime() - this.ip.getStartTime();
    }

    @Override
    public void play(double t) {
        this.ip.time(this.ip.getStartTime() + this.getPreferedDuration() * t);
    }

    @Override
    public void setKeyPositions(ArrayList<KeyPosition> p) {
        this.keyPositions = p;
    }

    @Override
    public MotionUnit getPredictor(VJoint predict) {
        return this.copy(predict);
    }

    public MotionUnit copy(VJoint v) {
        VJoint[] empty = new VJoint[]{};
        ArrayList<VJoint> vjParts = new ArrayList<VJoint>();
        for (String s : this.ip.getPartIds()) {
            for (VJoint vj : v.getParts()) {
                if (!vj.getSid().equals(s)) continue;
                vjParts.add(vj);
            }
        }
        SkeletonInterpolator ipPredict = new SkeletonInterpolator(this.ip, (VObject[])vjParts.toArray(empty));
        KeyframeMU copy = new KeyframeMU(ipPredict);
        for (KeyPosition kp : this.keyPositions) {
            copy.keyPositions.add(kp);
        }
        return copy;
    }

    @Override
    public void setParameterValue(String name, float value) {
        this.parameters.put(name, "" + value);
    }

    @Override
    public void addKeyPosition(KeyPosition kp) {
        this.keyPositions.add(kp);
    }

    @Override
    public void setParameterValue(String name, String value) {
        this.parameters.put(name, value);
    }

    @Override
    public String getParameterValue(String name) {
        return this.parameters.get(name);
    }

    @Override
    public TimedMotionUnit createTMU(String i, String bmlId) {
        return new TimedMotionUnit(i, bmlId, this);
    }

    @Override
    public MotionUnit copy(AnimationPlayer p) {
        return this.copy(p.getVNext());
    }

    @Override
    public String getReplacementGroup() {
        return this.getParameterValue("replacementgroup");
    }
}

