/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.gesturebinding;

import hmi.animation.SkeletonInterpolator;
import hmi.elckerlyc.animationengine.TransitionMU;
import hmi.elckerlyc.animationengine.controller.CompoundController;
import hmi.elckerlyc.animationengine.controller.ControllerMU;
import hmi.elckerlyc.animationengine.keyframe.KeyframeMU;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.procanimation.ProcAnimationMU;
import hmi.physics.controller.PhysicalController;
import hmi.util.Resources;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;

public class MotionUnitAssembler
extends XMLStructureAdapter {
    private Resources resources;
    private MotionUnit motionUnit;
    public static final String XMLTAG = "MotionUnit";

    public MotionUnitAssembler(Resources r) {
        this.resources = r;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String type = this.getRequiredAttribute("type", attrMap, tokenizer);
        String file = this.getOptionalAttribute("file", attrMap, null);
        String className = this.getOptionalAttribute("class", attrMap, null);
        if (type.equals("ProcAnimation")) {
            ProcAnimationMU p = new ProcAnimationMU();
            if (file != null) {
                try {
                    p.readXML(this.resources.getReader(file));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.motionUnit = p;
            }
        } else if (type.equals("CompoundController")) {
            CompoundController cc = new CompoundController();
            if (file != null) {
                try {
                    cc.readXML(this.resources.getReader(file));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                ControllerMU p = new ControllerMU(cc, null);
                this.motionUnit = p;
            }
        } else if (type.equals("Keyframe")) {
            SkeletonInterpolator si;
            try {
                si = new SkeletonInterpolator(new XMLTokenizer((Reader)this.resources.getReader(file)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.motionUnit = new KeyframeMU(si);
        } else if (type.equals("PhysicalController")) {
            PhysicalController pc = null;
            if (className != null) {
                try {
                    pc = (PhysicalController)Class.forName(className).newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            ControllerMU p = new ControllerMU(pc, null);
            this.motionUnit = p;
        } else if (type.equals("Transition")) {
            TransitionMU t = null;
            if (className != null) {
                try {
                    t = (TransitionMU)Class.forName(className).newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            this.motionUnit = t;
        } else if (type.equals("class") && className != null) {
            try {
                this.motionUnit = (MotionUnit)Class.forName(className).newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public MotionUnit getMotionUnit() {
        return this.motionUnit;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

