/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.gesturebinding;

import hmi.bml.Behaviour;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.gesturebinding.MotionUnitParameterDefault;
import hmi.elckerlyc.animationengine.gesturebinding.MotionUnitSpec;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.util.Resources;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GestureBinding
extends XMLStructureAdapter {
    private ArrayList<MotionUnitSpec> specs = new ArrayList();
    private Resources resources;
    public static final String XMLTAG = "gesturebinding";

    public GestureBinding(Resources r) {
        this.resources = r;
    }

    public List<TimedMotionUnit> getMotionUnit(Behaviour b, AnimationPlayer player) {
        ArrayList<TimedMotionUnit> mus = new ArrayList<TimedMotionUnit>();
        for (MotionUnitSpec s : this.specs) {
            if (!s.type.equals(b.getXMLTag()) || !s.satisfiesConstraints(b)) continue;
            MotionUnit muCopy = s.motionUnit.copy(player);
            TimedMotionUnit tmu = muCopy.createTMU(b.id, b.fullId.split(":")[0]);
            mus.add(tmu);
            for (MotionUnitParameterDefault mupc : s.getParameterDefaults()) {
                muCopy.setParameterValue(mupc.name, mupc.value);
                System.out.println("Setting parameter " + mupc.name + "  to default " + mupc.value);
            }
            for (String param : s.getParameters()) {
                if (!b.specifiesParameter(param)) continue;
                String value = b.getStringParameterValue(param);
                muCopy.setParameterValue(s.getParameter(param), value);
                System.out.println("Setting parameter " + param + " mapped to " + s.getParameter(param));
            }
        }
        return mus;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (!tag.equals("MotionUnitSpec")) continue;
            MotionUnitSpec muSpec = new MotionUnitSpec(this.resources);
            muSpec.readXML(tokenizer);
            this.specs.add(muSpec);
        }
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

