/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.controller;

import hmi.elckerlyc.animationengine.controller.XMLController;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.controller.PhysicalController;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CompoundController
extends XMLStructureAdapter
implements PhysicalController {
    private Map<String, PhysicalController> requiredControllers = new HashMap<String, PhysicalController>();
    private Map<String, PhysicalController> desiredControllers = new HashMap<String, PhysicalController>();
    private String[] jointIDs = new String[0];
    private String[] desJointIDs = new String[0];
    private PhysicalHumanoid pHuman;
    public static final String XMLTAG = "CompoundController";

    public void reset() {
        for (PhysicalController controller : this.requiredControllers.values()) {
            controller.reset();
        }
        for (PhysicalController controller : this.desiredControllers.values()) {
            controller.reset();
        }
    }

    public void setPhysicalHumanoid(PhysicalHumanoid p) {
        this.pHuman = p;
        for (PhysicalController controller : this.requiredControllers.values()) {
            controller.setPhysicalHumanoid(p);
        }
        for (PhysicalController controller : this.desiredControllers.values()) {
            controller.setPhysicalHumanoid(p);
        }
    }

    public String[] getRequiredJointIDs() {
        return this.jointIDs;
    }

    public String[] getDesiredJointIDs() {
        return this.desJointIDs;
    }

    public CompoundController() {
    }

    public CompoundController(PhysicalHumanoid p) {
        this.setPhysicalHumanoid(p);
        this.reset();
    }

    public void update(double timeDiff) {
        for (PhysicalController controller : this.requiredControllers.values()) {
            controller.update(timeDiff);
        }
        for (PhysicalController controller : this.desiredControllers.values()) {
            boolean containsAllReq = true;
            for (String j : controller.getRequiredJointIDs()) {
                if (this.pHuman.getSegment(j) != null) continue;
                containsAllReq = false;
                break;
            }
            if (!containsAllReq) continue;
            controller.update(timeDiff);
        }
    }

    public PhysicalController copy(PhysicalHumanoid ph) {
        CompoundController c = new CompoundController(ph);
        for (String id : this.requiredControllers.keySet()) {
            c.addRequiredController(this.requiredControllers.get(id).copy(ph), id);
        }
        for (String id : this.desiredControllers.keySet()) {
            c.addDesiredController(this.desiredControllers.get(id).copy(ph), id);
        }
        return c;
    }

    public void addRequiredController(PhysicalController newController, String id) {
        this.requiredControllers.put(id, newController);
        List<String> idList = Arrays.asList(this.jointIDs);
        HashSet<String> idSet = new HashSet<String>();
        idSet.addAll(idList);
        for (String newId : newController.getRequiredJointIDs()) {
            if (idSet.contains(newId)) continue;
            idSet.add(newId);
        }
        this.jointIDs = idSet.toArray(new String[0]);
        List<String> desIdList = Arrays.asList(this.desJointIDs);
        HashSet<String> desIdSet = new HashSet<String>();
        idSet.addAll(desIdList);
        for (String newId : newController.getDesiredJointIDs()) {
            if (desIdSet.contains(newId)) continue;
            desIdSet.add(newId);
        }
        this.desJointIDs = desIdSet.toArray(new String[0]);
    }

    public void addDesiredController(PhysicalController newController, String id) {
        this.desiredControllers.put(id, newController);
        List<String> idList = Arrays.asList(this.desJointIDs);
        HashSet<String> idSet = new HashSet<String>();
        idSet.addAll(idList);
        for (String newId : newController.getRequiredJointIDs()) {
            if (idSet.contains(newId)) continue;
            idSet.add(newId);
        }
        this.desJointIDs = idSet.toArray(new String[0]);
        List<String> desIdList = Arrays.asList(this.desJointIDs);
        HashSet<String> desIdSet = new HashSet<String>();
        idSet.addAll(desIdList);
        for (String newId : newController.getDesiredJointIDs()) {
            if (desIdSet.contains(newId)) continue;
            desIdSet.add(newId);
        }
        this.desJointIDs = desIdSet.toArray(new String[0]);
    }

    public String getParameterValue(String name) {
        String[] splitName = name.split(":");
        if (splitName.length < 2) {
            throw new RuntimeException("Parameters in compound controller must always be prefixed with id of target controller and a colon.");
        }
        PhysicalController c = this.requiredControllers.get(splitName[0]);
        if (c == null) {
            c = this.desiredControllers.get(splitName[0]);
        }
        if (c == null) {
            return null;
        }
        return c.getParameterValue(splitName[1]);
    }

    public void setParameterValue(String name, String value) {
        String[] splitName = name.split(":");
        if (splitName.length < 2) {
            throw new RuntimeException("Parameters in compound controller must always be prefixed with id of target controller and a colon.");
        }
        PhysicalController c = this.requiredControllers.get(splitName[0]);
        if (c == null) {
            c = this.desiredControllers.get(splitName[0]);
        }
        if (c != null) {
            c.setParameterValue(splitName[1], value);
        }
    }

    public void setParameterValue(String name, float value) {
        String[] splitName = name.split(":");
        if (splitName.length < 2) {
            throw new RuntimeException("Parameters in compound controller must always be prefixed with id of target controller and a colon.");
        }
        PhysicalController c = this.requiredControllers.get(splitName[0]);
        if (c == null) {
            c = this.desiredControllers.get(splitName[0]);
        }
        if (c != null) {
            c.setParameterValue(splitName[1], value);
        }
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            XMLController xc;
            String tag = tokenizer.getTagName();
            if (tag.equals("required")) {
                tokenizer.takeSTag("required");
                while (tokenizer.atSTag("Controller")) {
                    xc = new XMLController();
                    xc.readXML(tokenizer);
                    this.addRequiredController(xc.getController(), xc.getId());
                }
                tokenizer.takeETag("required");
                continue;
            }
            if (tag.equals("desired")) {
                tokenizer.takeSTag("desired");
                while (tokenizer.atSTag("Controller")) {
                    xc = new XMLController();
                    xc.readXML(tokenizer);
                    this.addDesiredController(xc.getController(), xc.getId());
                }
                tokenizer.takeETag("desired");
                continue;
            }
            throw new RuntimeException("Unkown content tag in CompoundController XML");
        }
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

