/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.animation.VJoint;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.TransitionMU;
import hmi.math.Quat4f;
import java.util.ArrayList;
import java.util.List;

public class SlerpTransitionMU
extends TransitionMU {
    private float[] endPose;
    private float[] startPose;
    private float[] qResult;
    private AnimationPlayer player;
    private VJoint startJoint = null;

    public SlerpTransitionMU() {
    }

    public SlerpTransitionMU(List<VJoint> j, VJoint startJ, AnimationPlayer p) {
        this.joints = j;
        this.startJoint = startJ;
        this.qResult = new float[this.joints.size() * 4];
        this.endPose = new float[this.joints.size() * 4];
        this.startPose = new float[this.joints.size() * 4];
        this.player = p;
    }

    @Override
    public TransitionMU copy(AnimationPlayer player) {
        String sjid = this.startJoint == null ? player.getVNext().getSid() : this.startJoint.getSid();
        if (this.joints != null) {
            ArrayList<VJoint> newJoints = new ArrayList<VJoint>();
            for (VJoint vj : this.joints) {
                VJoint newJ = player.getVNext().getPart(vj.getSid());
                if (newJ == null) continue;
                this.joints.add(newJ);
            }
            return new SlerpTransitionMU(newJoints, player.getVNext().getPart(sjid), player);
        }
        return new SlerpTransitionMU(player.getVNext().getParts(), player.getVNext().getPart(sjid), player);
    }

    @Override
    public void setStartPose() {
        int i = 0;
        for (VJoint v : this.joints) {
            this.startJoint.getPart(v.getSid()).getRotation(this.startPose, i);
            System.out.println("start " + v.getId() + ": " + Quat4f.toString((float[])this.startPose, (int)i));
            i += 4;
        }
    }

    @Override
    public void play(double t) {
        if (this.startPose != null) {
            Quat4f.interpolateArrays((float[])this.qResult, (float[])this.startPose, (float[])this.endPose, (float)((float)t));
            int i = 0;
            for (VJoint vj : this.joints) {
                vj.setRotation(this.qResult, i);
                i += 4;
            }
        }
    }

    @Override
    public void setEndPose(double endTime, double duration) {
        int i = 0;
        this.player.predict(endTime);
        for (VJoint v : this.joints) {
            this.player.getVPredict().getPart(v.getSid()).getRotation(this.endPose, i);
            System.out.println("end " + v.getId() + ": " + Quat4f.toString((float[])this.endPose, (int)i));
            i += 4;
        }
    }
}

