/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.animationengine.PointingMU;
import hmi.elckerlyc.animationengine.motionunit.MUPlayException;
import hmi.elckerlyc.animationengine.motionunit.TMUPlayException;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;

public class PointingTMU
extends TimedMotionUnit {
    private PointingMU pmu;

    public PointingTMU(String i, String bmlId, PointingMU mu) {
        super(i, bmlId, mu);
        this.pmu = mu;
    }

    @Override
    public void play(double t) throws TMUPlayException {
        if (!this.isPlaying() && this.shouldPlay(t)) {
            try {
                double readyDuration;
                double readyTime = this.getPegTime("ready");
                double relaxTime = this.getPegTime("relax");
                if (readyTime != -2.147483647E9) {
                    readyDuration = readyTime - this.getStartTime();
                } else {
                    readyDuration = 1.0;
                    double afterReady = this.getNextPegTime("ready");
                    System.out.println("after ready: " + afterReady);
                    if (afterReady != -2.147483647E9) {
                        double preparationDur = afterReady - this.getPrevPegTime("ready");
                        System.out.println("preparationDur " + preparationDur);
                        if (readyDuration > preparationDur * 0.5) {
                            readyDuration = preparationDur * 0.5;
                        }
                    }
                    OffsetPeg tpReady = new OffsetPeg(this.getStartPeg(), readyDuration);
                    this.setTimePeg(this.getKeyPosition("ready"), (TimePeg)tpReady);
                }
                if (relaxTime != -2.147483647E9) {
                    double relaxDuration = this.getEndTime() - relaxTime;
                } else {
                    TimePeg endPeg;
                    double relaxDuration = readyDuration;
                    double retractionDur = this.getNextPegTime("relax") - this.getPrevPegTime("relax");
                    System.out.println("retractionDur: " + retractionDur + "=" + this.getNextPegTime("relax") + "-" + this.getPrevPegTime("relax"));
                    if (relaxDuration > retractionDur) {
                        relaxDuration = retractionDur;
                    }
                    if ((endPeg = this.getEndPeg()) != null && endPeg.getValue() != -2.147483647E9) {
                        OffsetPeg tpRelax = new OffsetPeg(endPeg, -relaxDuration);
                        this.setTimePeg(this.getKeyPosition("relax"), (TimePeg)tpRelax);
                    }
                }
                this.pmu.setStartPose(readyDuration);
            }
            catch (MUPlayException ex) {
                throw new TMUPlayException(ex.getLocalizedMessage(), this);
            }
        }
        super.play(t);
    }
}

