/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.animation.VJoint;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.TransitionMU;
import hmi.math.NumMath;
import hmi.math.Quat4f;
import hmi.math.QuatCurve;
import hmi.math.Vec3f;
import java.util.ArrayList;
import java.util.List;

public class HermiteSplineTransitionMU
extends TransitionMU {
    private AnimationPlayer player;
    private float[] qStart;
    private float[] qStartP;
    private float[] qStartN;
    private float[] qEnd;
    private float[] wStart;
    private float[] wEnd;
    private float[] qrate;
    private float[] q;

    public HermiteSplineTransitionMU() {
    }

    public HermiteSplineTransitionMU(List<VJoint> j, AnimationPlayer p) {
        this.player = p;
        this.joints = j;
        this.qStart = new float[4 * j.size()];
        this.qStartP = new float[4 * j.size()];
        this.qStartN = new float[4 * j.size()];
        this.qEnd = new float[4 * j.size()];
        this.qrate = new float[4 * j.size()];
        this.q = new float[4 * j.size()];
        this.wStart = new float[3 * j.size()];
        this.wEnd = new float[3 * j.size()];
        this.qEnd = new float[4 * j.size()];
        this.wEnd = new float[3 * j.size()];
    }

    @Override
    public TransitionMU copy(AnimationPlayer p) {
        if (this.joints != null) {
            ArrayList<VJoint> newJoints = new ArrayList<VJoint>();
            for (VJoint vj : this.joints) {
                VJoint newJ = p.getVNext().getPart(vj.getSid());
                if (newJ == null) continue;
                this.joints.add(newJ);
            }
            return new HermiteSplineTransitionMU(newJoints, p);
        }
        return new HermiteSplineTransitionMU(p.getVNext().getParts(), p);
    }

    @Override
    public void play(double t) {
        int i;
        for (i = 0; i < this.joints.size(); ++i) {
            QuatCurve.hermite((float[])this.qStart, (int)(i * 4), (float[])this.qEnd, (int)(i * 4), (float[])this.wStart, (int)(i * 3), (float[])this.wEnd, (int)(i * 3), (float)((float)t), (float[])this.q, (int)(i * 4));
        }
        i = 0;
        for (VJoint j : this.joints) {
            j.setRotation(this.q, i);
            i += 4;
        }
    }

    @Override
    public void setStartPose() {
        VJoint vCurrStart = this.player.getVNext();
        VJoint vPrevStart = this.player.getVPrev();
        VJoint vNextStart = this.player.getVCurr();
        int i = 0;
        for (VJoint v : this.joints) {
            vCurrStart.getPart(v.getSid()).getRotation(this.qStart, i);
            i += 4;
        }
        i = 0;
        for (VJoint v : this.joints) {
            vPrevStart.getPart(v.getSid()).getRotation(this.qStartP, i);
            i += 4;
        }
        i = 0;
        for (VJoint v : this.joints) {
            vNextStart.getPart(v.getSid()).getRotation(this.qStartN, i);
            i += 4;
        }
        for (i = 0; i < this.joints.size() * 4; ++i) {
            this.qrate[i] = NumMath.diff((float)this.qStartP[i], (float)this.qStartN[i], (float)this.player.getStepTime());
        }
        for (i = 0; i < this.joints.size(); ++i) {
            Quat4f.setAngularVelocityFromQuat4f((float[])this.wStart, (int)(i * 3), (float[])this.qStart, (int)(i * 4), (float[])this.qrate, (int)(i * 4));
            System.out.println(((VJoint)this.joints.get(i)).getId());
            System.out.println("wStart(" + i + ")" + Vec3f.toString((float[])this.wStart, (int)(i * 3)));
            System.out.println("wEnd(" + i + ")" + Vec3f.toString((float[])this.wEnd, (int)(i * 3)));
            System.out.println("qEnd(" + i + ")" + Quat4f.toString((float[])this.qEnd, (int)(i * 4)));
            System.out.println("qStart(" + i + ")" + Quat4f.toString((float[])this.qStart, (int)(i * 4)));
            System.out.println("qStartP(" + i + ")" + Quat4f.toString((float[])this.qStartP, (int)(i * 4)));
            System.out.println("qStartN(" + i + ")" + Quat4f.toString((float[])this.qStartN, (int)(i * 4)));
            System.out.println("qrate(" + i + ")" + Quat4f.toString((float[])this.qrate, (int)(i * 4)));
            System.out.println("-------------------------------------------------------");
        }
    }

    @Override
    public void setEndPose(double endTime, double duration) {
        for (int i = 0; i < this.joints.size(); ++i) {
            Vec3f.scale((float)((float)duration), (float[])this.wStart, (int)(i * 3));
        }
        int nrOfJoints = this.joints.size();
        float[] qPrev = new float[nrOfJoints * 4];
        float[] qNext = new float[nrOfJoints * 4];
        float[] qrate = new float[nrOfJoints * 4];
        int i = 0;
        VJoint pred = this.player.getVPredict();
        this.player.predict(endTime);
        for (VJoint j : this.joints) {
            pred.getPart(j.getSid()).getRotation(qPrev, i);
            i += 4;
        }
        i = 0;
        this.player.predict(endTime + (double)0.001f);
        for (VJoint j : this.joints) {
            pred.getPart(j.getSid()).getRotation(this.qEnd, i);
            i += 4;
        }
        i = 0;
        this.player.predict(endTime + (double)0.002f);
        for (VJoint j : this.joints) {
            pred.getPart(j.getSid()).getRotation(qNext, i);
            i += 4;
        }
        for (i = 0; i < nrOfJoints * 4; ++i) {
            qrate[i] = NumMath.diff((float)qPrev[i], (float)qNext[i], (float)0.001f);
        }
        for (i = 0; i < nrOfJoints; ++i) {
            Quat4f.setAngularVelocityFromQuat4f((float[])this.wEnd, (int)(i * 3), (float[])this.qEnd, (int)(i * 4), (float[])qrate, (int)(i * 4));
            Vec3f.scale((float)((float)duration), (float[])this.wEnd);
        }
    }
}

