/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.animationengine.GazeMU;
import hmi.elckerlyc.animationengine.motionunit.MUPlayException;
import hmi.elckerlyc.animationengine.motionunit.TMUPlayException;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;

public class GazeTMU
extends TimedMotionUnit {
    private GazeMU gmu;

    public GazeTMU(String i, String bmlId, GazeMU mu) {
        super(i, bmlId, mu);
        this.gmu = mu;
    }

    @Override
    public void play(double t) throws TMUPlayException {
        if (!this.isPlaying() && this.shouldPlay(t)) {
            try {
                double readyDuration;
                double readyTime = this.getPegTime("ready");
                double relaxTime = this.getPegTime("relax");
                if (readyTime != -2.147483647E9) {
                    readyDuration = readyTime - this.getStartTime();
                } else {
                    readyDuration = 1.0;
                    OffsetPeg tpReady = new OffsetPeg(this.getStartPeg(), readyDuration);
                    this.setTimePeg(this.getKeyPosition("ready"), (TimePeg)tpReady);
                }
                if (relaxTime != -2.147483647E9) {
                    double relaxDuration = readyTime - this.getStartTime();
                } else {
                    double relaxDuration = readyDuration;
                    TimePeg endPeg = this.getEndPeg();
                    if (endPeg != null && endPeg.getValue() != -2.147483647E9) {
                        OffsetPeg tpRelax = new OffsetPeg(endPeg, -relaxDuration);
                        this.setTimePeg(this.getKeyPosition("relax"), (TimePeg)tpRelax);
                    }
                }
                this.gmu.setStartPose(readyDuration);
            }
            catch (MUPlayException ex) {
                throw new TMUPlayException(ex.getLocalizedMessage(), this);
            }
        }
        super.play(t);
    }
}

