/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.animation.VJoint;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.GazeTMU;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.animationengine.motionunit.MUPlayException;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.util.timemanipulator.SigmoidManipulator;
import hmi.elckerlyc.util.timemanipulator.TimeManipulator;
import hmi.elckerlyc.world.WorldObject;
import hmi.elckerlyc.world.WorldObjectManager;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.neurophysics.DondersLaw;
import hmi.neurophysics.EyeSaturation;
import hmi.neurophysics.ListingsLaw;
import java.util.ArrayList;

public class GazeMU
implements MotionUnit {
    protected float[] qGaze;
    protected float[] qTemp;
    protected float[] qStart;
    protected float[] vecTemp;
    protected ArrayList<KeyPosition> keys = new ArrayList();
    protected KeyPosition ready;
    protected KeyPosition relax;
    protected VJoint neck;
    protected VJoint rEye;
    protected VJoint lEye;
    protected AnimationPlayer player;
    protected WorldObjectManager woManager;
    protected String target;
    protected TimeManipulator tmp;
    protected WorldObject woTarget;
    protected double preparationDuration;

    public GazeMU() {
        this.qGaze = new float[4];
        this.qTemp = new float[4];
        this.qStart = new float[4];
        this.vecTemp = new float[3];
        this.ready = new KeyPosition("ready", 0.25, 1.0);
        this.relax = new KeyPosition("relax", 0.75, 1.0);
        this.keys.add(this.ready);
        this.keys.add(this.relax);
        this.target = "";
        this.tmp = new SigmoidManipulator(5.0, 1.0);
    }

    @Override
    public GazeMU copy(AnimationPlayer p) {
        GazeMU gmu = new GazeMU();
        gmu.neck = p.getVNext().getPart("skullbase");
        gmu.lEye = p.getVNext().getPart("l_eyeball_joint");
        gmu.rEye = p.getVNext().getPart("r_eyeball_joint");
        gmu.player = p;
        gmu.woManager = p.getWoManager();
        gmu.target = this.target;
        return gmu;
    }

    public void setTarget(String target) throws MUPlayException {
        this.woTarget = this.woManager.getWorldObject(target);
        if (this.woTarget == null) {
            throw new MUPlayException("Gaze target not found", this);
        }
        this.woTarget.getTranslation2(this.vecTemp, this.neck);
        this.setEndRotation(this.vecTemp);
    }

    public void setStartPose(double prepDur) throws MUPlayException {
        this.preparationDuration = prepDur;
        this.player.getVCurr().getPart("skullbase").getRotation(this.qStart);
        this.setTarget(this.target);
    }

    public void setEndRotation(float[] gazeDir) {
        float[] normDir = new float[3];
        Vec3f.normalize((float[])normDir, (float[])gazeDir);
        DondersLaw.dondersHead((float[])normDir, (float[])this.qGaze);
    }

    public void setEndRotation(float[] gazeDir, float[] q) {
        float[] normDir = new float[3];
        Vec3f.normalize((float[])normDir, (float[])gazeDir);
        DondersLaw.dondersHead((float[])normDir, (float[])q);
    }

    @Override
    public void addKeyPosition(KeyPosition kp) {
        this.keys.add(kp);
    }

    @Override
    public ArrayList<KeyPosition> getKeyPositions() {
        return this.keys;
    }

    @Override
    public void setKeyPositions(ArrayList<KeyPosition> p) {
        this.keys = p;
    }

    @Override
    public MotionUnit getPredictor(VJoint predict) {
        GazeMU predictor = this.copy(this.player);
        predictor.neck = predict.getPart("skullbase");
        Quat4f.set((float[])predictor.qStart, (float[])Quat4f.getIdentity());
        return predictor;
    }

    @Override
    public double getPreferedDuration() {
        return 0.0;
    }

    private void playEye(double t, float[] qDesNeck, VJoint eye) throws MUPlayException {
        float[] gazeDir = Vec3f.getVec3f();
        this.woTarget = this.woManager.getWorldObject(this.target);
        if (this.woTarget == null) {
            throw new MUPlayException("Gaze target not found", this);
        }
        this.woTarget.getTranslation2(gazeDir, this.neck);
        Vec3f.normalize((float[])gazeDir);
        float[] eyeRotationDes = Quat4f.getQuat4f();
        float[] qDesNeckConj = Quat4f.getQuat4f();
        Quat4f.conjugate((float[])qDesNeckConj, (float[])qDesNeck);
        Quat4f.transformVec3f((float[])qDesNeckConj, (float[])gazeDir);
        ListingsLaw.listingsEye((float[])gazeDir, (float[])eyeRotationDes);
        System.out.println("gazeDir: " + Vec3f.toString((float[])gazeDir) + "Eye gaze quat des: " + Quat4f.toString((float[])eyeRotationDes));
        float[] eyeRotationSpace = Quat4f.getQuat4f();
        Quat4f.mul((float[])eyeRotationSpace, (float[])qDesNeck, (float[])eyeRotationDes);
        float[] eyeRotationDesCur = Quat4f.getQuat4f();
        float[] qNeck = Quat4f.getQuat4f();
        this.neck.getRotation(qNeck);
        Quat4f.conjugate((float[])qNeck);
        Quat4f.mul((float[])eyeRotationDesCur, (float[])qNeck, (float[])eyeRotationSpace);
        float[] eyeRotationSat = Quat4f.getQuat4f();
        EyeSaturation.sat((float[])eyeRotationDesCur, (float[])eyeRotationDes, (float[])eyeRotationSat);
        System.out.println("eyeRotationDesCur: " + Quat4f.toString((float[])eyeRotationDesCur) + "eyeRotationDes: " + Quat4f.toString((float[])eyeRotationDes) + "eyeRotationSat: " + Quat4f.toString((float[])eyeRotationSat));
        if (t < 0.25) {
            float[] qCurr = Quat4f.getQuat4f();
            eye.getRotation(qCurr);
            double remDuration = (0.25 - t) / 0.25 * this.preparationDuration;
            float deltaT = (float)((double)this.player.getStepTime() / remDuration);
            Quat4f.interpolate((float[])this.qTemp, (float[])qCurr, (float[])eyeRotationSat, (float)deltaT);
            eye.setRotation(this.qTemp);
        } else if (!(t > 0.75)) {
            System.out.println("Gaze at target");
            eye.setRotation(eyeRotationSat);
        }
    }

    @Override
    public void play(double t) throws MUPlayException {
        if (this.rEye != null && this.lEye != null) {
            this.playEye(t, this.qGaze, this.lEye);
            this.playEye(t, this.qGaze, this.rEye);
        }
        if (t < 0.25) {
            float tManip = (float)this.tmp.manip(t / 0.25);
            Quat4f.interpolate((float[])this.qTemp, (float[])this.qStart, (float[])this.qGaze, (float)tManip);
            this.neck.setRotation(this.qTemp);
        } else if (t > 0.75) {
            float tManip = (float)this.tmp.manip((t - 0.75) / 0.25);
            Quat4f.interpolate((float[])this.qTemp, (float[])this.qGaze, (float[])this.qStart, (float)tManip);
            this.neck.setRotation(this.qTemp);
        } else {
            this.neck.setRotation(this.qGaze);
        }
    }

    @Override
    public TimedMotionUnit createTMU(String i, String bmlId) {
        return new GazeTMU(i, bmlId, this);
    }

    @Override
    public void setParameterValue(String name, String value) {
        if (name.equals("target")) {
            this.target = value;
        }
    }

    @Override
    public String getParameterValue(String name) {
        if (name.equals("target")) {
            return this.target;
        }
        return null;
    }

    @Override
    public void setParameterValue(String name, float value) {
    }

    public void setTimeManipulator(TimeManipulator tmp) {
        this.tmp = tmp;
    }

    @Override
    public String getReplacementGroup() {
        return "gaze";
    }
}

