/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.animation.AnalyticalIKSolver;
import hmi.animation.VJoint;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.PointingMU;
import hmi.math.Quat4f;

public class DynamicPointingMU
extends PointingMU {
    private float[] qCurrSh = new float[4];
    private float[] qCurrElb = new float[4];

    @Override
    public DynamicPointingMU copy(AnimationPlayer p) {
        DynamicPointingMU pmu = new DynamicPointingMU();
        pmu.shoulderId = this.shoulderId;
        pmu.elbowId = this.elbowId;
        pmu.vjShoulder = p.getVNext().getPart(this.shoulderId);
        pmu.vjShoulder = p.getVNext().getPart(this.elbowId);
        pmu.vjWrist = p.getVNext().getPart(this.wristId);
        pmu.player = p;
        pmu.woManager = p.getWoManager();
        pmu.target = this.target;
        return pmu;
    }

    @Override
    public void play(double t) {
        this.woTarget.getTranslation(this.vecTemp, null);
        AnalyticalIKSolver.translateToLocalSystem(null, (VJoint)this.vjShoulder, (float[])this.vecTemp, (float[])this.vecTemp2);
        this.setEndRotation(this.vecTemp2);
        if (t < 0.25) {
            double remDuration = (0.25 - t) / 0.25 * this.preparationDuration;
            float deltaT = (float)((double)this.player.getStepTime() / remDuration);
            this.vjShoulder.getRotation(this.qCurrSh);
            Quat4f.interpolate((float[])this.qTemp, (float[])this.qCurrSh, (float[])this.qShoulder, (float)deltaT);
            this.vjShoulder.setRotation(this.qTemp);
            this.vjElbow.getRotation(this.qCurrElb);
            Quat4f.interpolate((float[])this.qTemp, (float[])this.qCurrElb, (float[])this.qElbow, (float)deltaT);
            this.vjElbow.setRotation(this.qTemp);
        } else if (t > 0.75) {
            float tManip = (float)this.tmp.manip((t - 0.75) / 0.25);
            Quat4f.interpolate((float[])this.qTemp, (float[])this.qShoulder, (float[])Quat4f.getIdentity(), (float)tManip);
            this.vjShoulder.setRotation(this.qTemp);
            Quat4f.interpolate((float[])this.qTemp, (float[])this.qElbow, (float[])Quat4f.getIdentity(), (float)tManip);
            this.vjElbow.setRotation(this.qTemp);
        } else {
            this.vjShoulder.setRotation(this.qShoulder);
            this.vjElbow.setRotation(this.qElbow);
        }
    }
}

