/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.animation.SkeletonPose;
import hmi.animation.VJoint;
import hmi.animation.VObject;
import hmi.animation.VObjectTransformCopier;
import hmi.elckerlyc.animationengine.AnimationPlanPlayer;
import hmi.elckerlyc.animationengine.TMUWarningCallback;
import hmi.elckerlyc.animationengine.mixed.MixedPlayer;
import hmi.elckerlyc.animationengine.mixed.MixedSystem;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.feedback.BMLWarningFeedback;
import hmi.elckerlyc.feedback.BMLWarningListener;
import hmi.elckerlyc.world.WorldObjectManager;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalJoint;
import hmi.physics.PhysicalSegment;
import hmi.physics.PhysicsSync;
import hmi.physics.controller.PhysicalController;
import java.util.ArrayList;
import java.util.List;

public class AnimationPlayer
implements TMUWarningCallback {
    private VJoint vPrev;
    private VJoint vCurr;
    private VJoint vNext;
    private VJoint vPredict;
    private PhysicalHumanoid pHuman;
    private VObjectTransformCopier votcCurrToPrev;
    private VObjectTransformCopier votcNextToCurr;
    private boolean prevValid;
    private ArrayList<PhysicalController> controllers = new ArrayList();
    private AnimationPlanPlayer app;
    private AnimationPlanPlayer appPredict;
    private ArrayList<MixedSystem> mSystems;
    private MixedPlayer mPlayer;
    private float stepTime;
    private SkeletonPose vPrevStartPose;
    private SkeletonPose vCurrStartPose;
    private SkeletonPose vNextStartPose;
    private boolean prevValidOld = false;
    protected WorldObjectManager woManager;
    protected List<BMLWarningListener> warningListeners = new ArrayList<BMLWarningListener>();
    private List<TimedMotionUnit> tmuRemove = new ArrayList<TimedMotionUnit>();

    public AnimationPlayer(VJoint vP, VJoint vC, VJoint vN, VJoint vPred, ArrayList<MixedSystem> m, float h) {
        this(vP, vC, vN, vPred, m, h, null);
    }

    public AnimationPlayer(VJoint vP, VJoint vC, VJoint vN, VJoint vPred, ArrayList<MixedSystem> m, float h, WorldObjectManager wom) {
        this.vPrev = vP;
        this.vCurr = vC;
        this.vNext = vN;
        this.woManager = wom;
        this.vPredict = vPred;
        VJoint[] emptyArray = new VJoint[]{};
        this.vPrevStartPose = new SkeletonPose((VObject[])this.vPrev.getParts().toArray(emptyArray), "TR");
        this.vCurrStartPose = new SkeletonPose((VObject[])this.vCurr.getParts().toArray(emptyArray), "TR");
        this.vNextStartPose = new SkeletonPose((VObject[])this.vNext.getParts().toArray(emptyArray), "TR");
        this.vPrevStartPose.setFromTarget();
        this.vCurrStartPose.setFromTarget();
        this.vNextStartPose.setFromTarget();
        this.mSystems = m;
        this.pHuman = this.mSystems.get(0).getPHuman();
        this.pHuman.setEnabled(true);
        this.votcNextToCurr = VObjectTransformCopier.newInstanceFromVJointTree((VJoint)this.vNext, (VJoint)this.vCurr, (String)"T1R");
        this.votcCurrToPrev = VObjectTransformCopier.newInstanceFromVJointTree((VJoint)this.vCurr, (VJoint)this.vPrev, (String)"T1R");
        this.mPlayer = new MixedPlayer(this.mSystems.get(0), this.vPrev, this.vCurr, this.vNext);
        this.mPlayer.setH(h);
        this.stepTime = h;
        this.app = new AnimationPlanPlayer();
        this.appPredict = new AnimationPlanPlayer();
        this.prevValid = false;
    }

    private List<TimedMotionUnit> getTimedMotionUnits() {
        return this.app.getTimedMotionUnits();
    }

    public synchronized int getNumberOfTimedMotionUnits() {
        return this.getTimedMotionUnits().size();
    }

    public synchronized void removeTimedMotionUnit(String id, String bmlId) {
        this.app.removeTimedMotionUnit(id, bmlId);
        this.appPredict.removeTimedMotionUnit(id, bmlId);
    }

    public WorldObjectManager getWoManager() {
        return this.woManager;
    }

    public synchronized void addTimedMotionUnit(TimedMotionUnit tmu) {
        this.app.addTimedMotionUnit(tmu);
        TimedMotionUnit tmuPred = tmu.getPredictor(this.vPredict);
        if (tmuPred != null) {
            this.appPredict.addTimedMotionUnit(tmuPred);
        }
    }

    public synchronized void predict(double time) {
        System.out.println("Predicting at " + time);
        this.appPredict.play(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        this.prevValid = false;
        this.vPrevStartPose.setToTarget();
        this.vCurrStartPose.setToTarget();
        this.vNextStartPose.setToTarget();
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            for (PhysicalController p : this.controllers) {
                p.reset();
            }
            for (MixedSystem ms : this.mSystems) {
                ms.reset(this.vNext);
            }
        }
    }

    public synchronized List<String> getInvalidBehaviors() {
        ArrayList<String> invalidBehaviours = new ArrayList<String>();
        for (TimedMotionUnit tmu : this.getTimedMotionUnits()) {
            if (tmu.hasValidTiming()) continue;
            invalidBehaviours.add(tmu.getBMLId() + ":" + tmu.getId());
        }
        return invalidBehaviours;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setResetPose() {
        this.vNextStartPose.setFromTarget();
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            for (MixedSystem ms : this.mSystems) {
                ms.setResetPose(this.vNext);
                ms.reset(this.vNext);
            }
        }
    }

    public synchronized void warn(BMLWarningFeedback w) {
        for (BMLWarningListener wl : this.warningListeners) {
            wl.warn(w);
        }
    }

    public synchronized void addWarningListener(BMLWarningListener ws) {
        this.warningListeners.add(ws);
    }

    public synchronized void removeAllWarningListeners() {
        this.warningListeners.clear();
    }

    @Override
    public void tmuWarning(TimedMotionUnit timedMU, String message) {
        this.tmuRemove.add(timedMU);
        String bmlId = timedMU.getBMLId();
        String id = "w-" + timedMU.getId();
        ArrayList<String> modifiedBehaviours = new ArrayList<String>();
        modifiedBehaviours.add(timedMU.getId());
        ArrayList<String> modifiedConstraints = new ArrayList<String>();
        String warningText = message + "\nBehavior " + timedMU.getBMLId() + ":" + timedMU.getId() + " dropped.";
        this.warn(new BMLWarningFeedback(id, bmlId, modifiedBehaviours, modifiedConstraints, warningText));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void step(float prevTime) {
        this.controllers.clear();
        this.prevValidOld = this.prevValid;
        this.tmuRemove.clear();
        if (this.prevValid) {
            this.votcCurrToPrev.copyConfig();
            this.votcNextToCurr.copyConfig();
            this.app.play(prevTime, this);
        } else {
            this.app.play(prevTime, this);
            this.votcNextToCurr.copyConfig();
            this.votcCurrToPrev.copyConfig();
            this.prevValid = true;
        }
        for (TimedMotionUnit tmuR : this.tmuRemove) {
            this.removeTimedMotionUnit(tmuR.getId(), tmuR.getBMLId());
        }
        ArrayList<String> controlledJoints = new ArrayList<String>();
        for (PhysicalController p : this.controllers) {
            for (String jid : p.getRequiredJointIDs()) {
                if (controlledJoints.contains(jid)) continue;
                controlledJoints.add(jid);
            }
        }
        ArrayList<String> desiredJoints = new ArrayList<String>();
        for (PhysicalController p : this.controllers) {
            for (String jid : p.getDesiredJointIDs()) {
                if (desiredJoints.contains(jid) || controlledJoints.contains(jid)) continue;
                desiredJoints.add(jid);
            }
        }
        MixedSystem bestMatch = this.mPlayer.getSystem();
        int jointsInPH = Integer.MAX_VALUE;
        int nrOfDesiredJoints = -1;
        boolean foundMatch = false;
        for (MixedSystem m : this.mSystems) {
            PhysicalHumanoid ph = m.getPHuman();
            boolean foundAll = true;
            for (String jid : controlledJoints) {
                boolean found = false;
                if (ph.rootSegment != null && ph.rootSegment.getSid().equals(jid)) {
                    found = true;
                    break;
                }
                for (PhysicalJoint pj : ph.joints) {
                    if (!pj.getName().equals(jid)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                foundAll = false;
                break;
            }
            if (!foundAll) continue;
            int dJoints = 0;
            block11: for (String jid : desiredJoints) {
                if (ph.rootSegment != null && ph.rootSegment.getSid().equals(jid)) {
                    ++dJoints;
                    continue;
                }
                for (PhysicalJoint pj : ph.joints) {
                    if (!pj.getName().equals(jid)) continue;
                    ++dJoints;
                    continue block11;
                }
            }
            if (dJoints > nrOfDesiredJoints) {
                nrOfDesiredJoints = dJoints;
                bestMatch = m;
                jointsInPH = ph.joints.size();
                foundMatch = true;
                continue;
            }
            if (dJoints != nrOfDesiredJoints || ph.joints.size() >= jointsInPH) continue;
            bestMatch = m;
            jointsInPH = ph.joints.size();
            foundMatch = true;
        }
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            if (!foundMatch) {
                System.out.println("Could not find a mixed system that contains joints: " + controlledJoints);
            }
            if (bestMatch != this.mPlayer.getSystem()) {
                System.out.println("Switching system " + prevTime);
                this.mPlayer.switchSystem(bestMatch, this.stepTime, this.vPrev, this.vCurr, this.vNext, this.prevValidOld);
                this.pHuman.setEnabled(false);
                this.pHuman = this.mPlayer.getSystem().getPHuman();
                this.pHuman.setEnabled(true);
                for (PhysicalController p : this.controllers) {
                    p.setPhysicalHumanoid(this.pHuman);
                }
            }
            this.mPlayer.play(this.stepTime);
            this.pHuman.updateCOM(this.stepTime);
            for (PhysicalController p : this.controllers) {
                p.setPhysicalHumanoid(this.pHuman);
                p.update((double)this.stepTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void copyPhysics() {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.pHuman.copy();
            float[] q = new float[4];
            float[] tr = new float[3];
            for (PhysicalSegment ps : this.pHuman.getSegments()) {
                VJoint vC = this.vCurr.getPart(ps.getSid());
                VJoint vN = this.vNext.getPart(ps.getSid());
                vC.getRotation(q);
                vN.setRotation(q);
                if (!ps.getSid().equals("HumanoidRoot")) continue;
                vC.getTranslation(tr);
                vN.setTranslation(tr);
            }
        }
    }

    public synchronized ArrayList<PhysicalController> getControllers() {
        return this.controllers;
    }

    public VJoint getVNext() {
        return this.vNext;
    }

    public VJoint getVPrev() {
        return this.vPrev;
    }

    public VJoint getVCurr() {
        return this.vCurr;
    }

    public VJoint getVPredict() {
        return this.vPredict;
    }

    public synchronized PhysicalHumanoid getPHuman() {
        return this.pHuman;
    }

    public synchronized float getStepTime() {
        return this.stepTime;
    }

    public synchronized void clearAll() {
        this.app.clearAll();
        if (this.appPredict != null) {
            this.appPredict.clearAll();
        }
    }

    public ArrayList<MixedSystem> getMixedSystems() {
        return this.mSystems;
    }
}

