/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.bml.Behaviour;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.Planner;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimePegAndConstraint;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.gesturebinding.GestureBinding;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.feedback.BMLFeedbackListener;
import java.util.ArrayList;
import java.util.List;

public class AnimationPlanner
implements Planner {
    private AnimationPlayer player;
    private GestureBinding gestureBinding;
    protected ArrayList<BMLFeedbackListener> feedbackListeners = new ArrayList();

    public AnimationPlanner(AnimationPlayer p, GestureBinding g) {
        this.gestureBinding = g;
        this.player = p;
    }

    public void addFeedbackListener(BMLFeedbackListener fb) {
        this.feedbackListeners.add(fb);
    }

    public void removeAllFeedbackListeners() {
        this.feedbackListeners.clear();
    }

    @Override
    public List<SyncAndTimePeg> addBehaviour(Behaviour b, ArrayList<TimePegAndConstraint> sacs, Object planElement) throws BehaviourPlanningException {
        TimedMotionUnit tmu;
        ArrayList<SyncAndTimePeg> satps = new ArrayList<SyncAndTimePeg>();
        if (planElement == null) {
            List<TimedMotionUnit> tmus = this.gestureBinding.getMotionUnit(b, this.player);
            if (tmus.isEmpty()) {
                throw new BehaviourPlanningException(b, "Behavior " + b.id + " could not be constructed from the gesture binding, behavior omitted.");
            }
            tmu = tmus.get(0);
        } else {
            tmu = (TimedMotionUnit)planElement;
        }
        this.resolveDefaultBMLKeyPositions(tmu);
        this.linkSynchs(tmu, sacs);
        for (BMLFeedbackListener fb : this.feedbackListeners) {
            tmu.addFeedbackListener(fb);
        }
        this.player.addTimedMotionUnit(tmu);
        for (KeyPosition kp : tmu.getPegs().keySet()) {
            TimePeg p = tmu.getPegs().get(kp);
            satps.add(new SyncAndTimePeg(kp.id, b.id, b.bmlId, p));
        }
        return satps;
    }

    public void resolveDefaultBMLKeyPositions(TimedMotionUnit tmu) {
        double left = 0.0;
        double right = 1.0;
        KeyPosition kp = tmu.getKeyPosition("start");
        if (kp == null) {
            tmu.getMotionUnit().addKeyPosition(new KeyPosition("start", 0.0, 0.0));
        }
        if ((kp = tmu.getKeyPosition("end")) == null) {
            tmu.getMotionUnit().addKeyPosition(new KeyPosition("end", 1.0, 1.0));
        }
        if ((kp = tmu.getKeyPosition("ready")) == null) {
            tmu.getMotionUnit().addKeyPosition(new KeyPosition("ready", 0.0, 0.01));
        } else {
            left = kp.time;
        }
        kp = tmu.getKeyPosition("relax");
        if (kp == null) {
            tmu.getMotionUnit().addKeyPosition(new KeyPosition("relax", 1.0, 0.01));
        } else {
            right = kp.time;
        }
        kp = tmu.getKeyPosition("stroke-start");
        if (kp == null) {
            tmu.getMotionUnit().addKeyPosition(new KeyPosition("stroke-start", left, 0.01));
        } else {
            left = kp.time;
        }
        kp = tmu.getKeyPosition("stroke-end");
        if (kp == null) {
            tmu.getMotionUnit().addKeyPosition(new KeyPosition("stroke-end", right, 0.01));
        }
        if ((kp = tmu.getKeyPosition("stroke")) == null) {
            tmu.getMotionUnit().addKeyPosition(new KeyPosition("stroke", left, 0.01));
        }
    }

    @Override
    public Object resolveSynchs(Behaviour b, ArrayList<TimePegAndConstraint> sac) throws BehaviourPlanningException {
        List<TimedMotionUnit> tmus = this.gestureBinding.getMotionUnit(b, this.player);
        if (tmus.isEmpty()) {
            throw new BehaviourPlanningException(b, "Behavior " + b.id + " could not be constructed from the gesture binding, behavior omitted.");
        }
        TimedMotionUnit tmu = tmus.get(0);
        this.resolveDefaultBMLKeyPositions(tmu);
        ArrayList<TimePegAndConstraint> sortedSac = new ArrayList<TimePegAndConstraint>();
        block0: for (KeyPosition kp : tmu.getMotionUnit().getKeyPositions()) {
            for (TimePegAndConstraint s : sac) {
                if (!s.id.equals(kp.id)) continue;
                sortedSac.add(s);
                continue block0;
            }
        }
        this.linkSynchs(tmu, sortedSac);
        int sections = 0;
        double totalStretch = 0.0;
        TimePegAndConstraint sPrev = null;
        for (TimePegAndConstraint s : sortedSac) {
            if (s.peg.getValue() == -2.147483647E9) continue;
            if (sPrev != null) {
                double duration = tmu.getPegTime(s.id) - tmu.getPegTime(sPrev.id);
                double startKey = 0.0;
                double endKey = 0.0;
                for (KeyPosition kp : tmu.getPegs().keySet()) {
                    if (tmu.getPegs().get(kp).getLink() == sPrev.peg.getLink()) {
                        startKey = kp.time;
                    }
                    if (tmu.getPegs().get(kp).getLink() != s.peg.getLink()) continue;
                    endKey = kp.time;
                }
                double nominalDuration = (endKey - startKey) * tmu.getMotionUnit().getPreferedDuration();
                if (!(nominalDuration > 0.0)) continue;
                totalStretch += duration / nominalDuration;
                ++sections;
                continue;
            }
            sPrev = s;
        }
        double avgStretch = 1.0;
        if (sections > 0) {
            avgStretch = totalStretch / (double)sections;
        }
        if (sortedSac.size() > 0) {
            TimePegAndConstraint sacStart = sortedSac.get(0);
            if (sacStart.peg.getValue() == -2.147483647E9) {
                TimePegAndConstraint sacNext = null;
                for (TimePegAndConstraint s : sortedSac) {
                    if (s.peg.getValue() == -2.147483647E9) continue;
                    sacNext = s;
                    break;
                }
                if (sacNext == null) {
                    sacStart.peg.setValue(0.0);
                } else {
                    double nextKey = tmu.getKeyPosition((String)sacNext.id).time;
                    double nextTime = tmu.getPegTime(sacNext.id);
                    double tStart = nextTime - nextKey * avgStretch * tmu.mu.getPreferedDuration();
                    if (sacStart.resolveAsStartOffset) {
                        OffsetPeg os = (OffsetPeg)sacStart.peg;
                        os.setLink(tmu.getTimePeg(sacNext.id));
                        os.setOffset(tStart - nextTime);
                    } else {
                        sacStart.peg.setValue(tStart + sacStart.offset);
                    }
                }
            }
            TimePegAndConstraint sacEnd = sortedSac.get(sortedSac.size() - 1);
            if (sacEnd.peg.getValue() == -2.147483647E9) {
                TimePegAndConstraint sacPrev = null;
                for (TimePegAndConstraint s : sortedSac) {
                    if (s.peg.getValue() == -2.147483647E9) continue;
                    sacPrev = s;
                }
                if (sacPrev == null) {
                    sacEnd.peg.setValue(tmu.getMotionUnit().getPreferedDuration());
                } else {
                    double prevDur = 1.0 - tmu.getKeyPosition((String)sacPrev.id).time;
                    sacEnd.peg.setValue(tmu.getPegTime(sacPrev.id) + prevDur * avgStretch * tmu.mu.getPreferedDuration() + sacEnd.offset);
                }
            }
            TimePegAndConstraint sacPrev = sacStart;
            TimePegAndConstraint sacNext = null;
            for (TimePegAndConstraint s : sortedSac) {
                if (s.peg.getValue() == -2.147483647E9) {
                    for (TimePegAndConstraint s2 : sortedSac.subList(sortedSac.indexOf(s), sortedSac.size())) {
                        if (s2.peg.getValue() == -2.147483647E9) continue;
                        sacNext = s2;
                        break;
                    }
                    double keyPrev = tmu.getKeyPosition((String)sacPrev.id).time;
                    double keyNext = tmu.getKeyPosition((String)sacNext.id).time;
                    double keyCurr = tmu.getKeyPosition((String)s.id).time;
                    double timePrev = tmu.getPegTime(sacPrev.id);
                    double timeNext = tmu.getPegTime(sacNext.id);
                    s.peg.setValue(timePrev + (keyCurr - keyPrev) * (timeNext - timePrev) / (keyNext - keyPrev) + s.offset);
                }
                sacPrev = s;
            }
            sacEnd = sortedSac.get(sortedSac.size() - 1);
            System.out.println(sacEnd.id);
            if (!sacEnd.id.equals("end") && tmu.mu.getPreferedDuration() > 0.0) {
                double keyPrev = tmu.getKeyPosition((String)sacEnd.id).time;
                double keyEnd = tmu.getKeyPosition((String)"end").time;
                System.out.println("Behavior: " + b);
                System.out.println("sacEnd: " + sacEnd.id);
                System.out.println("keypos " + tmu.mu.getKeyPositions());
                System.out.println("keyEnd-keyPrev" + (keyEnd - keyPrev) + " stretch " + avgStretch);
                System.out.println("adding offset peg to tmu, offset " + (keyEnd - keyPrev) * avgStretch * tmu.mu.getPreferedDuration() + "peg: " + sacEnd.peg.toString());
                OffsetPeg op = new OffsetPeg(tmu.getTimePeg(sacEnd.id), (keyEnd - keyPrev) * avgStretch * tmu.mu.getPreferedDuration());
                tmu.setEnd(op);
            }
        }
        return tmu;
    }

    @Override
    public void clearAll() {
        this.player.clearAll();
    }

    private void linkSynchs(TimedMotionUnit tmu, ArrayList<TimePegAndConstraint> sacs) {
        for (TimePegAndConstraint s : sacs) {
            for (KeyPosition kp : tmu.getMotionUnit().getKeyPositions()) {
                if (!s.id.equals(kp.id)) continue;
                if (s.offset == 0.0) {
                    tmu.setTimePeg(kp, s.peg);
                    continue;
                }
                tmu.setTimePeg(kp, (TimePeg)new OffsetPeg(s.peg, -s.offset));
            }
        }
    }

    @Override
    public void removeBehaviour(String behaviourId, String BMLId) {
        this.player.removeTimedMotionUnit(behaviourId, BMLId);
    }

    @Override
    public List<String> getInvalidBehaviours() {
        return this.player.getInvalidBehaviors();
    }
}

