/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.elckerlyc.animationengine.TMUWarningCallback;
import hmi.elckerlyc.animationengine.motionunit.TMUPlayException;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import java.util.ArrayList;
import java.util.Collection;

public class AnimationPlanPlayer {
    private ArrayList<TimedMotionUnit> timedMotionUnits = new ArrayList();
    private ArrayList<TimedMotionUnit> playingMotionUnits = new ArrayList();

    private boolean updatePlayingMU(TimedMotionUnit tmu, TMUWarningCallback tmuWc, double t) {
        ArrayList<TimedMotionUnit> remove = new ArrayList<TimedMotionUnit>();
        boolean play = true;
        TimedMotionUnit replacementOverlap = null;
        for (TimedMotionUnit tmuPlay : this.playingMotionUnits) {
            if (tmuPlay.mu.getReplacementGroup() == null || !tmuPlay.mu.getReplacementGroup().equals(tmu.mu.getReplacementGroup())) continue;
            boolean runTmuPlay = false;
            double tmuPlayEnd = tmuPlay.getEndTime();
            double tmuEnd = tmu.getEndTime();
            if (tmuPlay.getStartTime() > tmu.getStartTime()) {
                runTmuPlay = true;
            } else if (tmuPlay.getStartTime() < tmu.getStartTime()) {
                runTmuPlay = false;
            } else if (tmuEnd == -2.147483647E9 && tmuPlayEnd != -2.147483647E9) {
                runTmuPlay = true;
            } else if (tmuEnd != -2.147483647E9 && tmuPlayEnd == -2.147483647E9) {
                runTmuPlay = false;
            } else if (tmuEnd == -2.147483647E9 && tmuPlayEnd == -2.147483647E9) {
                replacementOverlap = tmuPlay;
                runTmuPlay = false;
            } else if (tmuPlayEnd < tmuEnd) {
                runTmuPlay = true;
            } else if (tmuPlayEnd == tmuEnd) {
                replacementOverlap = tmuPlay;
                runTmuPlay = false;
            }
            if (runTmuPlay) {
                play = false;
                break;
            }
            remove.add(tmuPlay);
            tmuPlay.stop(t);
            if (replacementOverlap == null) continue;
            break;
        }
        this.playingMotionUnits.removeAll(remove);
        if (replacementOverlap != null) {
            tmuWc.tmuWarning(tmu, "Replacement group overlap between " + tmu.getBMLId() + ":" + tmu.getId() + " and " + replacementOverlap.getBMLId() + ":" + replacementOverlap.getId());
        }
        return play;
    }

    public synchronized void play(double t) {
        this.play(t, null);
    }

    public synchronized void play(double t, TMUWarningCallback tmuWc) {
        this.playingMotionUnits.clear();
        for (TimedMotionUnit tmu : this.timedMotionUnits) {
            boolean resetPlaying = true;
            if (t >= tmu.getStartTime() && tmu.getStartTime() != -2.147483647E9) {
                if (tmu.getEndTime() == -2.147483647E9 && tmu.mu.getPreferedDuration() == 0.0) {
                    if (this.updatePlayingMU(tmu, tmuWc, t)) {
                        this.playingMotionUnits.add(tmu);
                        resetPlaying = false;
                    }
                } else if (t < tmu.getEndTime() && this.updatePlayingMU(tmu, tmuWc, t)) {
                    this.playingMotionUnits.add(tmu);
                    resetPlaying = false;
                }
            }
            if (!resetPlaying) continue;
            tmu.stop(t);
            this.playingMotionUnits.remove(tmu);
        }
        for (TimedMotionUnit tmu : this.playingMotionUnits) {
            try {
                tmu.play(t);
            }
            catch (TMUPlayException ex) {
                if (tmuWc == null) continue;
                tmuWc.tmuWarning(tmu, "Runtime exception for behavior " + tmu.getBMLId() + ":" + tmu.getId() + ".");
            }
        }
    }

    public synchronized ArrayList<TimedMotionUnit> getTimedMotionUnits() {
        return this.timedMotionUnits;
    }

    public synchronized void addTimedMotionUnit(TimedMotionUnit tmu) {
        this.timedMotionUnits.add(tmu);
    }

    public synchronized void removeTimedMotionUnits(Collection<TimedMotionUnit> tmus) {
        this.timedMotionUnits.removeAll(tmus);
    }

    public synchronized void removeTimedMotionUnit(String id, String bmlId) {
        TimedMotionUnit tmu = this.getTimedMotionUnit(id, bmlId);
        if (tmu != null) {
            this.timedMotionUnits.remove(tmu);
        }
    }

    public synchronized TimedMotionUnit getTimedMotionUnit(String id, String bmlId) {
        for (TimedMotionUnit tmu : this.timedMotionUnits) {
            if (!tmu.getId().equals(id) || !tmu.getBMLId().equals(bmlId)) continue;
            return tmu;
        }
        return null;
    }

    public synchronized void clearAll() {
        this.timedMotionUnits.clear();
    }
}

