/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc;

import hmi.bml.Behaviour;
import hmi.bml.BehaviourBlock;
import hmi.bml.SyncPoint;
import hmi.bml.parser.BMLParser;
import hmi.bml.parser.Constraint;
import hmi.elckerlyc.AbstractBMLScheduler;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.Planner;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimePegAndConstraint;
import hmi.elckerlyc.anticipator.Anticipator;
import hmi.elckerlyc.feedback.BMLWarningFeedback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SmartBodyScheduler
extends AbstractBMLScheduler {
    private BMLParser parser;

    public SmartBodyScheduler(BMLParser s) {
        this.parser = s;
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public void schedule() {
        ArrayList<Behaviour> scheduledBehaviors = new ArrayList<Behaviour>();
        HashMap<Behaviour, ArrayList<TimePegAndConstraint>> syncMap = new HashMap<Behaviour, ArrayList<TimePegAndConstraint>>();
        block2: for (BehaviourBlock bb : this.parser.getBehaviourBlocks()) {
            for (Behaviour b : bb.behaviours) {
                ArrayList<TimePegAndConstraint> syncList;
                block23: {
                    Planner p;
                    syncList = new ArrayList<TimePegAndConstraint>();
                    for (Constraint c : this.parser.getConstraints()) {
                        ArrayList<ConstrInfo> constraintInfo = new ArrayList<ConstrInfo>();
                        for (SyncPoint s : c.getTargets()) {
                            if (s.getBehavior() != b) continue;
                            double offset = s.getOffset();
                            String syncId = s.getName();
                            constraintInfo.add(new ConstrInfo(syncId, offset));
                            System.out.println("Constraint info: " + b + " sync:" + syncId + " offset:" + offset);
                        }
                        for (ConstrInfo ci : constraintInfo) {
                            boolean syncExists = false;
                            block7: for (Behaviour b2 : scheduledBehaviors) {
                                for (TimePegAndConstraint said : (ArrayList)syncMap.get(b2)) {
                                    if (said.constr != c) continue;
                                    syncList.add(new TimePegAndConstraint(ci.syncId, said.peg, c, ci.offset));
                                    syncExists = true;
                                    continue block7;
                                }
                            }
                            if (syncExists) continue;
                            boolean isStaticOrAnticipator = false;
                            for (SyncPoint s : c.getTargets()) {
                                if (s.getBehavior() != null) continue;
                                String[] str = s.getName().split(":");
                                if (str.length == 2 && !str[0].equals("bml")) {
                                    Anticipator ap = (Anticipator)this.anticipators.get(str[0]);
                                    isStaticOrAnticipator = true;
                                    if (ap != null) {
                                        TimePeg sp = ap.getSynchronisationPoint(str[1]);
                                        syncList.add(new TimePegAndConstraint(ci.syncId, sp, c, ci.offset - (double)s.offset));
                                        System.out.println("Link to anticipator: " + str[1] + " at time " + sp.getValue() + " with offset " + ci.offset);
                                        sp.setAbsoluteTime(true);
                                        break;
                                    }
                                    String bmlId = bb.id;
                                    String id = "w-" + b.id;
                                    ArrayList<String> modifiedBehaviours = new ArrayList<String>();
                                    ArrayList<String> modifiedConstraints = new ArrayList<String>();
                                    String warningText = "Unknown sync point " + s.getName() + " sync ignored.";
                                    this.warn(new BMLWarningFeedback(id, bmlId, modifiedBehaviours, modifiedConstraints, warningText));
                                    break;
                                }
                                isStaticOrAnticipator = true;
                                TimePeg sync = new TimePeg();
                                sync.setAbsoluteTime(true);
                                sync.setValue(s.getOffset());
                                syncList.add(new TimePegAndConstraint(ci.syncId, sync, c, ci.offset));
                                break;
                            }
                            if (isStaticOrAnticipator) continue;
                            TimePeg sync = new TimePeg();
                            sync.setValue(-2.147483647E9);
                            syncList.add(new TimePegAndConstraint(ci.syncId, sync, c, ci.offset));
                        }
                    }
                    boolean resolveStart = true;
                    for (TimePegAndConstraint sac : syncList) {
                        if (!sac.id.equals("start")) continue;
                        resolveStart = false;
                        break;
                    }
                    if (resolveStart) {
                        TimePeg temp = new TimePeg();
                        OffsetPeg sync = new OffsetPeg(temp, 0.0);
                        boolean offsetRes = false;
                        if (syncList.size() > 0) {
                            offsetRes = true;
                        }
                        syncList.add(new TimePegAndConstraint("start", sync, new Constraint(), 0.0, offsetRes));
                    }
                    if ((p = this.getPlanner(b.getClass())) != null) {
                        try {
                            Object planElement = p.resolveSynchs(b, syncList);
                            List<SyncAndTimePeg> satp = p.addBehaviour(b, syncList, planElement);
                            this.pegBoard.addTimePegs(satp);
                            break block23;
                        }
                        catch (BehaviourPlanningException ex) {
                            String bmlId = bb.id;
                            String id = "w-" + b.id;
                            ArrayList<String> modifiedBehaviours = new ArrayList<String>();
                            modifiedBehaviours.add(b.id);
                            ArrayList<String> modifiedConstraints = new ArrayList<String>();
                            String warningText = ex.message;
                            this.warn(new BMLWarningFeedback(id, bmlId, modifiedBehaviours, modifiedConstraints, warningText));
                            continue block2;
                        }
                    }
                    String bmlId = bb.id;
                    String id = "w-" + b.id;
                    ArrayList<String> modifiedBehaviours = new ArrayList<String>();
                    modifiedBehaviours.add(b.id);
                    ArrayList<String> modifiedConstraints = new ArrayList<String>();
                    String warningText = "No planner found to plan behavior of type <" + b.getXMLTag() + ">, behavior ommitted";
                    this.warn(new BMLWarningFeedback(id, bmlId, modifiedBehaviours, modifiedConstraints, warningText));
                    continue block2;
                }
                syncMap.put(b, syncList);
                scheduledBehaviors.add(b);
            }
        }
        boolean moving = true;
        ArrayList<Behaviour> behToRemove = new ArrayList<Behaviour>();
        block11: while (moving) {
            moving = false;
            for (Behaviour b : scheduledBehaviors) {
                for (TimePegAndConstraint tpac : (ArrayList)syncMap.get(b)) {
                    double t = tpac.peg.getValue() - tpac.offset;
                    if (!(t < 0.0) || t == -2.147483647E9) continue;
                    System.out.println("negative time: " + b.id + ":" + tpac.id);
                    System.out.println("Value: " + tpac.peg.getValue() + " Offset: " + tpac.offset);
                    double move = -t;
                    if (!tpac.peg.isAbsoluteTime()) {
                        this.movePeg(move, b, syncMap);
                        moving = true;
                        break;
                    }
                    String bmlId = b.fullId.split(":")[0];
                    String wid = "w-" + b.id;
                    ArrayList<String> modifiedBehaviours = new ArrayList<String>();
                    modifiedBehaviours.add(b.id);
                    ArrayList<String> modifiedConstraints = new ArrayList<String>();
                    String warningText = "Can't satisfy time constraints on <" + b.getXMLTag() + ">, behavior ommitted";
                    this.warn(new BMLWarningFeedback(wid, bmlId, modifiedBehaviours, modifiedConstraints, warningText));
                    behToRemove.add(b);
                    break;
                }
                if (!moving) continue;
                continue block11;
            }
        }
        for (Behaviour b : behToRemove) {
            Planner p = this.getPlanner(b.getClass());
            p.removeBehaviour(b.id, b.fullId.split(":")[0]);
        }
        System.out.println("Checking behavior validity");
        List<Planner> planners = this.getPlanners();
        for (Planner p : planners) {
            System.out.println("Checking behavior validity for planner " + p.getClass());
            List<String> invalidBehaviours = p.getInvalidBehaviours();
            for (String id : invalidBehaviours) {
                String bmlId = id.split(":")[0];
                String behId = id.substring(bmlId.length() + 1);
                String wid = "w-" + behId;
                ArrayList<String> modifiedBehaviours = new ArrayList<String>();
                modifiedBehaviours.add(behId);
                ArrayList<String> modifiedConstraints = new ArrayList<String>();
                String warningText = "Invalid timing for behavior " + id + ", behavior ommitted";
                this.warn(new BMLWarningFeedback(wid, bmlId, modifiedBehaviours, modifiedConstraints, warningText));
                p.removeBehaviour(behId, bmlId);
            }
        }
    }

    private boolean moveBehavior(double move, Behaviour b, ArrayList<TimePeg> movedPegs, HashMap<Behaviour, ArrayList<TimePegAndConstraint>> syncMap) {
        boolean pegAdded = false;
        TimePeg firstAbsolute = null;
        for (TimePegAndConstraint tpac : syncMap.get(b)) {
            if (!tpac.peg.isAbsoluteTime() || firstAbsolute != null && !(firstAbsolute.getValue() > tpac.peg.getValue())) continue;
            firstAbsolute = tpac.peg;
        }
        for (TimePegAndConstraint tpac : syncMap.get(b)) {
            if (movedPegs.contains(tpac.peg.getLink()) || firstAbsolute != null && !(firstAbsolute.getValue() < tpac.peg.getValue())) continue;
            System.out.println("Moving " + b.id + ":" + tpac.id + " to " + (tpac.peg.getValue() + move));
            tpac.peg.setValue(tpac.peg.getValue() + move);
            movedPegs.add(tpac.peg.getLink());
            pegAdded = true;
        }
        return pegAdded;
    }

    private void movePeg(double move, Behaviour b, HashMap<Behaviour, ArrayList<TimePegAndConstraint>> syncMap) {
        ArrayList<TimePeg> movedPegs = new ArrayList<TimePeg>();
        ArrayList<Behaviour> movedBehaviors = new ArrayList<Behaviour>();
        this.moveBehavior(move, b, movedPegs, syncMap);
        movedBehaviors.add(b);
        boolean pegAdded = true;
        block0: while (pegAdded) {
            pegAdded = false;
            for (Behaviour beh : syncMap.keySet()) {
                if (!movedBehaviors.contains(beh)) {
                    for (TimePegAndConstraint tpac : syncMap.get(beh)) {
                        if (!movedPegs.contains(tpac.peg.getLink())) continue;
                        pegAdded = this.moveBehavior(move, beh, movedPegs, syncMap);
                        movedBehaviors.add(beh);
                        if (!pegAdded) continue;
                        break;
                    }
                }
                if (!pegAdded) continue;
                continue block0;
            }
        }
    }

    static class ConstrInfo {
        String syncId;
        double offset;

        public ConstrInfo(String s, double o) {
            this.syncId = s;
            this.offset = o;
        }
    }
}

