/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc;

import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.TimePeg;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class PegBoard {
    private final ConcurrentHashMap<String, TimePeg> pegs = new ConcurrentHashMap();

    public double getPegTime(String syncId, String id, String bmlId) {
        TimePeg p = this.pegs.get(syncId + id + bmlId);
        if (p == null) {
            return -2.147483647E9;
        }
        return p.getValue();
    }

    public void setPegTime(String syncId, String id, String bmlId, double time) {
        TimePeg p = this.pegs.get(syncId + id + bmlId);
        if (p != null) {
            p.setValue(time);
        }
    }

    public void addTimePegs(List<SyncAndTimePeg> satps) {
        for (SyncAndTimePeg satp : satps) {
            this.pegs.put(satp.sync + satp.id + satp.bmlId, satp.peg);
        }
    }

    public void addTimePeg(String syncId, String id, String bmlId, TimePeg p) {
        this.pegs.put(syncId + id + bmlId, p);
    }

    public TimePeg getTimePeg(String syncId, String id, String bmlId) {
        return this.pegs.get(syncId + id + bmlId);
    }
}

