/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc;

import hmi.bml.BMLInfo;
import hmi.bml.Behaviour;
import hmi.bml.BehaviourBlock;
import hmi.bml.GazeBehaviour;
import hmi.bml.GestureBehaviour;
import hmi.bml.HeadBehaviour;
import hmi.bml.PostureBehaviour;
import hmi.bml.SpeechBehaviour;
import hmi.bml.parser.BMLParser;
import hmi.bmlt.BMLTAudioFileBehaviour;
import hmi.bmlt.BMLTControllerBehaviour;
import hmi.bmlt.BMLTKeyframeBehaviour;
import hmi.bmlt.BMLTProcAnimationBehaviour;
import hmi.bmlt.BMLTTransitionBehaviour;
import hmi.elckerlyc.BMLScheduler;
import hmi.elckerlyc.Planner;
import hmi.elckerlyc.SmartBodyScheduler;
import hmi.elckerlyc.animationengine.AnimationPlanner;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.gesturebinding.GestureBinding;
import hmi.elckerlyc.anticipator.Anticipator;
import hmi.elckerlyc.audioengine.AudioPlanner;
import hmi.elckerlyc.audioengine.AudioPlayer;
import hmi.elckerlyc.faceengine.FacePlanner;
import hmi.elckerlyc.feedback.BMLExceptionFeedback;
import hmi.elckerlyc.feedback.BMLExceptionListener;
import hmi.elckerlyc.feedback.BMLFeedbackListener;
import hmi.elckerlyc.feedback.BMLWarningListener;
import hmi.elckerlyc.feedback.StdoutWarningListener;
import hmi.elckerlyc.speechengine.VerbalPlanner;
import hmi.elckerlyc.speechengine.VerbalPlayer;
import hmi.msapi.MSApiBehaviour;
import hmi.util.Resources;
import hmi.xml.XMLScanException;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;

public class BMLRealizer {
    private Resources gestureBindingResources = null;
    private String gestureBindingFileName = null;
    private BMLParser parser = null;
    private GestureBinding gestureBinding = null;
    private AudioPlanner audioPlanner = null;
    private VerbalPlanner verbalPlanner = null;
    private FacePlanner facePlanner = null;
    private AnimationPlayer animationPlayer = null;
    private AnimationPlanner animationPlanner = null;
    private BMLScheduler scheduler = null;

    public BMLRealizer(Resources gestRes, String gestFileName, AudioPlanner newAudioPlanner, VerbalPlanner newVerbalPlanner, FacePlanner newFacePlanner, AnimationPlayer newAnimationPlayer) {
        this.gestureBindingResources = gestRes;
        this.gestureBindingFileName = gestFileName;
        this.audioPlanner = newAudioPlanner;
        this.verbalPlanner = newVerbalPlanner;
        this.facePlanner = newFacePlanner;
        this.animationPlayer = newAnimationPlayer;
        this.init();
    }

    public AudioPlayer getAudioPlayer() {
        return this.audioPlanner.getAudioPlayer();
    }

    public VerbalPlayer getVerbalPlayer() {
        return this.verbalPlanner.getVerbalPlayer();
    }

    public BMLRealizer(AnimationPlayer ap, VerbalPlanner vp) {
        this(new Resources(""), "gesturebinding/gesturebinding.xml", null, vp, null, ap);
    }

    public void setFeedbackListener(BMLFeedbackListener f) {
        if (this.animationPlanner != null) {
            this.animationPlanner.removeAllFeedbackListeners();
            this.animationPlanner.addFeedbackListener(f);
        }
        if (this.audioPlanner != null) {
            this.audioPlanner.removeAllFeedbackListeners();
            this.audioPlanner.addFeedbackListener(f);
        }
        if (this.verbalPlanner != null) {
            this.verbalPlanner.removeAllFeedbackListeners();
            this.verbalPlanner.addFeedbackListener(f);
        }
    }

    public void setWarningListener(BMLWarningListener w) {
        this.scheduler.removeAllWarningListeners();
        this.scheduler.addWarningListener(w);
        if (this.animationPlayer != null) {
            this.animationPlayer.removeAllWarningListeners();
            this.animationPlayer.addWarningListener(w);
        }
    }

    public void setExceptionListener(BMLExceptionListener e) {
        this.scheduler.removeAllExceptionListeners();
        this.scheduler.addExceptionListener(e);
    }

    public void addExceptionListener(BMLExceptionListener newListener) {
        this.scheduler.addExceptionListener(newListener);
    }

    public void addWarningListener(BMLWarningListener newListener) {
        this.scheduler.addWarningListener(newListener);
        if (this.animationPlayer != null) {
            this.animationPlayer.addWarningListener(newListener);
        }
    }

    public void addFeedbackListener(BMLFeedbackListener newListener) {
        if (this.animationPlanner != null) {
            this.animationPlanner.addFeedbackListener(newListener);
        }
        if (this.audioPlanner != null) {
            this.audioPlanner.addFeedbackListener(newListener);
        }
        if (this.verbalPlanner != null) {
            this.verbalPlanner.addFeedbackListener(newListener);
        }
    }

    protected void init() {
        this.initBMLInfo();
        this.initGestureBinding();
        this.initParser();
        this.initScheduler();
    }

    protected void initBMLInfo() {
        new BMLInfo();
        BMLInfo.behaviourTypes.put("bmlt:procanimation", BMLTProcAnimationBehaviour.class);
        BMLInfo.behaviourTypes.put("bmlt:controller", BMLTControllerBehaviour.class);
        BMLInfo.behaviourTypes.put("bmlt:transition", BMLTTransitionBehaviour.class);
        BMLInfo.behaviourTypes.put("bmlt:keyframe", BMLTKeyframeBehaviour.class);
        BMLInfo.behaviourTypes.put("bmlt:audiofile", BMLTAudioFileBehaviour.class);
        BMLInfo.descriptionLevelTypes.put("bmlt:procanimation", BMLTProcAnimationBehaviour.class);
        BMLInfo.descriptionLevelTypes.put("bmlt:controller", BMLTControllerBehaviour.class);
        BMLInfo.descriptionLevelTypes.put("bmlt:transition", BMLTTransitionBehaviour.class);
        BMLInfo.descriptionLevelTypes.put("bmlt:keyframe", BMLTKeyframeBehaviour.class);
        BMLInfo.descriptionLevelTypes.put("application/msapi+xml", MSApiBehaviour.class);
        BMLInfo.descriptionLevelTypes.put("bmlt:audiofile", BMLTAudioFileBehaviour.class);
    }

    protected void initGestureBinding() {
        this.gestureBinding = new GestureBinding(this.gestureBindingResources);
        try {
            this.gestureBinding.readXML(this.gestureBindingResources.getReader(this.gestureBindingFileName));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    protected void initParser() {
        this.parser = new BMLParser();
    }

    protected void initScheduler() {
        this.scheduler = new SmartBodyScheduler(this.parser);
        StdoutWarningListener listener = new StdoutWarningListener();
        this.scheduler.addWarningListener(listener);
        if (this.animationPlayer != null) {
            this.animationPlayer.addWarningListener(listener);
            this.animationPlanner = new AnimationPlanner(this.animationPlayer, this.gestureBinding);
            this.scheduler.addPlanner(HeadBehaviour.class, this.animationPlanner);
            this.scheduler.addPlanner(GazeBehaviour.class, this.animationPlanner);
            this.scheduler.addPlanner(GestureBehaviour.class, this.animationPlanner);
            this.scheduler.addPlanner(PostureBehaviour.class, this.animationPlanner);
            this.scheduler.addPlanner(BMLTProcAnimationBehaviour.class, this.animationPlanner);
            this.scheduler.addPlanner(BMLTControllerBehaviour.class, this.animationPlanner);
            this.scheduler.addPlanner(BMLTTransitionBehaviour.class, this.animationPlanner);
            this.scheduler.addPlanner(BMLTKeyframeBehaviour.class, this.animationPlanner);
            System.out.println("Adding animation planner");
        } else {
            System.out.println("NO ANIMATION PLANNER");
        }
        if (this.verbalPlanner != null) {
            this.scheduler.addPlanner(SpeechBehaviour.class, this.verbalPlanner);
            this.scheduler.addPlanner(MSApiBehaviour.class, this.verbalPlanner);
            System.out.println("Adding speech planner");
        } else {
            System.out.println("NO SPEECH PLANNER");
        }
        if (this.audioPlanner != null) {
            this.scheduler.addPlanner(BMLTAudioFileBehaviour.class, this.audioPlanner);
            System.out.println("Adding audio planner");
        } else {
            System.out.println("NO AUDIO PLANNER");
        }
    }

    public void test() {
        Resources r = new Resources("bml");
        System.out.println(this.parseXML(r.getReader("testspeechandnod.xml")));
    }

    public void addAnticipator(String id, Anticipator ap) {
        this.scheduler.addAnticipator(id, ap);
    }

    public void removeAnticipator(String aid) {
        this.scheduler.removeAnticipator(aid);
    }

    public String parseXML(String in) {
        return this.parseXML(new StringReader(in));
    }

    public String parseXML(Reader in) {
        return this.parseXML(new XMLTokenizer(in));
    }

    public String parseXML(XMLTokenizer in) {
        String result = "";
        BehaviourBlock block = new BehaviourBlock();
        try {
            block.readXML(in);
        }
        catch (XMLScanException e) {
            String id = "<no id>";
            String bmlId = "<no id>";
            ArrayList<String> failedBehaviours = new ArrayList<String>();
            ArrayList<String> failedConstraints = new ArrayList<String>();
            String exceptionText = "Parsing XML failed: see stack trace for more info. " + e.getLocalizedMessage() + "\n" + Arrays.toString(e.getStackTrace()) + "\n";
            result = "BML Not scheduled.\n";
            this.scheduler.exception(new BMLExceptionFeedback(id, bmlId, failedBehaviours, failedConstraints, exceptionText, true));
            return result;
        }
        catch (IOException e) {
            String id = "<no id>";
            String bmlId = "<no id>";
            ArrayList<String> failedBehaviours = new ArrayList<String>();
            ArrayList<String> failedConstraints = new ArrayList<String>();
            String exceptionText = "IO Exception. " + e.getLocalizedMessage() + "\n" + Arrays.toString(e.getStackTrace()) + "\n";
            result = "BML Not scheduled.\n";
            this.scheduler.exception(new BMLExceptionFeedback(id, bmlId, failedBehaviours, failedConstraints, exceptionText, true));
            return result;
        }
        this.parser.addBehaviourBlock(block);
        this.scheduler.schedule();
        result = result + "BML scheduled.\n";
        return result;
    }

    public void clear() {
        this.parser.clear();
        this.scheduler.clear();
        if (this.facePlanner != null) {
            this.facePlanner.clearAll();
        }
    }

    public void reset() {
        this.clear();
        this.animationPlayer.reset();
    }

    public AnimationPlayer getAnimationPlayer() {
        return this.animationPlayer;
    }

    public Planner getPlanner(Class<? extends Behaviour> c) {
        return this.scheduler.getPlanner(c);
    }

    public BMLScheduler getScheduler() {
        return this.scheduler;
    }
}

