/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc;

import hmi.bml.Behaviour;
import hmi.elckerlyc.BMLScheduler;
import hmi.elckerlyc.PegBoard;
import hmi.elckerlyc.Planner;
import hmi.elckerlyc.anticipator.Anticipator;
import hmi.elckerlyc.feedback.BMLExceptionFeedback;
import hmi.elckerlyc.feedback.BMLExceptionListener;
import hmi.elckerlyc.feedback.BMLWarningFeedback;
import hmi.elckerlyc.feedback.BMLWarningListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractBMLScheduler
implements BMLScheduler {
    protected Map<Class<? extends Behaviour>, Planner> planSelector;
    protected List<BMLWarningListener> warningListeners;
    protected List<BMLExceptionListener> exceptionListeners;
    protected Map<String, Anticipator> anticipators;
    protected final PegBoard pegBoard = new PegBoard();

    public AbstractBMLScheduler() {
        this.planSelector = new HashMap<Class<? extends Behaviour>, Planner>();
        this.anticipators = new HashMap<String, Anticipator>();
        this.warningListeners = new ArrayList<BMLWarningListener>();
        this.exceptionListeners = new ArrayList<BMLExceptionListener>();
    }

    @Override
    public PegBoard getPegBoard() {
        return this.pegBoard;
    }

    @Override
    public List<Planner> getPlanners() {
        ArrayList<Planner> planners = new ArrayList<Planner>();
        for (Planner p : this.planSelector.values()) {
            if (planners.contains(p)) continue;
            planners.add(p);
        }
        return planners;
    }

    @Override
    public void clear() {
        List<Planner> planners = this.getPlanners();
        for (Planner p : planners) {
            System.out.println("clearing " + p.getClass());
            p.clearAll();
        }
    }

    @Override
    public void addPlanner(Class<? extends Behaviour> c, Planner p) {
        this.planSelector.put(c, p);
    }

    @Override
    public void addAnticipator(String id, Anticipator ap) {
        this.anticipators.put(id, ap);
    }

    @Override
    public void removeAnticipator(String aid) {
        this.anticipators.remove(aid);
    }

    @Override
    public int getNumberOfAnticipators() {
        return this.anticipators.values().size();
    }

    @Override
    public void addWarningListener(BMLWarningListener ws) {
        this.warningListeners.add(ws);
    }

    @Override
    public void removeAllWarningListeners() {
        this.warningListeners.clear();
    }

    @Override
    public void removeAllExceptionListeners() {
        this.exceptionListeners.clear();
    }

    @Override
    public void addExceptionListener(BMLExceptionListener e) {
        this.exceptionListeners.add(e);
    }

    @Override
    public void warn(BMLWarningFeedback w) {
        for (BMLWarningListener wl : this.warningListeners) {
            wl.warn(w);
        }
    }

    @Override
    public void exception(BMLExceptionFeedback e) {
        for (BMLExceptionListener e1 : this.exceptionListeners) {
            e1.exception(e);
        }
    }

    @Override
    public Planner getPlanner(Class<? extends Behaviour> c) {
        return this.planSelector.get(c);
    }
}

