/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.wait;

import hmi.bml.core.Behaviour;
import hmi.bml.core.WaitBehaviour;
import hmi.bml.parser.Constraint;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import hmi.elckerlyc.wait.WaitPlanner;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WaitPlannerTest {
    private WaitPlanner waitPlanner;

    @Before
    public void setup() {
        this.waitPlanner = new WaitPlanner();
    }

    @Test
    public void testResolve1() throws BehaviourPlanningException {
        String waitBehStr = "<wait id=\"w1\" max-wait=\"10\"/>";
        WaitBehaviour wb = new WaitBehaviour();
        wb.bmlId = "bml1";
        wb.readXML(waitBehStr);
        ArrayList<TimePegAndConstraint> sacs = new ArrayList<TimePegAndConstraint>();
        TimePeg startPeg = new TimePeg(BMLBlockPeg.GLOBALPEG);
        sacs.add(new TimePegAndConstraint("start", startPeg, new Constraint(), 0.0));
        TimedPlanUnit pu = this.waitPlanner.resolveSynchs(BMLBlockPeg.GLOBALPEG, (Behaviour)wb, sacs);
        Assert.assertEquals((Object)"bml1", (Object)pu.getBMLId());
        Assert.assertEquals((Object)"w1", (Object)pu.getId());
        Assert.assertEquals((double)0.0, (double)pu.getStartTime(), (double)1.0E-4);
        Assert.assertEquals((double)10.0, (double)pu.getEndTime(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)startPeg.getGlobalValue(), (double)1.0E-4);
    }

    @Test
    public void testResolve2() throws BehaviourPlanningException {
        String waitBehStr = "<wait id=\"w1\"/>";
        WaitBehaviour wb = new WaitBehaviour();
        wb.bmlId = "bml1";
        wb.readXML(waitBehStr);
        ArrayList<TimePegAndConstraint> sacs = new ArrayList<TimePegAndConstraint>();
        TimePeg startPeg = new TimePeg(BMLBlockPeg.GLOBALPEG);
        sacs.add(new TimePegAndConstraint("start", startPeg, new Constraint(), 0.0));
        TimedPlanUnit pu = this.waitPlanner.resolveSynchs(BMLBlockPeg.GLOBALPEG, (Behaviour)wb, sacs);
        Assert.assertEquals((Object)"bml1", (Object)pu.getBMLId());
        Assert.assertEquals((Object)"w1", (Object)pu.getId());
        Assert.assertEquals((double)0.0, (double)pu.getStartTime(), (double)1.0E-4);
        Assert.assertEquals((double)-1.7976931348623157E308, (double)pu.getEndTime(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)startPeg.getGlobalValue(), (double)1.0E-4);
    }

    @Test
    public void testResolve3() throws BehaviourPlanningException {
        String waitBehStr = "<wait id=\"w1\"/>";
        WaitBehaviour wb = new WaitBehaviour();
        wb.bmlId = "bml1";
        wb.readXML(waitBehStr);
        ArrayList<TimePegAndConstraint> sacs = new ArrayList<TimePegAndConstraint>();
        TimePeg startPeg = new TimePeg(BMLBlockPeg.GLOBALPEG);
        startPeg.setGlobalValue(3.0);
        sacs.add(new TimePegAndConstraint("start", startPeg, new Constraint(), 0.0));
        TimePeg endPeg = new TimePeg(BMLBlockPeg.GLOBALPEG);
        endPeg.setGlobalValue(5.0);
        sacs.add(new TimePegAndConstraint("end", endPeg, new Constraint(), 0.0));
        TimedPlanUnit pu = this.waitPlanner.resolveSynchs(BMLBlockPeg.GLOBALPEG, (Behaviour)wb, sacs);
        Assert.assertEquals((Object)"bml1", (Object)pu.getBMLId());
        Assert.assertEquals((Object)"w1", (Object)pu.getId());
        Assert.assertEquals((double)3.0, (double)pu.getStartTime(), (double)1.0E-4);
        Assert.assertEquals((double)5.0, (double)pu.getEndTime(), (double)1.0E-4);
        Assert.assertEquals((double)3.0, (double)startPeg.getGlobalValue(), (double)1.0E-4);
        Assert.assertEquals((double)5.0, (double)endPeg.getGlobalValue(), (double)1.0E-4);
    }
}

