/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.wait;

import hmi.bml.BMLSync;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.planunit.TimedAbstractPlanUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedWaitUnit
extends TimedAbstractPlanUnit {
    private TimePeg startPeg;
    private TimePeg endPeg;
    private static final Logger logger = LoggerFactory.getLogger((String)TimedWaitUnit.class.getName());

    public TimedWaitUnit(BMLBlockPeg bmlPeg, String i, String bmlId) {
        super(bmlPeg, i, bmlId);
    }

    public void setStartPeg(TimePeg startPeg) {
        this.startPeg = startPeg;
    }

    public void setEndPeg(TimePeg endPeg) {
        this.endPeg = endPeg;
    }

    @Override
    public double getStartTime() {
        return this.startPeg.getGlobalValue();
    }

    @Override
    public double getEndTime() {
        if (this.endPeg == null) {
            return -1.7976931348623157E308;
        }
        return this.endPeg.getGlobalValue();
    }

    @Override
    public boolean hasValidTiming() {
        if (this.startPeg == null) {
            return false;
        }
        if (this.startPeg.getGlobalValue() == -1.7976931348623157E308) {
            return false;
        }
        if (this.endPeg == null) {
            return true;
        }
        if (this.endPeg.getGlobalValue() == -1.7976931348623157E308) {
            return true;
        }
        return this.startPeg.getGlobalValue() < this.endPeg.getGlobalValue();
    }

    private void sendFeedback(String syncId, double time) {
        String bmlId = this.getBMLId();
        String behaviorId = this.getId();
        String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        double bmlBlockTime = time - this.bmlBlockPeg.getValue();
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, bmlBlockTime, time));
    }

    @Override
    public void startUnit(double time) {
        this.sendFeedback("start", time);
        this.sendFeedback("ready", time);
        this.sendFeedback("stroke-start", time);
        this.sendFeedback("stroke", time);
    }

    @Override
    protected void playUnit(double time) throws TimedPlanUnitPlayException {
    }

    @Override
    protected void stopUnit(double time) throws TimedPlanUnitPlayException {
        this.sendFeedback("stroke-end", time);
        this.sendFeedback("relax", time);
        this.sendFeedback("end", time);
    }

    @Override
    public double getPreferedDuration() {
        if (this.getEndTime() != -1.7976931348623157E308 && this.getStartTime() != -1.7976931348623157E308) {
            return this.getEndTime() - this.getStartTime();
        }
        return 0.0;
    }

    @Override
    public TimePeg getTimePeg(String syncId) {
        if (syncId.equals("start")) {
            return this.startPeg;
        }
        if (syncId.equals("end")) {
            return this.endPeg;
        }
        return null;
    }

    @Override
    public void setTimePeg(String syncId, TimePeg peg) {
        if (BMLSync.isBMLSync((String)syncId)) {
            if (BMLSync.get((String)syncId).isAfter(BMLSync.STROKE)) {
                this.setEndPeg(peg);
            } else {
                this.setStartPeg(peg);
            }
        } else {
            logger.warn("Can't set TimePeg on non-BML sync {}", (Object)syncId);
        }
    }

    @Override
    public void setParameterValue(String paramId, String value) {
        logger.warn("Attempting to set value {} to parameter in a WaitUnit{}:{}", new Object[]{value, paramId, this.getBMLId(), this.getId()});
    }

    @Override
    public void setParameterValue(String paramId, float value) {
        logger.warn("Attempting to set value {} to parameter in a WaitUnit{}:{}", new Object[]{Float.valueOf(value), paramId, this.getBMLId(), this.getId()});
    }
}

