/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.bml.feedback.BMLExceptionListener;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.speechengine.VerbalPlanPlayer;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerbalPlayer
implements Player {
    private VerbalPlanPlayer vpp = new VerbalPlanPlayer();
    private static Logger logger = LoggerFactory.getLogger((String)VerbalPlayer.class.getName());

    public void play(double time) {
        this.vpp.play(time);
    }

    public void addSpeechUnit(TimedPlanUnit su) {
        this.vpp.addSpeechUnit(su);
    }

    public int getNumberOfSpeechUnits() {
        return this.vpp.getNumberOfSpeechUnits();
    }

    public void setSpeechParameter(String id, String bmlId, String parameter, float value) {
        this.vpp.setSpeechParameter(id, bmlId, parameter, value);
    }

    public void interruptSpeechUnit(String id, String bmlId, double globalTime) {
        this.vpp.interruptSpeechUnit(id, bmlId, globalTime);
    }

    @Override
    public void reset() {
        this.vpp.stop();
        logger.debug("VerbalPlayer reset");
        this.vpp.reset();
    }

    public void clearAll(double absoluteTime) {
        this.vpp.clearAll(absoluteTime);
        logger.debug("VerbalPlayer cleared");
    }

    public void cleanup() {
        logger.debug("VerbalPlayer cleanup");
        this.vpp.scheduleStop();
    }

    @Override
    public void shutdown() {
        try {
            this.vpp.shutdown();
        }
        catch (InterruptedException e) {
            logger.warn("InterruptedException in shutdown of VerbalPlayer ", (Throwable)e);
        }
    }

    public Set<String> getInvalidBehaviours() {
        return this.vpp.getInvalidBehaviors();
    }

    @Override
    public void addExceptionListener(BMLExceptionListener ws) {
        this.vpp.addExceptionListener(ws);
    }

    @Override
    public void removeAllExceptionListeners() {
        this.vpp.removeAllWarningListeners();
    }

    @Override
    public void setBMLBlockState(String bmlId, TimedPlanUnitState state) {
        this.vpp.setBMLBlockState(bmlId, state);
    }

    @Override
    public double getEndTime(String behId, String bmlId) {
        return this.vpp.getEndTime(behId, bmlId);
    }

    @Override
    public Set<String> getBehaviours(String bmlId) {
        return this.vpp.getBehaviours(bmlId);
    }

    @Override
    public void interruptBehaviourBlock(String bmlId, double time) {
        this.vpp.interruptBehaviourBlock(bmlId, time);
    }

    @Override
    public void setParameterValue(String behId, String bmlId, String paramId, float value) {
        this.vpp.setParameterValue(behId, bmlId, paramId, value);
    }

    @Override
    public void setParameterValue(String behId, String bmlId, String paramId, String value) {
        this.vpp.setParameterValue(behId, bmlId, paramId, value);
    }
}

