/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.bml.core.Behaviour;
import hmi.bml.core.SpeechBehaviour;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.speechengine.SpeechUnitPlanningException;
import hmi.elckerlyc.speechengine.TimedSpeechUnit;
import hmi.elckerlyc.speechengine.TimedTTSUnit;
import hmi.elckerlyc.speechengine.VerbalPlanPlayer;
import hmi.elckerlyc.speechengine.ttsbinding.TTSBinding;
import hmi.testutil.bml.feedback.ListBMLExceptionListener;
import hmi.tts.TimingInfo;
import java.util.ArrayList;
import mockit.Mock;
import mockit.MockUp;
import mockit.Mocked;
import mockit.NonStrictExpectations;
import org.junit.Assert;
import org.junit.Test;

public class VerbalPlanPlayerTest {
    @Mocked
    TTSBinding mockTTSBind;
    @Mocked
    TimedSpeechUnit mockPlanUnit1;
    @Mocked
    TimedSpeechUnit mockPlanUnit2;
    @Mocked
    TimedSpeechUnit mockPlanUnit3;

    @Test
    public void testPlayTTSUnit() throws InterruptedException {
        new MockUp<StubTTSUnit>(){

            @Mock(invocations=1)
            protected void playUnit(double time) {
            }

            @Mock(invocations=1)
            protected void startUnit(double time) {
            }

            @Mock
            public double getPreferedDuration() {
                return 5.0;
            }
        };
        ArrayList bwList = new ArrayList();
        StubTTSUnit ttsUnitStub = new StubTTSUnit(BMLBlockPeg.GLOBALPEG, "Hello world", "id1", "bml1", this.mockTTSBind, SpeechBehaviour.class);
        ttsUnitStub.setState(TimedPlanUnitState.LURKING);
        TimePeg tpStart = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpStart.setGlobalValue(0.0);
        ttsUnitStub.setStart(tpStart);
        VerbalPlanPlayer vpp = new VerbalPlanPlayer();
        vpp.addExceptionListener((BMLExceptionListener)new ListBMLExceptionListener(bwList));
        vpp.addSpeechUnit(ttsUnitStub);
        vpp.play(0.0);
        Thread.sleep(100L);
        Assert.assertTrue((bwList.size() == 0 ? 1 : 0) != 0);
        vpp.shutdown();
    }

    @Test
    public void testInterruptUnit() throws InterruptedException {
        VerbalPlanPlayer vpp = new VerbalPlanPlayer();
        new NonStrictExpectations(){
            {
                VerbalPlanPlayerTest.this.mockPlanUnit1.getEndTime();
                this.returns(3.0);
                VerbalPlanPlayerTest.this.mockPlanUnit1.getBMLId();
                this.returns("bml1");
                VerbalPlanPlayerTest.this.mockPlanUnit1.getId();
                this.returns("beh1");
                VerbalPlanPlayerTest.this.mockPlanUnit2.getStartTime();
                this.returns(1.0);
                VerbalPlanPlayerTest.this.mockPlanUnit2.getEndTime();
                this.returns(4.0);
                VerbalPlanPlayerTest.this.mockPlanUnit2.getBMLId();
                this.returns("bml1");
                VerbalPlanPlayerTest.this.mockPlanUnit2.getId();
                this.returns("beh2");
                VerbalPlanPlayerTest.this.mockPlanUnit3.getStartTime();
                this.returns(0.0);
                VerbalPlanPlayerTest.this.mockPlanUnit3.getEndTime();
                this.returns(5.0);
                VerbalPlanPlayerTest.this.mockPlanUnit3.getBMLId();
                this.returns("bml2");
                VerbalPlanPlayerTest.this.mockPlanUnit3.getId();
                this.returns("beh3");
            }
        };
        vpp.addSpeechUnit(this.mockPlanUnit1);
        vpp.addSpeechUnit(this.mockPlanUnit2);
        vpp.addSpeechUnit(this.mockPlanUnit3);
        Assert.assertEquals((long)3L, (long)vpp.getNumberOfSpeechUnits());
        vpp.interruptBehaviourBlock("bml1", 1.0);
        Assert.assertEquals((long)1L, (long)vpp.getNumberOfSpeechUnits());
    }

    private static class StubTTSUnit
    extends TimedTTSUnit {
        public StubTTSUnit(BMLBlockPeg bbPeg, String text, String id, String bmlId, TTSBinding ttsBin, Class<? extends Behaviour> behClass) {
            super(bbPeg, text, id, bmlId, ttsBin, behClass);
        }

        @Override
        protected TimingInfo getTiming() throws SpeechUnitPlanningException {
            return null;
        }

        @Override
        public void sendProgress(double playTime, double time) {
        }

        @Override
        public void setParameterValue(String paramater, float value) {
        }

        @Override
        protected void startUnit(double time) throws TimedPlanUnitPlayException {
        }

        @Override
        protected void playUnit(double time) throws TimedPlanUnitPlayException {
        }

        @Override
        protected void stopUnit(double time) throws TimedPlanUnitPlayException {
        }

        @Override
        public double getPreferedDuration() {
            return 0.0;
        }

        @Override
        public void setParameterValue(String paramId, String value) {
        }
    }
}

