/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.util.RuntimeExceptionLoggingRunnable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerbalPlanPlayer {
    @GuardedBy(value="speechUnits")
    private double time;
    @GuardedBy(value="speechUnits")
    private ArrayList<TimedPlanUnit> speechUnits;
    @GuardedBy(value="speechUnits")
    private boolean doStop = false;
    private Future<?> speechRunner = null;
    private final ExecutorService exec = Executors.newSingleThreadExecutor();
    private static Logger logger = LoggerFactory.getLogger((String)VerbalPlanPlayer.class.getName());
    @GuardedBy(value="this")
    private List<BMLExceptionListener> exceptionListeners = new ArrayList<BMLExceptionListener>();

    public void setSpeechParameter(String id, String bmlId, String parameter, float value) {
        logger.debug("Setting speech param");
        TimedPlanUnit su = this.getSpeechUnit(id, bmlId);
        if (su != null) {
            su.setParameterValue(parameter, value);
        }
    }

    public VerbalPlanPlayer() {
        this.speechUnits = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimedPlanUnit getSpeechUnit(String id, String bmlId) {
        ArrayList<TimedPlanUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            for (TimedPlanUnit sp : this.speechUnits) {
                if (!sp.getId().equals(id) || !sp.getBMLId().equals(bmlId)) continue;
                return sp;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSpeechUnit(TimedPlanUnit su) {
        ArrayList<TimedPlanUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            this.speechUnits.add(su);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBMLBlockState(String bmlId, TimedPlanUnitState state) {
        ArrayList<TimedPlanUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            for (TimedPlanUnit su : this.speechUnits) {
                if (!su.getBMLId().equals(bmlId)) continue;
                su.setState(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptBehaviourBlock(String bmlId, double time) {
        ArrayList<TimedPlanUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            ArrayList<TimedPlanUnit> removeUnits = new ArrayList<TimedPlanUnit>();
            for (TimedPlanUnit su : this.speechUnits) {
                if (!su.getBMLId().equals(bmlId)) continue;
                try {
                    su.stop(time);
                }
                catch (TimedPlanUnitPlayException e) {
                    logger.warn("Exception when interrupting behavior " + su, (Throwable)e);
                }
                removeUnits.add(su);
            }
            this.removeSpeechUnits(removeUnits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfSpeechUnits() {
        ArrayList<TimedPlanUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            return this.speechUnits.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptSpeechUnit(TimedPlanUnit su, double globalTime) {
        ArrayList<TimedPlanUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            try {
                su.stop(globalTime);
            }
            catch (TimedPlanUnitPlayException e) {
                logger.warn("SpeechUnit won't stop: {}", (Throwable)e);
            }
            this.speechUnits.remove(su);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSpeechUnits(List<TimedPlanUnit> suList) {
        ArrayList<TimedPlanUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            for (TimedPlanUnit su : suList) {
                logger.debug("Removing planunit {}:{}", (Object)su.getBMLId(), (Object)su.getId());
                if (!su.isPlaying()) continue;
                try {
                    su.stop(0.0);
                }
                catch (TimedPlanUnitPlayException e) {
                    logger.warn("SpeechUnit won't stop: {}", (Throwable)e);
                }
            }
            this.speechUnits.removeAll(suList);
        }
    }

    public void interruptSpeechUnit(String id, String bmlId, double globalTime) {
        TimedPlanUnit su = this.getSpeechUnit(id, bmlId);
        if (su != null) {
            this.interruptSpeechUnit(su, globalTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(double t) {
        ArrayList<TimedPlanUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            this.time = t;
        }
        if (this.speechRunner == null || this.speechRunner.isDone()) {
            logger.debug("Creating new SpeechRunner");
            if (this.speechRunner != null) {
                logger.debug("speechRunner.iDone(): {}", (Object)this.speechRunner.isDone());
            }
            this.speechRunner = this.exec.submit((Runnable)new RuntimeExceptionLoggingRunnable((Runnable)new SpeechRunner()));
        }
    }

    public void shutdown() throws InterruptedException {
        this.exec.shutdown();
        this.exec.awaitTermination(1L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleStop() {
        ArrayList<TimedPlanUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            this.doStop = true;
        }
        if (this.speechRunner != null) {
            try {
                this.speechRunner.get();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            catch (ExecutionException e) {
                logger.warn("Execution Exception when trying to stop VerbalPlanPlayer thread: {}", (Throwable)e);
            }
        }
        arrayList = this.speechUnits;
        synchronized (arrayList) {
            this.doStop = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        logger.debug("VPP stop()");
        ArrayList<TimedPlanUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            logger.debug("Stopping speechunits");
            for (TimedPlanUnit su : this.speechUnits) {
                try {
                    su.stop(0.0);
                }
                catch (TimedPlanUnitPlayException e) {
                    logger.warn("SpeechUnit won't stop: {}", (Throwable)e);
                }
            }
        }
        this.scheduleStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ArrayList<TimedPlanUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            for (TimedPlanUnit su : this.speechUnits) {
                su.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getInvalidBehaviors() {
        ArrayList<TimedPlanUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            HashSet<String> invalidBehaviors = new HashSet<String>();
            for (TimedPlanUnit su : this.speechUnits) {
                if (su.hasValidTiming()) continue;
                invalidBehaviors.add(String.valueOf(su.getBMLId()) + ":" + su.getId());
            }
            return invalidBehaviors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll(double time) {
        ArrayList<TimedPlanUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            logger.debug("Stopping speechunits");
            for (TimedPlanUnit su : this.speechUnits) {
                try {
                    su.stop(time);
                }
                catch (TimedPlanUnitPlayException e) {
                    logger.warn("SpeechUnit won't stop: {}", (Throwable)e);
                }
            }
            logger.debug("Clearing speechunits");
            this.speechUnits.clear();
        }
        logger.debug("Schedule VPP stop");
        this.scheduleStop();
        logger.debug("VPP cleared");
    }

    private void suException(TimedPlanUnit su, String message, double time) {
        logger.debug("suException with {}:{}", (Object)su.getBMLId(), (Object)su.getId());
        String bmlId = su.getBMLId();
        String id = "w-" + su.getId();
        HashSet<String> droppedBehaviours = new HashSet<String>();
        droppedBehaviours.add(su.getId());
        HashSet modifiedConstraints = new HashSet();
        String warningText = String.valueOf(message) + "\nBehavior " + su.getBMLId() + ":" + su.getId() + " dropped.";
        this.exception(new BMLExceptionFeedback(id, bmlId, time, droppedBehaviours, modifiedConstraints, warningText, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getBehaviours(String bmlId) {
        HashSet<String> behaviours = new HashSet<String>();
        ArrayList<TimedPlanUnit> arrayList = this.speechUnits;
        synchronized (arrayList) {
            for (TimedPlanUnit su : this.speechUnits) {
                if (!su.getBMLId().equals(bmlId)) continue;
                behaviours.add(su.getId());
            }
        }
        return behaviours;
    }

    public double getEndTime(String behId, String bmlId) {
        TimedPlanUnit pu = this.getSpeechUnit(behId, bmlId);
        if (pu == null) {
            return -1.7976931348623157E308;
        }
        return pu.getEndTime();
    }

    public void setParameterValue(String behId, String bmlId, String paramId, float value) {
        for (TimedPlanUnit su : this.speechUnits) {
            if (!su.getBMLId().equals(bmlId) || !su.getId().equals(behId) || !su.isPlaying() && !su.isLurking()) continue;
            su.setParameterValue(paramId, value);
        }
    }

    public void setParameterValue(String behId, String bmlId, String paramId, String value) {
        for (TimedPlanUnit su : this.speechUnits) {
            if (!su.getBMLId().equals(bmlId) || !su.getId().equals(behId)) continue;
            su.setParameterValue(paramId, value);
        }
    }

    public synchronized void exception(BMLExceptionFeedback e) {
        for (BMLExceptionListener el : this.exceptionListeners) {
            el.exception(e);
        }
    }

    public synchronized void addExceptionListener(BMLExceptionListener ws) {
        this.exceptionListeners.add(ws);
    }

    public synchronized void removeAllWarningListeners() {
        this.exceptionListeners.clear();
    }

    static /* synthetic */ Logger access$0() {
        return logger;
    }

    static /* synthetic */ ArrayList access$1(VerbalPlanPlayer verbalPlanPlayer) {
        return verbalPlanPlayer.speechUnits;
    }

    static /* synthetic */ boolean access$2(VerbalPlanPlayer verbalPlanPlayer) {
        return verbalPlanPlayer.doStop;
    }

    static /* synthetic */ double access$3(VerbalPlanPlayer verbalPlanPlayer) {
        return verbalPlanPlayer.time;
    }

    static /* synthetic */ void access$4(VerbalPlanPlayer verbalPlanPlayer, TimedPlanUnit timedPlanUnit, String string, double d) {
        verbalPlanPlayer.suException(timedPlanUnit, string, d);
    }

    class SpeechRunner
    implements Runnable {
        SpeechRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            VerbalPlanPlayer.access$0().debug("start verbalplanplayer");
            oldTime = -1.0;
            speechUnitsCache = new ArrayList<E>();
            speechUnitsRemove = new ArrayList<TimedPlanUnit>();
            block7: while (true) {
                var7_5 = VerbalPlanPlayer.access$1(VerbalPlanPlayer.this);
                synchronized (var7_5) {
                    VerbalPlanPlayer.access$1(VerbalPlanPlayer.this).removeAll(speechUnitsRemove);
                    if (VerbalPlanPlayer.access$2(VerbalPlanPlayer.this)) {
                        break;
                    }
                    t = VerbalPlanPlayer.access$3(VerbalPlanPlayer.this);
                    speechUnitsCache.clear();
                    speechUnitsCache.addAll(VerbalPlanPlayer.access$1(VerbalPlanPlayer.this));
                }
                if (t == oldTime) continue;
                oldTime = t;
                speechUnitsRemove.clear();
                var8_6 = speechUnitsCache.iterator();
                while (true) {
                    if (var8_6.hasNext()) ** break;
                    continue block7;
                    su = (TimedPlanUnit)var8_6.next();
                    if (!(t >= su.getStartTime())) continue;
                    if (su.getState().isLurking()) {
                        try {
                            su.start(t);
                        }
                        catch (TimedPlanUnitPlayException e) {
                            VerbalPlanPlayer.access$0().debug("TimedPlanUnitPlayException!");
                            VerbalPlanPlayer.access$4(VerbalPlanPlayer.this, su, e.getLocalizedMessage(), t);
                            speechUnitsRemove.add(su);
                        }
                    }
                    if (!su.getState().isPlaying()) continue;
                    try {
                        VerbalPlanPlayer.access$0().debug("su.play({})", (Object)t);
                        su.play(t);
                    }
                    catch (TimedPlanUnitPlayException e) {
                        VerbalPlanPlayer.access$0().debug("TimedPlanUnitPlayException!");
                        VerbalPlanPlayer.access$4(VerbalPlanPlayer.this, su, e.getLocalizedMessage(), t);
                        speechUnitsRemove.add(su);
                    }
                }
                break;
            }
            VerbalPlanPlayer.access$0().debug("stopped verbalplanplayer");
        }
    }
}

