/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import com.google.common.collect.Sets;
import hmi.bml.core.Behaviour;
import hmi.bml.core.SpeechBehaviour;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.audioengine.WavClipUnit;
import hmi.elckerlyc.audioengine.WavUnit;
import hmi.elckerlyc.audioengine.WavUnitPlanningException;
import hmi.elckerlyc.audioengine.WavUnitPlayException;
import hmi.elckerlyc.speechengine.SpeechUnitPlanningException;
import hmi.elckerlyc.speechengine.TimedTTSUnit;
import hmi.elckerlyc.speechengine.ttsbinding.TTSBinding;
import hmi.tts.Bookmark;
import hmi.tts.TimingInfo;
import hmi.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedWavTTSUnit
extends TimedTTSUnit {
    protected WavUnit wavUnit;
    private File tempFile;
    private Set<Bookmark> progressHandled = Sets.newHashSet();
    private static Logger logger = LoggerFactory.getLogger((String)TimedWavTTSUnit.class.getName());

    public TimedWavTTSUnit(BMLBlockPeg bbPeg, String text, String id, String bmlId, TTSBinding ttsBin, Class<? extends Behaviour> behClass) {
        super(bbPeg, text, id, bmlId, ttsBin, behClass);
    }

    public TimedWavTTSUnit(BMLBlockPeg bbPeg, String text, String id, String bmlId, TTSBinding ttsBin) {
        super(bbPeg, text, id, bmlId, ttsBin, SpeechBehaviour.class);
    }

    @Override
    public synchronized void sendProgress(double playTime, double time) {
        for (Bookmark b : this.bookmarks) {
            if (playTime >= (double)b.getOffset() / 1000.0) {
                if (this.progressHandled.contains(b)) continue;
                String bmlId = this.getBMLId();
                String behaviorId = this.getId();
                String syncId = b.getName();
                String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
                double bmlBlockTime = time - this.bmlBlockPeg.getValue();
                this.feedback(new BMLSyncPointProgressFeedback(id, this.getBMLId(), behaviorId, syncId, bmlBlockTime, time));
                this.progressHandled.add(b);
                continue;
            }
            if (!this.progressHandled.contains(b)) continue;
            this.progressHandled.remove(b);
        }
    }

    @Override
    public synchronized void playUnit(double time) throws TimedPlanUnitPlayException {
        double playTime = time - this.getStartTime();
        try {
            this.wavUnit.play(playTime);
        }
        catch (WavUnitPlayException e) {
            TimedPlanUnitPlayException supe = new TimedPlanUnitPlayException(e.getLocalizedMessage(), this);
            supe.initCause(e);
            throw supe;
        }
        this.sendProgress(playTime, time);
    }

    @Override
    public synchronized void stopUnit(double time) {
        if (time >= this.getEndTime()) {
            this.sendProgress(time - this.getStartTime(), time);
            this.sendEndProgress(time);
        }
        this.progressHandled.clear();
        this.wavUnit.stop();
    }

    @Override
    public synchronized void resetUnit() {
        this.progressHandled.clear();
        if (this.wavUnit != null) {
            this.wavUnit.reset();
        }
    }

    @Override
    protected synchronized void startUnit(double time) throws TimedPlanUnitPlayException {
        this.sendStartProgress(time);
        this.bmlStartTime = time;
        if (this.wavUnit == null) {
            throw new TimedPlanUnitPlayException("null wavUnit", this);
        }
        this.wavUnit.setPlaying(true);
    }

    @Override
    protected synchronized void setupCache() throws SpeechUnitPlanningException {
        try {
            try {
                try {
                    this.wavUnit = new WavClipUnit(this.tempFile.toURI().toURL());
                }
                catch (WavUnitPlanningException e) {
                    SpeechUnitPlanningException ttup = new SpeechUnitPlanningException(e.getLocalizedMessage(), this);
                    ttup.initCause(e);
                    throw ttup;
                }
            }
            catch (MalformedURLException e) {
                SpeechUnitPlanningException ttup = new SpeechUnitPlanningException(e.getLocalizedMessage(), this);
                ttup.initCause(e);
                throw ttup;
            }
        }
        finally {
            if (this.tempFile != null && !this.tempFile.delete()) {
                logger.warn("Couldn't delete temp file in WavTTSUnit: {}", (Object)this.tempFile.toString());
            }
        }
    }

    @Override
    protected synchronized TimingInfo getTiming() throws SpeechUnitPlanningException {
        String fileName = String.valueOf(this.getBMLId()) + "-" + this.getId();
        TimingInfo ti = null;
        try {
            this.tempFile = File.createTempFile(fileName, ".wav");
        }
        catch (IOException e) {
            SpeechUnitPlanningException tupe = new SpeechUnitPlanningException(e.getLocalizedMessage(), this);
            tupe.initCause(e);
            throw tupe;
        }
        try {
            ti = this.ttsBinding.speakToFile(this.getBehaviourClass(), this.speechText, this.tempFile.getAbsolutePath());
        }
        catch (IOException e) {
            SpeechUnitPlanningException tupe = new SpeechUnitPlanningException(e.getLocalizedMessage(), this);
            tupe.initCause(e);
            throw tupe;
        }
        this.progressHandled.clear();
        return ti;
    }

    @Override
    public synchronized void setParameterValue(String parameter, float value) {
        logger.debug("Setting parameter {} value {}", (Object)parameter, (Object)Float.valueOf(value));
        this.wavUnit.setParameterValue(parameter, value);
    }

    @Override
    public synchronized void setParameterValue(String paramId, String value) {
        if (StringUtil.isNumeric((String)value)) {
            this.setParameterValue(paramId, Float.parseFloat(value));
        }
    }
}

