/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.bml.core.Behaviour;
import hmi.bml.core.SpeechBehaviour;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.speechengine.TimedTTSUnit;
import hmi.elckerlyc.speechengine.ttsbinding.TTSBinding;
import hmi.tts.TTSCallback;
import hmi.tts.TimingInfo;
import hmi.util.StringUtil;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedDirectTTSUnit
extends TimedTTSUnit {
    private double systemStartTime;
    @GuardedBy(value="ttsBinding")
    private boolean played = false;
    private static Logger logger = LoggerFactory.getLogger((String)TimedDirectTTSUnit.class.getName());

    public TimedDirectTTSUnit(BMLBlockPeg bbPeg, String text, String id, String bmlId, TTSBinding ttsBin, Class<? extends Behaviour> behClass) {
        super(bbPeg, text, id, bmlId, ttsBin, behClass);
    }

    public TimedDirectTTSUnit(BMLBlockPeg bbPeg, String text, String id, String bmlId, TTSBinding ttsBin) {
        super(bbPeg, text, id, bmlId, ttsBin, SpeechBehaviour.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playUnit(double time) throws TimedPlanUnitPlayException {
        TTSBinding tTSBinding = this.ttsBinding;
        synchronized (tTSBinding) {
            if (!this.played) {
                logger.debug("playUnit {}", (Object)this.speechText);
                this.sendStartProgress(time);
                this.bmlStartTime = time;
                this.systemStartTime = (double)System.nanoTime() / 1.0E9;
                this.ttsBinding.setCallback(new MyTTSCallback());
                this.ttsBinding.speak(this.getBehaviourClass(), this.speechText);
                this.played = true;
            }
        }
    }

    @Override
    protected TimingInfo getTiming() {
        return this.ttsBinding.getTiming(this.getBehaviourClass(), this.speechText);
    }

    @Override
    public void sendProgress(double playTime, double time) {
    }

    @Override
    public void setParameterValue(String parameter, float value) {
        this.ttsBinding.setParameterValue(parameter, value);
    }

    @Override
    public void setParameterValue(String paramId, String value) {
        if (StringUtil.isNumeric((String)value)) {
            this.setParameterValue(paramId, Float.parseFloat(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stopUnit(double time) throws TimedPlanUnitPlayException {
        if (time >= this.getEndTime()) {
            this.sendEndProgress(time);
            TTSBinding tTSBinding = this.ttsBinding;
            synchronized (tTSBinding) {
                logger.debug("StopUnit {}", (Object)this.speechText);
                this.played = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetUnit(double time) {
        TTSBinding tTSBinding = this.ttsBinding;
        synchronized (tTSBinding) {
            logger.debug("resetUnit {}", (Object)this.speechText);
            this.played = false;
        }
    }

    protected class MyTTSCallback
    implements TTSCallback {
        protected MyTTSCallback() {
        }

        public void bookmarkCallback(String bookmark) {
            double bmTime = (double)System.nanoTime() / 1.0E9;
            String bmlId = TimedDirectTTSUnit.this.getBMLId();
            String behaviorId = TimedDirectTTSUnit.this.getId();
            String syncId = bookmark;
            String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
            double timeStamp = TimedDirectTTSUnit.this.bmlStartTime + (bmTime - TimedDirectTTSUnit.this.systemStartTime);
            double bmlBlockTime = timeStamp - TimedDirectTTSUnit.this.bmlBlockPeg.getValue();
            TimedDirectTTSUnit.this.feedback(new BMLSyncPointProgressFeedback(id, TimedDirectTTSUnit.this.getBMLId(), behaviorId, syncId, bmlBlockTime, timeStamp));
        }

        public void phonemeCallback(int phoneme, int dur, int nextPhoneme, boolean stress) {
        }

        public void sentenceBoundryCallback(int offset, int length) {
        }

        public boolean stopCallback() {
            return TimedDirectTTSUnit.this.isDone() || TimedDirectTTSUnit.this.isLurking();
        }

        public void visimeCallback(int visime, int duration, int nextVis, boolean stress) {
            TimedDirectTTSUnit.this.prevVisime = TimedDirectTTSUnit.this.curVisime;
            TimedDirectTTSUnit.this.curVisime = visime;
            TimedDirectTTSUnit.this.nextVisime = nextVis;
            TimedDirectTTSUnit.this.visimeDuration = (double)duration / 1000.0;
        }

        public void wordBoundryCallback(int offset, int length) {
        }
    }
}

