/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.bml.feedback.BMLFeedbackListener;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.speechengine.TextOutput;
import hmi.elckerlyc.speechengine.TimedTextSpeechUnit;
import hmi.testutil.bml.feedback.ListFeedbackListener;
import java.util.ArrayList;
import mockit.Mocked;
import mockit.NonStrictExpectations;
import org.junit.Assert;
import org.junit.Test;

public class TextSpeechUnitTest {
    @Mocked
    TextOutput mockOutput;

    @Test
    public void testSpeak() throws TimedPlanUnitPlayException {
        TimedTextSpeechUnit textUnit = new TimedTextSpeechUnit(BMLBlockPeg.GLOBALPEG, "Hello world", "speech1", "bml1", this.mockOutput);
        ArrayList fbList = new ArrayList();
        ListFeedbackListener fbl = new ListFeedbackListener(fbList);
        textUnit.addFeedbackListener((BMLFeedbackListener)fbl);
        TimePeg tpStart = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpStart.setGlobalValue(0.0);
        textUnit.setStart(tpStart);
        Assert.assertEquals((double)textUnit.getEndTime(), (double)(textUnit.getStartTime() + textUnit.getPreferedDuration()), (double)1.0E-4);
        Assert.assertTrue((textUnit.getPreferedDuration() > 0.0 ? 1 : 0) != 0);
        textUnit.setState(TimedPlanUnitState.LURKING);
        new NonStrictExpectations(){
            {
                TextSpeechUnitTest.this.mockOutput.setText(anyString);
                minTimes = 1;
            }
        };
        textUnit.start(0.0);
        Assert.assertTrue((textUnit.getState() == TimedPlanUnitState.IN_EXEC ? 1 : 0) != 0);
        Assert.assertTrue((fbList.size() == 4 ? 1 : 0) != 0);
        textUnit.play(10.0);
        Assert.assertTrue((textUnit.getState() == TimedPlanUnitState.DONE ? 1 : 0) != 0);
        Assert.assertTrue((fbList.size() == 7 ? 1 : 0) != 0);
    }

    @Test
    public void testSpeakWithSync() throws TimedPlanUnitPlayException {
        TimedTextSpeechUnit textUnit = new TimedTextSpeechUnit(BMLBlockPeg.GLOBALPEG, "Hello<sync id=\"s1\"/> world", "speech1", "bml1", this.mockOutput);
        ArrayList fbList = new ArrayList();
        ListFeedbackListener fbl = new ListFeedbackListener(fbList);
        textUnit.addFeedbackListener((BMLFeedbackListener)fbl);
        TimePeg tpStart = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpStart.setGlobalValue(0.0);
        textUnit.setStart(tpStart);
        Assert.assertEquals((double)textUnit.getEndTime(), (double)(textUnit.getStartTime() + textUnit.getPreferedDuration()), (double)1.0E-4);
        Assert.assertTrue((textUnit.getPreferedDuration() > 0.0 ? 1 : 0) != 0);
        textUnit.setState(TimedPlanUnitState.LURKING);
        new NonStrictExpectations(){
            {
                TextSpeechUnitTest.this.mockOutput.setText(anyString);
                minTimes = 1;
            }
        };
        textUnit.start(0.0);
        Assert.assertTrue((textUnit.getState() == TimedPlanUnitState.IN_EXEC ? 1 : 0) != 0);
        Assert.assertTrue((fbList.size() == 4 ? 1 : 0) != 0);
        textUnit.play(10.0);
        Assert.assertTrue((textUnit.getState() == TimedPlanUnitState.DONE ? 1 : 0) != 0);
        Assert.assertTrue((fbList.size() == 8 ? 1 : 0) != 0);
    }
}

