/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.bml.core.Behaviour;
import hmi.bml.core.SpeechBehaviour;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.bml.parser.Constraint;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import hmi.elckerlyc.speechengine.TextOutput;
import hmi.elckerlyc.speechengine.TextPlanner;
import hmi.elckerlyc.speechengine.TimedTextSpeechUnit;
import hmi.elckerlyc.speechengine.VerbalPlayer;
import hmi.testutil.bml.feedback.ListBMLExceptionListener;
import java.util.ArrayList;
import mockit.Mock;
import mockit.MockUp;
import mockit.Mocked;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Test;

public class TextPlannerTest {
    @Mocked
    TextOutput mockTextOutput;

    @Test
    public void testWarning() throws BehaviourPlanningException, InterruptedException {
        ArrayList exceptionList = new ArrayList();
        VerbalPlayer vp = new VerbalPlayer();
        TextPlanner textP = new TextPlanner(vp, this.mockTextOutput);
        textP.addExceptionListener((BMLExceptionListener)new ListBMLExceptionListener(exceptionList));
        final BMLBlockPeg bbPeg = new BMLBlockPeg("Peg1", 0.3);
        SpeechBehaviour beh = new SpeechBehaviour();
        beh.readXML("<speech id=\"speech1\"><text>Hello world</text></speech>");
        beh.bmlId = "bml1";
        ArrayList<TimePegAndConstraint> sacs = new ArrayList<TimePegAndConstraint>();
        TimePeg sp = new TimePeg(bbPeg);
        sp.setGlobalValue(1.0);
        sacs.add(new TimePegAndConstraint("start", sp, new Constraint(), 0.0, false));
        new MockUp<TimedTextSpeechUnit>(){

            @Mock
            public double getPreferedDuration() {
                return 3.0;
            }

            @Mock
            protected void playUnit(double time) throws TimedPlanUnitPlayException {
                throw new TimedPlanUnitPlayException("Play failed!", new TimedTextSpeechUnit(bbPeg, "", "speech1", "bml1", TextPlannerTest.this.mockTextOutput));
            }
        };
        TimedPlanUnit pu = textP.resolveSynchs(bbPeg, (Behaviour)beh, sacs);
        pu.setState(TimedPlanUnitState.LURKING);
        textP.addBehaviour(bbPeg, (Behaviour)beh, sacs, pu);
        Assert.assertEquals((double)1.0, (double)pu.getStartTime(), (double)1.0E-4);
        Assert.assertEquals((double)4.0, (double)pu.getEndTime(), (double)1.0E-4);
        vp.play(0.0);
        MatcherAssert.assertThat(exceptionList, (Matcher)IsCollectionWithSize.hasSize((int)0));
        vp.play(2.0);
        Thread.sleep(1000L);
        MatcherAssert.assertThat(exceptionList, (Matcher)IsCollectionWithSize.hasSize((int)1));
    }
}

