/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.bml.core.Behaviour;
import hmi.bml.core.SpeechBehaviour;
import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.bml.parser.Constraint;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.scheduler.BMLScheduler;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import hmi.elckerlyc.speechengine.SpeechUnitPlanningException;
import hmi.elckerlyc.speechengine.TTSPlanner;
import hmi.elckerlyc.speechengine.TestUtil;
import hmi.elckerlyc.speechengine.TimedTTSUnit;
import hmi.elckerlyc.speechengine.TimedTTSUnitFactory;
import hmi.elckerlyc.speechengine.VerbalPlayer;
import hmi.elckerlyc.speechengine.ttsbinding.TTSBinding;
import hmi.testutil.bml.feedback.ListBMLExceptionListener;
import hmi.testutil.bml.feedback.ListFeedbackListener;
import hmi.tts.Bookmark;
import hmi.tts.TimingInfo;
import hmi.tts.WordDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mockit.Mock;
import mockit.MockUp;
import mockit.Mocked;
import mockit.NonStrictExpectations;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TTSPlannerTest {
    @Mocked
    TTSBinding mockTTSBinding;
    @Mocked
    TimedTTSUnitFactory mockTTSUnitFactory;
    @Mocked
    TimingInfo mockTimingInfo;
    @Mocked
    BMLScheduler mockScheduler;
    public static final String SPEECHID = "speech1";
    public static final String BMLID = "bml1";
    public static final String SPEECHTEXT = "Hello<sync id=\"s1\"/> world";
    public static final double SPEECH_DURATION = 3.0;
    public static final double SYNC1_OFFSET = 1.0;
    protected BMLBlockPeg bbPeg;
    protected TTSPlanner ttsPlanner;
    protected VerbalPlayer verbalPlayer;
    protected List<BMLExceptionFeedback> exceptionList;
    protected List<BMLSyncPointProgressFeedback> feedbackList;

    protected void mockTTSUnitFactoryExpectations() {
        TTSUnitStub stubTTSUnit = new TTSUnitStub(this.bbPeg, SPEECHTEXT, SPEECHID, BMLID, this.mockTTSBinding, SpeechBehaviour.class);
        new NonStrictExpectations(stubTTSUnit){
            {
                TTSPlannerTest.this.mockTTSUnitFactory.createTimedTTSUnit(TTSPlannerTest.this.bbPeg, anyString, TTSPlannerTest.SPEECHID, TTSPlannerTest.BMLID, TTSPlannerTest.this.mockTTSBinding, SpeechBehaviour.class);
                this.returns(tTSUnitStub);
                times = 1;
            }
        };
    }

    @Before
    public void setUp() {
        this.bbPeg = new BMLBlockPeg(BMLID, 0.3);
        new MockUp<TTSUnitStub>(){

            @Mock
            public double getPreferedDuration() {
                return 3.0;
            }
        };
        this.mockTTSUnitFactoryExpectations();
        this.verbalPlayer = new VerbalPlayer();
        this.ttsPlanner = new TTSPlanner(this.mockTTSUnitFactory, this.verbalPlayer, this.mockTTSBinding);
        this.exceptionList = Collections.synchronizedList(new ArrayList());
        this.ttsPlanner.addExceptionListener((BMLExceptionListener)new ListBMLExceptionListener(this.exceptionList));
        this.feedbackList = Collections.synchronizedList(new ArrayList());
        this.ttsPlanner.addFeedbackListener((BMLFeedbackListener)new ListFeedbackListener(this.feedbackList));
    }

    @After
    public void tearDown() throws InterruptedException {
        this.verbalPlayer.shutdown();
    }

    protected SpeechBehaviour createSpeechBehaviour(String speechBML, String bmlId) {
        SpeechBehaviour beh = new SpeechBehaviour();
        beh.readXML(speechBML);
        beh.bmlId = bmlId;
        return beh;
    }

    protected SpeechBehaviour createSpeechBehaviour(String id, String bmlId, String speech) {
        return this.createSpeechBehaviour(String.format("<speech id=\"%s\"><text>%s</text></speech>", id, speech), bmlId);
    }

    protected void mockPlayException() {
        new MockUp<TTSUnitStub>(){

            @Mock
            protected void playUnit(double time) throws TimedPlanUnitPlayException {
                throw new TimedPlanUnitPlayException("Play failed!", new TTSUnitStub(TTSPlannerTest.this.bbPeg, "", TTSPlannerTest.SPEECHID, TTSPlannerTest.BMLID, TTSPlannerTest.this.mockTTSBinding, SpeechBehaviour.class));
            }
        };
    }

    @Test
    public void testResolveUnknownStartAndEnd() throws BehaviourPlanningException {
        SpeechBehaviour beh = this.createSpeechBehaviour(SPEECHID, BMLID, SPEECHTEXT);
        ArrayList<TimePegAndConstraint> sacs = new ArrayList<TimePegAndConstraint>();
        TimePeg endPeg = new TimePeg(this.bbPeg);
        sacs.add(new TimePegAndConstraint("end", endPeg, new Constraint(), 0.0, false));
        TimePeg s1Peg = new TimePeg(this.bbPeg);
        sacs.add(new TimePegAndConstraint("s1", s1Peg, new Constraint(), 0.0, false));
        OffsetPeg startPeg = new OffsetPeg(new TimePeg(this.bbPeg), 0.0, this.bbPeg);
        sacs.add(new TimePegAndConstraint("start", startPeg, new Constraint(), 0.0, true));
        TimedPlanUnit pu = this.ttsPlanner.resolveSynchs(this.bbPeg, (Behaviour)beh, sacs);
        Assert.assertEquals((double)0.3, (double)((TimePeg)startPeg).getGlobalValue(), (double)1.0E-4);
        TestUtil.assertInRangeExclusive(s1Peg.getGlobalValue(), ((TimePeg)startPeg).getGlobalValue(), endPeg.getGlobalValue());
        this.ttsPlanner.addBehaviour(this.bbPeg, (Behaviour)beh, sacs, pu);
        Assert.assertEquals((double)0.3, (double)pu.getStartTime(), (double)1.0E-4);
        Assert.assertEquals((double)3.3, (double)pu.getEndTime(), (double)1.0E-4);
        Assert.assertEquals((Object)endPeg, (Object)((TimePeg)startPeg).getLink());
        Assert.assertEquals((double)3.3, (double)endPeg.getGlobalValue(), (double)1.0E-4);
        Assert.assertEquals((double)0.3, (double)((TimePeg)startPeg).getGlobalValue(), (double)1.0E-4);
        TestUtil.assertInRangeExclusive(s1Peg.getGlobalValue(), ((TimePeg)startPeg).getGlobalValue(), endPeg.getGlobalValue());
    }

    @Test
    public void testUnknownStart() throws BehaviourPlanningException {
        SpeechBehaviour beh = this.createSpeechBehaviour(SPEECHID, BMLID, SPEECHTEXT);
        ArrayList<TimePegAndConstraint> sacs = new ArrayList<TimePegAndConstraint>();
        TimePeg sp = new TimePeg(this.bbPeg);
        sacs.add(new TimePegAndConstraint("start", sp, new Constraint(), 0.0, false));
        TimedPlanUnit pu = this.ttsPlanner.resolveSynchs(this.bbPeg, (Behaviour)beh, sacs);
        Assert.assertEquals((double)0.3, (double)sp.getGlobalValue(), (double)1.0E-4);
        this.ttsPlanner.addBehaviour(this.bbPeg, (Behaviour)beh, sacs, pu);
        Assert.assertEquals((double)0.3, (double)pu.getStartTime(), (double)1.0E-4);
        Assert.assertEquals((double)3.3, (double)pu.getEndTime(), (double)1.0E-4);
    }

    @Test
    public void testResolveUnknownStartKnownEnd() throws BehaviourPlanningException {
        SpeechBehaviour beh = this.createSpeechBehaviour(SPEECHID, BMLID, SPEECHTEXT);
        ArrayList<TimePegAndConstraint> sacs = new ArrayList<TimePegAndConstraint>();
        TimePeg endPeg = new TimePeg(this.bbPeg);
        endPeg.setGlobalValue(5.0);
        sacs.add(new TimePegAndConstraint("end", endPeg, new Constraint(), 0.0, false));
        TimePeg s1Peg = new TimePeg(this.bbPeg);
        sacs.add(new TimePegAndConstraint("s1", s1Peg, new Constraint(), 0.0, false));
        OffsetPeg startPeg = new OffsetPeg(new TimePeg(this.bbPeg), 0.0, this.bbPeg);
        sacs.add(new TimePegAndConstraint("start", startPeg, new Constraint(), 0.0, true));
        TimedPlanUnit pu = this.ttsPlanner.resolveSynchs(this.bbPeg, (Behaviour)beh, sacs);
        Assert.assertEquals((double)2.0, (double)((TimePeg)startPeg).getGlobalValue(), (double)1.0E-4);
        TestUtil.assertInRangeExclusive(s1Peg.getGlobalValue(), ((TimePeg)startPeg).getGlobalValue(), endPeg.getGlobalValue());
        Assert.assertEquals((double)5.0, (double)endPeg.getGlobalValue(), (double)1.0E-4);
        this.ttsPlanner.addBehaviour(this.bbPeg, (Behaviour)beh, sacs, pu);
        Assert.assertEquals((double)2.0, (double)pu.getStartTime(), (double)1.0E-4);
        Assert.assertEquals((double)5.0, (double)pu.getEndTime(), (double)1.0E-4);
        Assert.assertEquals((Object)endPeg, (Object)((TimePeg)startPeg).getLink());
        Assert.assertEquals((double)5.0, (double)endPeg.getGlobalValue(), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)((TimePeg)startPeg).getGlobalValue(), (double)1.0E-4);
        TestUtil.assertInRangeExclusive(s1Peg.getGlobalValue(), ((TimePeg)startPeg).getGlobalValue(), endPeg.getGlobalValue());
    }

    @Test
    public void testResolveUnknownStartUnknownEndKnownS1() throws BehaviourPlanningException {
        SpeechBehaviour beh = this.createSpeechBehaviour(SPEECHID, BMLID, SPEECHTEXT);
        ArrayList<TimePegAndConstraint> sacs = new ArrayList<TimePegAndConstraint>();
        TimePeg endPeg = new TimePeg(this.bbPeg);
        sacs.add(new TimePegAndConstraint("end", endPeg, new Constraint(), 0.0, false));
        TimePeg s1Peg = new TimePeg(this.bbPeg);
        s1Peg.setGlobalValue(2.0);
        sacs.add(new TimePegAndConstraint("s1", s1Peg, new Constraint(), 0.0, false));
        OffsetPeg startPeg = new OffsetPeg(new TimePeg(this.bbPeg), 0.0, this.bbPeg);
        sacs.add(new TimePegAndConstraint("start", startPeg, new Constraint(), 0.0, true));
        TimedPlanUnit pu = this.ttsPlanner.resolveSynchs(this.bbPeg, (Behaviour)beh, sacs);
        Assert.assertTrue((((TimePeg)startPeg).getGlobalValue() < s1Peg.getGlobalValue() ? 1 : 0) != 0);
        Assert.assertTrue((endPeg.getGlobalValue() > s1Peg.getGlobalValue() ? 1 : 0) != 0);
        Assert.assertEquals((double)2.0, (double)s1Peg.getGlobalValue(), (double)1.0E-4);
        this.ttsPlanner.addBehaviour(this.bbPeg, (Behaviour)beh, sacs, pu);
        Assert.assertEquals((Object)endPeg, (Object)((TimePeg)startPeg).getLink());
        Assert.assertTrue((((TimePeg)startPeg).getGlobalValue() < s1Peg.getGlobalValue() ? 1 : 0) != 0);
        Assert.assertTrue((endPeg.getGlobalValue() > s1Peg.getGlobalValue() ? 1 : 0) != 0);
        Assert.assertEquals((double)2.0, (double)s1Peg.getGlobalValue(), (double)1.0E-4);
    }

    @Test
    public void testWarning() throws BehaviourPlanningException, InterruptedException {
        SpeechBehaviour beh = this.createSpeechBehaviour(SPEECHID, BMLID, SPEECHTEXT);
        ArrayList<TimePegAndConstraint> sacs = new ArrayList<TimePegAndConstraint>();
        TimePeg sp = new TimePeg(this.bbPeg);
        sp.setGlobalValue(1.0);
        sacs.add(new TimePegAndConstraint("start", sp, new Constraint(), 0.0, false));
        this.mockPlayException();
        TimedPlanUnit pu = this.ttsPlanner.resolveSynchs(this.bbPeg, (Behaviour)beh, sacs);
        pu.setState(TimedPlanUnitState.LURKING);
        this.ttsPlanner.addBehaviour(this.bbPeg, (Behaviour)beh, sacs, pu);
        Assert.assertEquals((double)1.0, (double)pu.getStartTime(), (double)1.0E-4);
        Assert.assertEquals((double)4.0, (double)pu.getEndTime(), (double)1.0E-4);
        this.verbalPlayer.play(0.0);
        Assert.assertTrue((this.exceptionList.size() == 0 ? 1 : 0) != 0);
        this.verbalPlayer.play(2.0);
        Thread.sleep(500L);
        Assert.assertEquals((long)1L, (long)this.exceptionList.size());
    }

    public void testRemoveBehaviour() throws BehaviourPlanningException {
        SpeechBehaviour beh = this.createSpeechBehaviour(SPEECHID, BMLID, SPEECHTEXT);
        ArrayList<TimePegAndConstraint> sacs = new ArrayList<TimePegAndConstraint>();
        TimedPlanUnit pu = this.ttsPlanner.resolveSynchs(this.bbPeg, (Behaviour)beh, sacs);
        this.ttsPlanner.addBehaviour(this.bbPeg, (Behaviour)beh, sacs, pu);
        this.ttsPlanner.removeBehaviour(SPEECHID, BMLID);
        Assert.assertEquals((long)0L, (long)this.ttsPlanner.getBehaviours(BMLID).size());
    }

    private static class TTSUnitStub
    extends TimedTTSUnit {
        public TTSUnitStub(BMLBlockPeg bbPeg, String text, String id, String bmlId, TTSBinding ttsBin, Class<? extends Behaviour> behClass) {
            super(bbPeg, text, id, bmlId, ttsBin, behClass);
        }

        @Override
        protected TimingInfo getTiming() throws SpeechUnitPlanningException {
            return null;
        }

        @Override
        public void sendProgress(double playTime, double time) {
        }

        @Override
        public void setParameterValue(String paramater, float value) {
        }

        @Override
        protected void playUnit(double time) throws TimedPlanUnitPlayException {
        }

        @Override
        protected void stopUnit(double time) throws TimedPlanUnitPlayException {
        }

        @Override
        public double getPreferedDuration() {
            return 0.0;
        }

        @Override
        public void setup() {
            WordDescription wd2 = new WordDescription("world", new ArrayList(), new ArrayList());
            this.bookmarks.add(new Bookmark("s1", wd2, 1000));
        }

        @Override
        public void setParameterValue(String paramId, String value) {
        }
    }
}

