/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.bml.core.SpeechBehaviour;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.speechengine.DirectTTSUnitFactory;
import hmi.elckerlyc.speechengine.SpeechUnitPlanningException;
import hmi.elckerlyc.speechengine.TimedTTSUnit;
import hmi.elckerlyc.speechengine.TimedTTSUnitFactory;
import hmi.elckerlyc.speechengine.WavTTSUnitFactory;
import hmi.elckerlyc.speechengine.ttsbinding.TTSBinding;
import hmi.elckerlyc.util.SAPITTSBindingFactory;
import hmi.elckerlyc.util.TTSBindingFactory;
import hmi.testutil.LabelledParameterized;
import hmi.testutil.bml.feedback.ListFeedbackListener;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=LabelledParameterized.class)
public class SpeechUnitParameterizedTest {
    private TTSBinding ttsBinding;
    private TimedTTSUnitFactory ttsUnitFactory;

    public SpeechUnitParameterizedTest(String label, TimedTTSUnitFactory fa, TTSBindingFactory bindingFactory) {
        this.ttsBinding = bindingFactory.createBinding();
        this.ttsUnitFactory = fa;
    }

    @After
    public void cleanup() {
        this.ttsBinding.cleanup();
    }

    @Test
    public void testSpeak() throws TimedPlanUnitPlayException, SpeechUnitPlanningException {
        TimedTTSUnit ttsUnit = this.ttsUnitFactory.createTimedTTSUnit(BMLBlockPeg.GLOBALPEG, "Hello world", "speech1", "bml1", this.ttsBinding, SpeechBehaviour.class);
        ttsUnit.setup();
        ArrayList fbList = new ArrayList();
        ListFeedbackListener fbl = new ListFeedbackListener(fbList);
        ttsUnit.addFeedbackListener((BMLFeedbackListener)fbl);
        TimePeg tpStart = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpStart.setGlobalValue(0.0);
        ttsUnit.setStart(tpStart);
        Assert.assertEquals((double)ttsUnit.getEndTime(), (double)(ttsUnit.getStartTime() + ttsUnit.getPreferedDuration()), (double)1.0E-4);
        Assert.assertTrue((ttsUnit.getPreferedDuration() > 0.0 ? 1 : 0) != 0);
        ttsUnit.setState(TimedPlanUnitState.LURKING);
        ttsUnit.start(0.0);
        Assert.assertTrue((ttsUnit.getState() == TimedPlanUnitState.IN_EXEC ? 1 : 0) != 0);
        ttsUnit.play(0.0);
        Assert.assertTrue((fbList.size() == 4 ? 1 : 0) != 0);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        ttsUnit.play(10.0);
        Assert.assertTrue((ttsUnit.getState() == TimedPlanUnitState.DONE ? 1 : 0) != 0);
        Assert.assertTrue((fbList.size() == 7 ? 1 : 0) != 0);
    }

    @Test
    public void testSpeakReset() throws TimedPlanUnitPlayException, SpeechUnitPlanningException {
        TimedTTSUnit ttsUnit = this.ttsUnitFactory.createTimedTTSUnit(BMLBlockPeg.GLOBALPEG, "Hello world", "speech1", "bml1", this.ttsBinding, SpeechBehaviour.class);
        ttsUnit.setup();
        ArrayList fbList = new ArrayList();
        ListFeedbackListener fbl = new ListFeedbackListener(fbList);
        ttsUnit.addFeedbackListener((BMLFeedbackListener)fbl);
        TimePeg tpStart = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tpStart.setGlobalValue(0.0);
        ttsUnit.setStart(tpStart);
        Assert.assertEquals((double)ttsUnit.getEndTime(), (double)(ttsUnit.getStartTime() + ttsUnit.getPreferedDuration()), (double)1.0E-4);
        Assert.assertTrue((ttsUnit.getPreferedDuration() > 0.0 ? 1 : 0) != 0);
        ttsUnit.setState(TimedPlanUnitState.LURKING);
        ttsUnit.start(0.0);
        Assert.assertTrue((ttsUnit.getState() == TimedPlanUnitState.IN_EXEC ? 1 : 0) != 0);
        ttsUnit.play(0.0);
        Assert.assertTrue((fbList.size() == 4 ? 1 : 0) != 0);
        ttsUnit.reset();
        Assert.assertTrue((ttsUnit.getState() == TimedPlanUnitState.LURKING ? 1 : 0) != 0);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> configs() throws Exception {
        ArrayList<Object[]> objs = new ArrayList<Object[]>();
        Object[] obj = new Object[]{"DirectTTSUnitFactory, SAPITTSBinding", DirectTTSUnitFactory.getFactory(), new SAPITTSBindingFactory()};
        objs.add(obj);
        ArrayList<WavTTSUnitFactory> ttsFactories = new ArrayList<WavTTSUnitFactory>();
        ttsFactories.add(WavTTSUnitFactory.getFactory());
        ArrayList<SAPITTSBindingFactory> ttsBindingFactories = new ArrayList<SAPITTSBindingFactory>();
        ttsBindingFactories.add(new SAPITTSBindingFactory());
        for (TimedTTSUnitFactory timedTTSUnitFactory : ttsFactories) {
            for (TTSBindingFactory tTSBindingFactory : ttsBindingFactories) {
                obj = new Object[]{String.valueOf(timedTTSUnitFactory.getClass().getName()) + ", " + tTSBindingFactory.getClass().getName(), timedTTSUnitFactory, tTSBindingFactory};
                objs.add(obj);
            }
        }
        return objs;
    }
}

