/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.bml.core.SpeechBehaviour;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.speechengine.SpeechUnitPlanningException;
import hmi.elckerlyc.speechengine.TimedDirectTTSUnit;
import hmi.elckerlyc.speechengine.TimedTTSUnit;
import hmi.elckerlyc.speechengine.ttsbinding.TTSBinding;
import hmi.testutil.bml.feedback.ListFeedbackListener;
import hmi.tts.TimingInfo;
import java.util.ArrayList;
import mockit.Mocked;
import mockit.NonStrictExpectations;
import org.junit.Assert;
import org.junit.Test;

public class DirectTTSUnitTest {
    @Mocked
    TTSBinding mockTTSBinding;
    @Mocked
    TimingInfo mockTimingInfo;
    protected TimedTTSUnit ttsUnit;

    protected TimedTTSUnit getTTSUnit(BMLBlockPeg bbPeg, String text, String id, String bmlId) {
        return new TimedDirectTTSUnit(bbPeg, text, id, bmlId, this.mockTTSBinding, SpeechBehaviour.class);
    }

    @Test
    public void testTTSUnit() throws TimedPlanUnitPlayException, SpeechUnitPlanningException, InterruptedException {
        BMLBlockPeg bbPeg = new BMLBlockPeg("Peg1", 0.3);
        TimePeg tp = new TimePeg(bbPeg);
        tp.setGlobalValue(2.0);
        ArrayList feedbackList = new ArrayList();
        this.ttsUnit = this.getTTSUnit(bbPeg, "Hello world", "speech1", "bml1");
        new NonStrictExpectations(){
            {
                DirectTTSUnitTest.this.mockTTSBinding.getTiming(SpeechBehaviour.class, "Hello world");
                this.returns(DirectTTSUnitTest.this.mockTimingInfo);
                times = 1;
                DirectTTSUnitTest.this.mockTimingInfo.getDuration();
                this.returns(3.0);
            }
        };
        this.ttsUnit.addFeedbackListener((BMLFeedbackListener)new ListFeedbackListener(feedbackList));
        this.ttsUnit.setStart(tp);
        this.ttsUnit.setup();
        this.ttsUnit.setState(TimedPlanUnitState.LURKING);
        this.ttsUnit.start(2.0);
        Assert.assertTrue((TimedPlanUnitState.IN_EXEC == this.ttsUnit.getState() ? 1 : 0) != 0);
        this.ttsUnit.play(2.0);
        Thread.sleep(100L);
        Assert.assertTrue((feedbackList.size() == 4 ? 1 : 0) != 0);
        int i = 0;
        while (i < 4) {
            Assert.assertEquals((Object)"bml1", (Object)((BMLSyncPointProgressFeedback)feedbackList.get((int)i)).bmlId);
            Assert.assertEquals((Object)"speech1", (Object)((BMLSyncPointProgressFeedback)feedbackList.get((int)i)).behaviorId);
            Assert.assertEquals((double)1.7, (double)((BMLSyncPointProgressFeedback)feedbackList.get((int)i)).bmlBlockTime, (double)1.0E-4);
            Assert.assertEquals((double)2.0, (double)((BMLSyncPointProgressFeedback)feedbackList.get((int)i)).timeStamp, (double)1.0E-4);
            ++i;
        }
        Assert.assertEquals((Object)"start", (Object)((BMLSyncPointProgressFeedback)feedbackList.get((int)0)).syncId);
        Assert.assertEquals((Object)"ready", (Object)((BMLSyncPointProgressFeedback)feedbackList.get((int)1)).syncId);
        Assert.assertEquals((Object)"stroke_start", (Object)((BMLSyncPointProgressFeedback)feedbackList.get((int)2)).syncId);
        Assert.assertEquals((Object)"stroke", (Object)((BMLSyncPointProgressFeedback)feedbackList.get((int)3)).syncId);
        this.ttsUnit.play(6.0);
        Thread.sleep(100L);
        Assert.assertTrue((feedbackList.size() == 7 ? 1 : 0) != 0);
        i = 4;
        while (i < 7) {
            Assert.assertEquals((Object)"bml1", (Object)((BMLSyncPointProgressFeedback)feedbackList.get((int)i)).bmlId);
            Assert.assertEquals((Object)"speech1", (Object)((BMLSyncPointProgressFeedback)feedbackList.get((int)i)).behaviorId);
            Assert.assertEquals((double)5.7, (double)((BMLSyncPointProgressFeedback)feedbackList.get((int)i)).bmlBlockTime, (double)1.0E-4);
            Assert.assertEquals((double)6.0, (double)((BMLSyncPointProgressFeedback)feedbackList.get((int)i)).timeStamp, (double)1.0E-4);
            ++i;
        }
        Assert.assertEquals((Object)"stroke_end", (Object)((BMLSyncPointProgressFeedback)feedbackList.get((int)4)).syncId);
        Assert.assertEquals((Object)"relax", (Object)((BMLSyncPointProgressFeedback)feedbackList.get((int)5)).syncId);
        Assert.assertEquals((Object)"end", (Object)((BMLSyncPointProgressFeedback)feedbackList.get((int)6)).syncId);
    }
}

