/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.bml.core.Behaviour;
import hmi.bml.core.SpeechBehaviour;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.bml.parser.Constraint;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.PegBoard;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import hmi.elckerlyc.speechengine.TTSPlannerTest;
import hmi.elckerlyc.speechengine.TimedDirectTTSUnit;
import hmi.tts.Bookmark;
import hmi.tts.WordDescription;
import java.util.ArrayList;
import java.util.List;
import mockit.Mock;
import mockit.MockUp;
import mockit.NonStrictExpectations;
import org.junit.Assert;
import org.junit.Test;

public class DirectTTSPlannerTest
extends TTSPlannerTest {
    @Override
    protected void mockTTSUnitFactoryExpectations() {
        TimedDirectTTSUnit ttsUnit = new TimedDirectTTSUnit(this.bbPeg, "Hello<sync id=\"s1\"/> world", "speech1", "bml1", this.mockTTSBinding, SpeechBehaviour.class);
        WordDescription wd2 = new WordDescription("world", new ArrayList(), new ArrayList());
        ArrayList<Bookmark> bms = new ArrayList<Bookmark>();
        Bookmark bm = new Bookmark("s1", wd2, 500);
        bms.add(bm);
        new NonStrictExpectations(ttsUnit, bm, bms){
            {
                DirectTTSPlannerTest.this.mockTTSUnitFactory.createTimedTTSUnit(DirectTTSPlannerTest.this.bbPeg, anyString, "speech1", "bml1", DirectTTSPlannerTest.this.mockTTSBinding, SpeechBehaviour.class);
                this.returns(timedDirectTTSUnit);
                times = 1;
                DirectTTSPlannerTest.this.mockTTSBinding.getTiming(SpeechBehaviour.class, "Hello<sync id=\"s1\"/> world");
                this.returns(DirectTTSPlannerTest.this.mockTimingInfo);
                DirectTTSPlannerTest.this.mockTimingInfo.getDuration();
                this.returns(3.0);
                DirectTTSPlannerTest.this.mockTimingInfo.getBookmark("s1");
                this.returns(bookmark);
                DirectTTSPlannerTest.this.mockTimingInfo.getBookmarks();
                this.returns(collection);
            }
        };
    }

    @Override
    protected void mockPlayException() {
        new MockUp<TimedDirectTTSUnit>(){

            @Mock
            protected void playUnit(double time) throws TimedPlanUnitPlayException {
                throw new TimedPlanUnitPlayException("Play failed!", new TimedDirectTTSUnit(DirectTTSPlannerTest.this.bbPeg, "", "speech1", "bml1", DirectTTSPlannerTest.this.mockTTSBinding, SpeechBehaviour.class));
            }
        };
    }

    @Test
    public void testDirectTTSFeedback() throws BehaviourPlanningException, InterruptedException {
        SpeechBehaviour beh = this.createSpeechBehaviour("speech1", "bml1", "Hello<sync id=\"s1\"/> world");
        ArrayList<TimePegAndConstraint> sacs = new ArrayList<TimePegAndConstraint>();
        TimePeg sp = new TimePeg(this.bbPeg);
        sp.setGlobalValue(1.0);
        sacs.add(new TimePegAndConstraint("start", sp, new Constraint(), 0.0, false));
        TimedPlanUnit pu = this.ttsPlanner.resolveSynchs(this.bbPeg, (Behaviour)beh, sacs);
        pu.setState(TimedPlanUnitState.LURKING);
        this.ttsPlanner.addBehaviour(this.bbPeg, (Behaviour)beh, sacs, pu);
        Assert.assertEquals((double)1.0, (double)pu.getStartTime(), (double)1.0E-4);
        Assert.assertEquals((double)4.0, (double)pu.getEndTime(), (double)1.0E-4);
        Assert.assertTrue((this.verbalPlayer.getNumberOfSpeechUnits() == 1 ? 1 : 0) != 0);
        this.verbalPlayer.play(1.0);
        Thread.sleep(200L);
        Assert.assertTrue((pu.getState() == TimedPlanUnitState.IN_EXEC ? 1 : 0) != 0);
        Assert.assertTrue((this.exceptionList.size() == 0 ? 1 : 0) != 0);
        System.out.println(this.feedbackList);
        Assert.assertTrue((this.feedbackList.size() == 4 ? 1 : 0) != 0);
        int i = 0;
        while (i < 4) {
            Assert.assertEquals((Object)"bml1", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)i)).bmlId);
            Assert.assertEquals((Object)"speech1", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)i)).behaviorId);
            Assert.assertEquals((double)0.7, (double)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)i)).bmlBlockTime, (double)1.0E-4);
            Assert.assertEquals((double)1.0, (double)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)i)).timeStamp, (double)1.0E-4);
            ++i;
        }
        Assert.assertEquals((Object)"start", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)0)).syncId);
        Assert.assertEquals((Object)"ready", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)1)).syncId);
        Assert.assertEquals((Object)"stroke_start", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)2)).syncId);
        Assert.assertEquals((Object)"stroke", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)3)).syncId);
        this.verbalPlayer.play(4.0);
        Thread.sleep(100L);
        Assert.assertTrue((this.feedbackList.size() == 7 ? 1 : 0) != 0);
        i = 4;
        while (i < 7) {
            Assert.assertEquals((Object)"bml1", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)i)).bmlId);
            Assert.assertEquals((Object)"speech1", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)i)).behaviorId);
            Assert.assertEquals((double)3.7, (double)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)i)).bmlBlockTime, (double)1.0E-4);
            Assert.assertEquals((double)4.0, (double)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)i)).timeStamp, (double)1.0E-4);
            ++i;
        }
        Assert.assertEquals((Object)"stroke_end", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)4)).syncId);
        Assert.assertEquals((Object)"relax", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)5)).syncId);
        Assert.assertEquals((Object)"end", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)6)).syncId);
    }

    @Test
    public void testDirectTTSFeedbackBlockManager() throws BehaviourPlanningException, InterruptedException {
        SpeechBehaviour beh = this.createSpeechBehaviour("speech1", "bml1", "Hello<sync id=\"s1\"/> world");
        ArrayList<TimePegAndConstraint> sacs = new ArrayList<TimePegAndConstraint>();
        TimePeg sp = new TimePeg(this.bbPeg);
        sp.setGlobalValue(1.0);
        sacs.add(new TimePegAndConstraint("start", sp, new Constraint(), 0.0, false));
        PegBoard pegBoard = new PegBoard();
        new NonStrictExpectations(pegBoard){
            {
                DirectTTSPlannerTest.this.mockScheduler.getPegBoard();
                this.returns(pegBoard);
                DirectTTSPlannerTest.this.mockScheduler.blockStopFeedback("bml1");
            }
        };
        TimedPlanUnit pu = this.ttsPlanner.resolveSynchs(this.bbPeg, (Behaviour)beh, sacs);
        pu.setState(TimedPlanUnitState.LURKING);
        List<SyncAndTimePeg> satps = this.ttsPlanner.addBehaviour(this.bbPeg, (Behaviour)beh, sacs, pu);
        pegBoard.addTimePegs(satps);
        Assert.assertEquals((double)4.0, (double)this.verbalPlayer.getEndTime("speech1", "bml1"), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)pu.getStartTime(), (double)1.0E-4);
        Assert.assertEquals((double)4.0, (double)pu.getEndTime(), (double)1.0E-4);
        Assert.assertTrue((this.verbalPlayer.getNumberOfSpeechUnits() == 1 ? 1 : 0) != 0);
        this.verbalPlayer.play(1.0);
        Thread.sleep(500L);
        Assert.assertTrue((pu.getState() == TimedPlanUnitState.IN_EXEC ? 1 : 0) != 0);
        Assert.assertTrue((this.exceptionList.size() == 0 ? 1 : 0) != 0);
        System.out.println(this.feedbackList);
        Assert.assertTrue((this.feedbackList.size() == 4 ? 1 : 0) != 0);
        int i = 0;
        while (i < 4) {
            Assert.assertEquals((Object)"bml1", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)i)).bmlId);
            Assert.assertEquals((Object)"speech1", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)i)).behaviorId);
            Assert.assertEquals((double)0.7, (double)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)i)).bmlBlockTime, (double)1.0E-4);
            Assert.assertEquals((double)1.0, (double)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)i)).timeStamp, (double)1.0E-4);
            ++i;
        }
        Assert.assertEquals((Object)"start", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)0)).syncId);
        Assert.assertEquals((Object)"ready", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)1)).syncId);
        Assert.assertEquals((Object)"stroke_start", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)2)).syncId);
        Assert.assertEquals((Object)"stroke", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)3)).syncId);
        this.verbalPlayer.play(4.0);
        Thread.sleep(100L);
        Assert.assertTrue((this.feedbackList.size() == 7 ? 1 : 0) != 0);
        i = 4;
        while (i < 7) {
            Assert.assertEquals((Object)"bml1", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)i)).bmlId);
            Assert.assertEquals((Object)"speech1", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)i)).behaviorId);
            Assert.assertEquals((double)3.7, (double)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)i)).bmlBlockTime, (double)1.0E-4);
            Assert.assertEquals((double)4.0, (double)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)i)).timeStamp, (double)1.0E-4);
            ++i;
        }
        Assert.assertEquals((Object)"stroke_end", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)4)).syncId);
        Assert.assertEquals((Object)"relax", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)5)).syncId);
        Assert.assertEquals((Object)"end", (Object)((BMLSyncPointProgressFeedback)this.feedbackList.get((int)6)).syncId);
        Assert.assertTrue((pu.getState() == TimedPlanUnitState.DONE ? 1 : 0) != 0);
    }
}

