/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import com.google.common.collect.Lists;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.TimedPlanUnitPlayException;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.speechengine.SpeechUnitPlanningException;
import hmi.elckerlyc.speechengine.TimedTTSUnit;
import hmi.testutil.bml.feedback.ListFeedbackListener;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractTTSUnitTest {
    private TimedTTSUnit ttsUnit;
    private List<BMLSyncPointProgressFeedback> feedbackList;
    private static final double TTSUNIT_GLOBALSTART = 2.0;
    private static final double BMLBLOCKSTART = 0.3;
    private BMLBlockPeg bbPeg;
    private TimePeg startPeg;

    protected abstract TimedTTSUnit getTTSUnit(BMLBlockPeg var1, String var2, String var3, String var4);

    public void setup() throws SpeechUnitPlanningException {
        this.bbPeg = new BMLBlockPeg("Peg1", 0.3);
        this.startPeg = new TimePeg(this.bbPeg);
        this.startPeg.setGlobalValue(2.0);
        this.feedbackList = Lists.newArrayList();
    }

    private void initTTSUnit(String text) throws SpeechUnitPlanningException {
        this.ttsUnit = this.getTTSUnit(this.bbPeg, text, "speech1", "bml1");
        this.ttsUnit.addFeedbackListener((BMLFeedbackListener)new ListFeedbackListener(this.feedbackList));
        this.ttsUnit.setStart(this.startPeg);
        this.ttsUnit.setup();
    }

    @Test
    public void testSetup() throws SpeechUnitPlanningException {
        this.initTTSUnit("Hello <sync id=\"s1\"/>world");
        MatcherAssert.assertThat(this.ttsUnit.getBookmarks(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertEquals((Object)"s1", (Object)this.ttsUnit.getBookmarks().get(0).getName());
        Assert.assertEquals((double)2.0, (double)this.ttsUnit.getStartTime(), (double)0.001f);
        MatcherAssert.assertThat((Object)this.ttsUnit.getBookmarks().get(0).getOffset(), (Matcher)OrderingComparison.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void testTTSUnit() throws TimedPlanUnitPlayException, SpeechUnitPlanningException, InterruptedException {
        this.initTTSUnit("Hello world");
        this.ttsUnit.setState(TimedPlanUnitState.LURKING);
        this.ttsUnit.start(2.0);
        Assert.assertTrue((TimedPlanUnitState.IN_EXEC == this.ttsUnit.getState() ? 1 : 0) != 0);
        this.ttsUnit.play(2.0);
        Thread.sleep(200L);
        MatcherAssert.assertThat(this.feedbackList, (Matcher)IsCollectionWithSize.hasSize((int)4));
        int i = 0;
        while (i < 4) {
            Assert.assertEquals((Object)"bml1", (Object)this.feedbackList.get((int)i).bmlId);
            Assert.assertEquals((Object)"speech1", (Object)this.feedbackList.get((int)i).behaviorId);
            Assert.assertEquals((double)1.7, (double)this.feedbackList.get((int)i).bmlBlockTime, (double)1.0E-4);
            Assert.assertEquals((double)2.0, (double)this.feedbackList.get((int)i).timeStamp, (double)1.0E-4);
            ++i;
        }
        Assert.assertEquals((Object)"start", (Object)this.feedbackList.get((int)0).syncId);
        Assert.assertEquals((Object)"ready", (Object)this.feedbackList.get((int)1).syncId);
        Assert.assertEquals((Object)"stroke_start", (Object)this.feedbackList.get((int)2).syncId);
        Assert.assertEquals((Object)"stroke", (Object)this.feedbackList.get((int)3).syncId);
        this.ttsUnit.play(6.0);
        Thread.sleep(100L);
        MatcherAssert.assertThat(this.feedbackList, (Matcher)IsCollectionWithSize.hasSize((int)7));
        i = 4;
        while (i < 7) {
            Assert.assertEquals((Object)"bml1", (Object)this.feedbackList.get((int)i).bmlId);
            Assert.assertEquals((Object)"speech1", (Object)this.feedbackList.get((int)i).behaviorId);
            Assert.assertEquals((double)5.7, (double)this.feedbackList.get((int)i).bmlBlockTime, (double)1.0E-4);
            Assert.assertEquals((double)6.0, (double)this.feedbackList.get((int)i).timeStamp, (double)1.0E-4);
            ++i;
        }
        Assert.assertEquals((Object)"stroke_end", (Object)this.feedbackList.get((int)4).syncId);
        Assert.assertEquals((Object)"relax", (Object)this.feedbackList.get((int)5).syncId);
        Assert.assertEquals((Object)"end", (Object)this.feedbackList.get((int)6).syncId);
    }

    @Test
    public void testTTSUnitWithSync() throws TimedPlanUnitPlayException, SpeechUnitPlanningException, InterruptedException {
        this.initTTSUnit("Hello <sync id=\"s1\"/>world");
        this.ttsUnit.setState(TimedPlanUnitState.LURKING);
        this.ttsUnit.start(2.0);
        Assert.assertTrue((TimedPlanUnitState.IN_EXEC == this.ttsUnit.getState() ? 1 : 0) != 0);
        this.ttsUnit.play(2.0);
        Thread.sleep(100L);
        int i = 0;
        while (i < 4) {
            Assert.assertEquals((Object)"bml1", (Object)this.feedbackList.get((int)i).bmlId);
            Assert.assertEquals((Object)"speech1", (Object)this.feedbackList.get((int)i).behaviorId);
            Assert.assertEquals((double)1.7, (double)this.feedbackList.get((int)i).bmlBlockTime, (double)1.0E-4);
            Assert.assertEquals((double)2.0, (double)this.feedbackList.get((int)i).timeStamp, (double)1.0E-4);
            ++i;
        }
        Assert.assertEquals((Object)"start", (Object)this.feedbackList.get((int)0).syncId);
        Assert.assertEquals((Object)"ready", (Object)this.feedbackList.get((int)1).syncId);
        Assert.assertEquals((Object)"stroke_start", (Object)this.feedbackList.get((int)2).syncId);
        Assert.assertEquals((Object)"stroke", (Object)this.feedbackList.get((int)3).syncId);
        this.ttsUnit.play(6.0);
        Thread.sleep(100L);
        MatcherAssert.assertThat(this.feedbackList, (Matcher)IsCollectionWithSize.hasSize((int)8));
        Assert.assertEquals((Object)"bml1", (Object)this.feedbackList.get((int)4).bmlId);
        Assert.assertEquals((Object)"speech1", (Object)this.feedbackList.get((int)4).behaviorId);
        Assert.assertEquals((Object)"s1", (Object)this.feedbackList.get((int)4).syncId);
        i = 5;
        while (i < 8) {
            Assert.assertEquals((Object)"bml1", (Object)this.feedbackList.get((int)i).bmlId);
            Assert.assertEquals((Object)"speech1", (Object)this.feedbackList.get((int)i).behaviorId);
            Assert.assertEquals((double)5.7, (double)this.feedbackList.get((int)i).bmlBlockTime, (double)1.0E-4);
            Assert.assertEquals((double)6.0, (double)this.feedbackList.get((int)i).timeStamp, (double)1.0E-4);
            ++i;
        }
        Assert.assertEquals((Object)"stroke_end", (Object)this.feedbackList.get((int)5).syncId);
        Assert.assertEquals((Object)"relax", (Object)this.feedbackList.get((int)6).syncId);
        Assert.assertEquals((Object)"end", (Object)this.feedbackList.get((int)7).syncId);
    }
}

