/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.scheduler;

import hmi.bml.core.Behaviour;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.planunit.RelativeSyncNotFoundException;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import hmi.elckerlyc.scheduler.UniModalResolver;
import java.util.List;

public class LinearStretchResolver
implements UniModalResolver {
    private BehaviourPlanningException getWrappedBehaviourPlanningException(Behaviour b, String m, Exception ex) {
        BehaviourPlanningException be = new BehaviourPlanningException(b, m);
        be.initCause(ex);
        return be;
    }

    @Override
    public void resolveSynchs(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sac, TimedPlanUnit pu) throws BehaviourPlanningException {
        List<TimePegAndConstraint> sortedSac = sac;
        int sections = 0;
        double totalStretch = 0.0;
        TimePegAndConstraint sPrev = null;
        for (TimePegAndConstraint s : sortedSac) {
            if (s.peg.getGlobalValue() == -1.7976931348623157E308) continue;
            if (sPrev != null) {
                double duration = pu.getTime(s.id) - pu.getTime(sPrev.id);
                double startKey = 0.0;
                double endKey = 0.0;
                for (String syncId : pu.getAvailableSyncs()) {
                    if (pu.getTimePeg(syncId) == null) continue;
                    if (pu.getTimePeg(syncId).getLink() == sPrev.peg.getLink()) {
                        try {
                            startKey = pu.getRelativeTime(syncId);
                        }
                        catch (RelativeSyncNotFoundException e) {
                            throw this.getWrappedBehaviourPlanningException(b, "RelativeSyncNotFoundException", e);
                        }
                    }
                    if (pu.getTimePeg(syncId).getLink() != s.peg.getLink()) continue;
                    try {
                        startKey = pu.getRelativeTime(syncId);
                    }
                    catch (RelativeSyncNotFoundException e) {
                        throw this.getWrappedBehaviourPlanningException(b, "RelativeSyncNotFoundException", e);
                    }
                }
                double nominalDuration = (endKey - startKey) * pu.getPreferedDuration();
                if (!(nominalDuration > 0.0)) continue;
                totalStretch += duration / nominalDuration;
                ++sections;
                continue;
            }
            sPrev = s;
        }
        double avgStretch = 1.0;
        if (sections > 0) {
            avgStretch = totalStretch / (double)sections;
        }
        if (sortedSac.size() > 0) {
            TimePegAndConstraint sacStart = sortedSac.get(0);
            if (sacStart.peg.getGlobalValue() == -1.7976931348623157E308) {
                TimePegAndConstraint sacNext = null;
                for (TimePegAndConstraint s : sortedSac) {
                    if (s.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                    sacNext = s;
                    break;
                }
                if (sacNext == null) {
                    sacStart.peg.setLocalValue(0.0);
                } else {
                    double nextKey;
                    try {
                        nextKey = pu.getRelativeTime(sacNext.id);
                    }
                    catch (RelativeSyncNotFoundException e) {
                        throw this.getWrappedBehaviourPlanningException(b, "RelativeSyncNotFoundException", e);
                    }
                    double nextTime = pu.getTime(sacNext.id);
                    double tStart = nextTime - nextKey * avgStretch * pu.getPreferedDuration();
                    if (sacStart.resolveAsStartOffset) {
                        OffsetPeg os = (OffsetPeg)sacStart.peg;
                        os.setLink(pu.getTimePeg(sacNext.id));
                        os.setOffset(tStart - nextTime);
                    } else {
                        sacStart.peg.setGlobalValue(tStart + sacStart.offset);
                    }
                }
            }
            TimePegAndConstraint sacEnd = sortedSac.get(sortedSac.size() - 1);
            if (sacEnd.peg.getGlobalValue() == -1.7976931348623157E308) {
                TimePegAndConstraint sacPrev = null;
                for (TimePegAndConstraint s : sortedSac) {
                    if (s.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                    sacPrev = s;
                }
                if (sacPrev == null) {
                    sacEnd.peg.setGlobalValue(pu.getPreferedDuration());
                } else {
                    double keyCurr;
                    double keyPrev;
                    try {
                        keyPrev = pu.getRelativeTime(sacPrev.id);
                    }
                    catch (RelativeSyncNotFoundException e) {
                        throw this.getWrappedBehaviourPlanningException(b, "RelativeSyncNotFoundException", e);
                    }
                    double keyNext = 1.0;
                    try {
                        keyCurr = pu.getRelativeTime(sacEnd.id);
                    }
                    catch (RelativeSyncNotFoundException e) {
                        throw this.getWrappedBehaviourPlanningException(b, "RelativeSyncNotFoundException", e);
                    }
                    double timePrev = pu.getTime(sacPrev.id);
                    double timeNext = timePrev + (keyNext - keyPrev) * avgStretch * pu.getPreferedDuration();
                    sacEnd.peg.setGlobalValue(timePrev + (keyCurr - keyPrev) * (timeNext - timePrev) / (keyNext - keyPrev) + sacEnd.offset);
                }
            }
            TimePegAndConstraint sacPrev = sacStart;
            TimePegAndConstraint sacNext = null;
            for (TimePegAndConstraint s : sortedSac) {
                if (s.peg.getGlobalValue() == -1.7976931348623157E308) {
                    double keyCurr;
                    double keyNext;
                    double keyPrev;
                    for (TimePegAndConstraint s2 : sortedSac.subList(sortedSac.indexOf(s), sortedSac.size())) {
                        if (s2.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                        sacNext = s2;
                        break;
                    }
                    try {
                        keyPrev = pu.getRelativeTime(sacPrev.id);
                    }
                    catch (RelativeSyncNotFoundException e) {
                        throw this.getWrappedBehaviourPlanningException(b, "RelativeSyncNotFoundException", e);
                    }
                    try {
                        keyNext = pu.getRelativeTime(sacNext.id);
                    }
                    catch (RelativeSyncNotFoundException e) {
                        throw this.getWrappedBehaviourPlanningException(b, "RelativeSyncNotFoundException", e);
                    }
                    try {
                        keyCurr = pu.getRelativeTime(s.id);
                    }
                    catch (RelativeSyncNotFoundException e) {
                        throw this.getWrappedBehaviourPlanningException(b, "RelativeSyncNotFoundException", e);
                    }
                    double timePrev = pu.getTime(sacPrev.id);
                    double timeNext = pu.getTime(sacNext.id);
                    s.peg.setGlobalValue(timePrev + (keyCurr - keyPrev) * (timeNext - timePrev) / (keyNext - keyPrev) + s.offset);
                }
                sacPrev = s;
            }
            sacEnd = sortedSac.get(sortedSac.size() - 1);
            if (!sacEnd.id.equals("end") && pu.getPreferedDuration() > 0.0) {
                double keyEnd;
                double keyPrev;
                try {
                    keyPrev = pu.getRelativeTime(sacEnd.id);
                }
                catch (RelativeSyncNotFoundException e) {
                    throw this.getWrappedBehaviourPlanningException(b, "RelativeSyncNotFoundException", e);
                }
                try {
                    keyEnd = pu.getRelativeTime("end");
                }
                catch (RelativeSyncNotFoundException e) {
                    throw this.getWrappedBehaviourPlanningException(b, "RelativeSyncNotFoundException", e);
                }
                OffsetPeg op = new OffsetPeg(pu.getTimePeg(sacEnd.id), (keyEnd - keyPrev) * avgStretch * pu.getPreferedDuration());
                pu.setTimePeg("end", op);
            }
        }
    }
}

