/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.scheduler;

import hmi.bml.core.Behaviour;
import hmi.bml.core.BehaviourBlock;
import hmi.bml.core.SpeechBehaviour;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLPerformanceStartFeedback;
import hmi.bml.feedback.BMLPerformanceStopFeedback;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.bml.parser.BMLParser;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.Planner;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitState;
import hmi.elckerlyc.scheduler.BMLScheduler;
import hmi.elckerlyc.scheduler.SchedulingClock;
import hmi.elckerlyc.scheduler.SchedulingStrategy;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import hmi.testutil.bml.feedback.ListFeedbackListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mockit.Delegate;
import mockit.Mocked;
import mockit.NonStrictExpectations;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BMLSchedulerTest {
    @Mocked
    SchedulingStrategy mockSchedulingStrategy;
    private StubPlanner stubPlanner;
    private BMLScheduler scheduler;
    private BMLParser parser;
    private ListFeedbackListener listFeedbackListener;
    private List<BMLSyncPointProgressFeedback> feedBackList;
    private List<BMLPerformanceStartFeedback> startFeedbackList;
    private List<BMLPerformanceStopFeedback> endFeedbackList;

    private List<String> getBMLIdsFromStartFeedback(List<BMLPerformanceStartFeedback> fbList) {
        ArrayList<String> bmlIds = new ArrayList<String>();
        for (BMLPerformanceStartFeedback fb : fbList) {
            bmlIds.add(fb.bmlId);
        }
        return bmlIds;
    }

    private List<String> getBMLIdsFromEndFeedback(List<BMLPerformanceStopFeedback> fbList) {
        ArrayList<String> bmlIds = new ArrayList<String>();
        for (BMLPerformanceStopFeedback fb : fbList) {
            bmlIds.add(fb.bmlId);
        }
        return bmlIds;
    }

    private String createEmptyBML(String bmlId, String extraAttributes) {
        return "<bml xmlns:bmlt=\"http://hmi.ewi.utwente.nl/bmlt\" id=\"" + bmlId + "\" " + extraAttributes + "/>";
    }

    private String createNonEmptyBML(String bmlId, String extraAttributes) {
        return "<bml xmlns:bmlt=\"http://hmi.ewi.utwente.nl/bmlt\" id=\"" + bmlId + "\" " + extraAttributes + "><speech id=\"s1\"><text/></speech></bml>";
    }

    private String createNonEmptyBML(String bmlId) {
        return "<bml xmlns:bmlt=\"http://hmi.ewi.utwente.nl/bmlt\" id=\"" + bmlId + "\"><speech id=\"s1\"><text/></speech></bml>";
    }

    @Before
    public void setup() {
        this.parser = new BMLParser();
        this.scheduler = new BMLScheduler(this.parser, new StubSchedulingClock(), this.mockSchedulingStrategy);
        this.stubPlanner = new StubPlanner();
        this.scheduler.addPlanner(SpeechBehaviour.class, this.stubPlanner);
        this.feedBackList = new ArrayList<BMLSyncPointProgressFeedback>();
        this.startFeedbackList = new ArrayList<BMLPerformanceStartFeedback>();
        this.endFeedbackList = new ArrayList<BMLPerformanceStopFeedback>();
        this.listFeedbackListener = new ListFeedbackListener(this.feedBackList, this.startFeedbackList, this.endFeedbackList);
        this.scheduler.addFeedbackListener((BMLFeedbackListener)this.listFeedbackListener);
        new NonStrictExpectations(){
            {
                BMLSchedulerTest.this.mockSchedulingStrategy.schedule((BehaviourBlock)any, (BMLBlockPeg)any, (BMLScheduler)any, anyDouble);
                result = new Delegate(){

                    void schedule(BehaviourBlock bb, BMLBlockPeg bPeg, BMLScheduler scheduler, double time) {
                        for (Behaviour b : bb.behaviours) {
                            BMLSchedulerTest.this.stubPlanner.addBehaviour(b.bmlId, b.id);
                        }
                    }
                };
            }
        };
    }

    private void parseBML(String str) {
        BehaviourBlock bb = new BehaviourBlock();
        bb.readXML(str);
        this.parser.addBehaviourBlock(bb);
    }

    @Test
    public void testStart() {
        this.parseBML("<bml id=\"bml1\"/>");
        this.scheduler.schedule();
        Assert.assertEquals((long)1L, (long)this.startFeedbackList.size());
        Assert.assertEquals((Object)"bml1", (Object)this.startFeedbackList.get((int)0).bmlId);
    }

    @Test
    public void testAppend() {
        this.parseBML(this.createNonEmptyBML("bml1"));
        this.parseBML(this.createNonEmptyBML("bml2", "scheduling=\"append\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)1L, (long)this.startFeedbackList.size());
        Assert.assertEquals((Object)"bml1", (Object)this.startFeedbackList.get((int)0).bmlId);
        this.scheduler.blockStopFeedback("bml1");
        Assert.assertEquals((long)1L, (long)this.endFeedbackList.size());
        Assert.assertEquals((Object)"bml1", (Object)this.endFeedbackList.get((int)0).bmlId);
        Assert.assertEquals((long)2L, (long)this.startFeedbackList.size());
        Assert.assertEquals((Object)"bml2", (Object)this.startFeedbackList.get((int)1).bmlId);
        Assert.assertThat((Object)this.listFeedbackListener.getIndex((Object)this.startFeedbackList.get(1)), (Matcher)OrderingComparison.greaterThan((Comparable)Integer.valueOf(this.listFeedbackListener.getIndex((Object)this.endFeedbackList.get(0)))));
    }

    @Test
    public void testEmptyMerge() {
        this.parseBML(this.createEmptyBML("bml1", "scheduling=\"merge\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)1L, (long)this.startFeedbackList.size());
        Assert.assertEquals((Object)"bml1", (Object)this.startFeedbackList.get((int)0).bmlId);
        Assert.assertEquals((long)1L, (long)this.endFeedbackList.size());
        Assert.assertEquals((Object)"bml1", (Object)this.endFeedbackList.get((int)0).bmlId);
    }

    @Test
    public void testEmptyReplace() {
        this.parseBML(this.createEmptyBML("bml1", "scheduling=\"replace\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)1L, (long)this.startFeedbackList.size());
        Assert.assertEquals((Object)"bml1", (Object)this.startFeedbackList.get((int)0).bmlId);
        Assert.assertEquals((long)1L, (long)this.endFeedbackList.size());
        Assert.assertEquals((Object)"bml1", (Object)this.endFeedbackList.get((int)0).bmlId);
    }

    @Test
    public void testEmptyAppend() {
        this.parseBML(this.createNonEmptyBML("bml1", "scheduling=\"append\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)1L, (long)this.startFeedbackList.size());
        Assert.assertEquals((Object)"bml1", (Object)this.startFeedbackList.get((int)0).bmlId);
        this.scheduler.blockStopFeedback("bml1");
        Assert.assertEquals((long)1L, (long)this.endFeedbackList.size());
        Assert.assertEquals((Object)"bml1", (Object)this.endFeedbackList.get((int)0).bmlId);
    }

    @Test
    public void testAppend2() {
        this.parseBML(this.createNonEmptyBML("bml1"));
        this.scheduler.schedule();
        this.parseBML(this.createNonEmptyBML("bml2", "scheduling=\"append\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)1L, (long)this.startFeedbackList.size());
        Assert.assertEquals((Object)"bml1", (Object)this.startFeedbackList.get((int)0).bmlId);
        this.scheduler.blockStopFeedback("bml1");
        Assert.assertEquals((long)1L, (long)this.endFeedbackList.size());
        Assert.assertEquals((Object)"bml1", (Object)this.endFeedbackList.get((int)0).bmlId);
        Assert.assertEquals((long)2L, (long)this.startFeedbackList.size());
        Assert.assertEquals((Object)"bml2", (Object)this.startFeedbackList.get((int)1).bmlId);
    }

    @Test
    public void testAppendAfter() {
        this.parseBML(this.createNonEmptyBML("bml1"));
        this.parseBML(this.createNonEmptyBML("bml2"));
        this.parseBML(this.createNonEmptyBML("bml3"));
        this.parseBML(this.createNonEmptyBML("bml4", "scheduling=\"append-after(bml2,bml3)\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)3L, (long)this.startFeedbackList.size());
        Assert.assertEquals((Object)"bml1", (Object)this.startFeedbackList.get((int)0).bmlId);
        Assert.assertEquals((Object)"bml2", (Object)this.startFeedbackList.get((int)1).bmlId);
        Assert.assertEquals((Object)"bml3", (Object)this.startFeedbackList.get((int)2).bmlId);
        this.scheduler.blockStopFeedback("bml2");
        Assert.assertEquals((long)3L, (long)this.startFeedbackList.size());
        Assert.assertEquals((long)1L, (long)this.endFeedbackList.size());
        this.scheduler.blockStopFeedback("bml3");
        Assert.assertEquals((long)4L, (long)this.startFeedbackList.size());
        Assert.assertEquals((long)2L, (long)this.endFeedbackList.size());
        Assert.assertEquals((Object)"bml4", (Object)this.startFeedbackList.get((int)3).bmlId);
    }

    @Test
    public void testAppendAfterNonExisting() {
        this.parseBML(this.createNonEmptyBML("bml1"));
        this.parseBML(this.createNonEmptyBML("bml2"));
        this.parseBML(this.createNonEmptyBML("bml3"));
        this.parseBML(this.createNonEmptyBML("bml4", "scheduling=\"append-after(bml2,bml3,bml5)\""));
        this.parseBML(this.createNonEmptyBML("bml5"));
        this.scheduler.schedule();
        Assert.assertEquals((long)4L, (long)this.startFeedbackList.size());
        Assert.assertEquals((Object)"bml1", (Object)this.startFeedbackList.get((int)0).bmlId);
        Assert.assertEquals((Object)"bml2", (Object)this.startFeedbackList.get((int)1).bmlId);
        Assert.assertEquals((Object)"bml3", (Object)this.startFeedbackList.get((int)2).bmlId);
        this.scheduler.blockStopFeedback("bml2");
        Assert.assertEquals((long)4L, (long)this.startFeedbackList.size());
        Assert.assertEquals((long)1L, (long)this.endFeedbackList.size());
        this.scheduler.blockStopFeedback("bml3");
        Assert.assertEquals((long)5L, (long)this.startFeedbackList.size());
        Assert.assertEquals((long)2L, (long)this.endFeedbackList.size());
        Assert.assertEquals((Object)"bml4", (Object)this.startFeedbackList.get((int)4).bmlId);
    }

    @Test
    public void testStartNonExisting() {
        this.scheduler.startBlock("bml1");
        Assert.assertEquals((long)0L, (long)this.startFeedbackList.size());
    }

    @Test
    public void testInteruptNonExisting() {
        this.scheduler.interruptBlock("bml1");
        Assert.assertEquals((long)0L, (long)this.startFeedbackList.size());
        Assert.assertEquals((long)0L, (long)this.endFeedbackList.size());
    }

    @Test
    public void testInterrupt() {
        this.parseBML(this.createNonEmptyBML("bml1"));
        this.scheduler.schedule();
        Assert.assertEquals((long)1L, (long)this.startFeedbackList.size());
        this.scheduler.interruptBlock("bml1");
        Assert.assertEquals((long)1L, (long)this.endFeedbackList.size());
    }

    @Test
    public void testInterruptThroughBML() {
        this.parseBML(this.createNonEmptyBML("bml1"));
        this.parseBML(this.createNonEmptyBML("bml2"));
        this.scheduler.schedule();
        Assert.assertEquals((long)2L, (long)this.startFeedbackList.size());
        this.parseBML(this.createNonEmptyBML("bml3", "scheduling=\"interrupt(bml1,bml2)\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)3L, (long)this.startFeedbackList.size());
        Assert.assertEquals((long)2L, (long)this.endFeedbackList.size());
        if (this.endFeedbackList.get((int)0).bmlId.equals("bml1")) {
            Assert.assertEquals((Object)"bml2", (Object)this.endFeedbackList.get((int)1).bmlId);
        } else if (this.endFeedbackList.get((int)0).bmlId.equals("bml2")) {
            Assert.assertEquals((Object)"bml1", (Object)this.endFeedbackList.get((int)1).bmlId);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testInterruptAppender() {
        this.parseBML(this.createNonEmptyBML("bml1"));
        this.parseBML(this.createNonEmptyBML("bml2", "scheduling=\"append\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)1L, (long)this.startFeedbackList.size());
        this.scheduler.interruptBlock("bml2");
        Assert.assertEquals((long)0L, (long)this.endFeedbackList.size());
        this.scheduler.blockStopFeedback("bml1");
        Assert.assertEquals((long)1L, (long)this.startFeedbackList.size());
        Assert.assertEquals((long)1L, (long)this.endFeedbackList.size());
    }

    @Test
    public void testAppendAfterInterrupted() {
        this.parseBML(this.createNonEmptyBML("bml1"));
        this.parseBML(this.createNonEmptyBML("bml2", "scheduling=\"append\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)1L, (long)this.startFeedbackList.size());
        Assert.assertEquals((Object)"bml1", (Object)this.startFeedbackList.get((int)0).bmlId);
        this.scheduler.interruptBlock("bml1");
        Assert.assertEquals((long)1L, (long)this.endFeedbackList.size());
        Assert.assertEquals((Object)"bml1", (Object)this.endFeedbackList.get((int)0).bmlId);
        Assert.assertEquals((long)2L, (long)this.startFeedbackList.size());
        Assert.assertEquals((Object)"bml2", (Object)this.startFeedbackList.get((int)1).bmlId);
        Assert.assertEquals((long)1L, (long)this.endFeedbackList.size());
        Assert.assertEquals((Object)"bml1", (Object)this.endFeedbackList.get((int)0).bmlId);
    }

    @Test
    public void testPreplan() {
        this.parseBML(this.createNonEmptyBML("bml2", "bmlt:preplan=\"true\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)0L, (long)this.startFeedbackList.size());
        Assert.assertEquals((long)0L, (long)this.endFeedbackList.size());
    }

    @Test
    public void testEmptyPreplan() {
        this.parseBML(this.createEmptyBML("bml2", "bmlt:preplan=\"true\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)0L, (long)this.startFeedbackList.size());
        Assert.assertEquals((long)0L, (long)this.endFeedbackList.size());
    }

    @Test
    public void testStartEmptyPreplan() {
        this.parseBML(this.createEmptyBML("bml2", "bmlt:preplan=\"true\""));
        this.scheduler.schedule();
        this.parseBML(this.createEmptyBML("bml3", "bmlt:onStart=\"bml2\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)2L, (long)this.startFeedbackList.size());
        Assert.assertEquals((long)2L, (long)this.endFeedbackList.size());
    }

    @Test
    public void testPreplanAndAppend() {
        this.parseBML(this.createNonEmptyBML("bml1"));
        this.parseBML(this.createNonEmptyBML("bml2", "scheduling=\"append\" bmlt:preplan=\"true\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)1L, (long)this.startFeedbackList.size());
        Assert.assertEquals((Object)"bml1", (Object)this.startFeedbackList.get((int)0).bmlId);
        this.scheduler.blockStopFeedback("bml1");
        Assert.assertEquals((long)1L, (long)this.startFeedbackList.size());
    }

    @Test
    public void testPreplanAndActivate() {
        this.parseBML(this.createNonEmptyBML("bml1", "bmlt:preplan=\"true\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)0L, (long)this.startFeedbackList.size());
        this.parseBML(this.createNonEmptyBML("bml2", "bmlt:onStart=\"bml1\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)2L, (long)this.startFeedbackList.size());
        Assert.assertEquals((Object)"bml2", (Object)this.startFeedbackList.get((int)0).bmlId);
        Assert.assertEquals((Object)"bml1", (Object)this.startFeedbackList.get((int)1).bmlId);
    }

    @Test
    public void testPreplanAndActivateAndAppend() {
        this.parseBML(this.createNonEmptyBML("bml1"));
        this.parseBML(this.createNonEmptyBML("bml2", "scheduling=\"append\" preplan=\"true\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)1L, (long)this.startFeedbackList.size());
        Assert.assertEquals((Object)"bml1", (Object)this.startFeedbackList.get((int)0).bmlId);
        this.parseBML(this.createNonEmptyBML("bml3", "onStart=\"bml2\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)2L, (long)this.startFeedbackList.size());
        Assert.assertEquals((Object)"bml3", (Object)this.startFeedbackList.get((int)1).bmlId);
        this.scheduler.blockStopFeedback("bml1");
        Assert.assertEquals((long)3L, (long)this.startFeedbackList.size());
        Assert.assertEquals((Object)"bml2", (Object)this.startFeedbackList.get((int)2).bmlId);
    }

    @Test
    public void testPreplanAndActivateTwice() {
        this.parseBML(this.createNonEmptyBML("bml1", "bmlt:preplan=\"true\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)0L, (long)this.startFeedbackList.size());
        this.parseBML(this.createNonEmptyBML("bml2", "bmlt:onStart=\"bml1\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)2L, (long)this.startFeedbackList.size());
        this.parseBML(this.createNonEmptyBML("bml3", "onStart=\"bml1\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)3L, (long)this.startFeedbackList.size());
    }

    @Test
    public void testReplaceAppended() {
        this.parseBML(this.createNonEmptyBML("bml1"));
        this.scheduler.schedule();
        this.parseBML(this.createNonEmptyBML("bml2", "scheduling=\"append\""));
        this.scheduler.schedule();
        this.scheduler.blockStopFeedback("bml1");
        this.parseBML(this.createEmptyBML("bml3", "scheduling=\"replace\""));
        this.scheduler.schedule();
        Assert.assertThat(this.getBMLIdsFromStartFeedback(this.startFeedbackList), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"bml1", "bml2", "bml3"}));
        Assert.assertThat(this.getBMLIdsFromEndFeedback(this.endFeedbackList), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"bml1", "bml3"}));
    }

    @Test
    public void testReplaceAppended2() {
        this.parseBML(this.createNonEmptyBML("bml1"));
        this.scheduler.schedule();
        this.parseBML(this.createNonEmptyBML("bml2", "scheduling=\"append\""));
        this.scheduler.schedule();
        this.scheduler.blockStopFeedback("bml1");
        this.parseBML(this.createNonEmptyBML("bml3", "scheduling=\"replace\""));
        this.scheduler.schedule();
        Assert.assertThat(this.getBMLIdsFromStartFeedback(this.startFeedbackList), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"bml1", "bml2", "bml3"}));
        Assert.assertThat(this.getBMLIdsFromEndFeedback(this.endFeedbackList), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"bml1"}));
    }

    @Test
    public void testReplace() {
        this.parseBML(this.createNonEmptyBML("bml3", "scheduling=\"replace\""));
        this.scheduler.schedule();
        Assert.assertThat(this.getBMLIdsFromStartFeedback(this.startFeedbackList), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"bml3"}));
        Assert.assertThat(this.getBMLIdsFromEndFeedback(this.endFeedbackList), (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void testPreplannedInterrupt() {
        this.parseBML(this.createNonEmptyBML("bml1"));
        this.scheduler.schedule();
        this.parseBML(this.createNonEmptyBML("bml2", "bmlt:preplan=\"true\" scheduling=\"interrupt(bml1)\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)1L, (long)this.startFeedbackList.size());
        Assert.assertEquals((long)1L, (long)this.endFeedbackList.size());
    }

    @Test
    public void testPreplannedInterrupt2() {
        this.parseBML(this.createNonEmptyBML("bml1", "bmlt:preplan=\"true\""));
        this.scheduler.schedule();
        this.parseBML(this.createNonEmptyBML("bml2", "bmlt:preplan=\"true\" scheduling=\"interrupt(bml1)\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)0L, (long)this.startFeedbackList.size());
        Assert.assertEquals((long)0L, (long)this.endFeedbackList.size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getBehaviours("bml1").size());
    }

    @Test
    public void testOnStartPreplan() {
        this.parseBML(this.createNonEmptyBML("bml1", "bmlt:preplan=\"true\""));
        this.scheduler.schedule();
        this.parseBML(this.createNonEmptyBML("bml2", "bmlt:preplan=\"true\" onStart=\"bml1\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)0L, (long)this.startFeedbackList.size());
    }

    @Test
    public void testAppendPreplanAndActivate() {
        this.parseBML(this.createNonEmptyBML("bml1", "bmlt:preplan=\"true\""));
        this.scheduler.schedule();
        this.parseBML(this.createNonEmptyBML("bml3", "bmlt:preplan=\"true\""));
        this.scheduler.schedule();
        this.parseBML(this.createNonEmptyBML("bml2", "bmlt:preplan=\"true\" scheduling=\"append-after(bml1)\" onStart=\"bml3\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)0L, (long)this.startFeedbackList.size());
    }

    @Test
    public void testAppendAfterPrePlanned() {
        this.parseBML(this.createNonEmptyBML("bml1", "bmlt:preplan=\"true\""));
        this.scheduler.schedule();
        this.parseBML(this.createNonEmptyBML("bml2", "scheduling=\"append-after(bml1)\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)0L, (long)this.startFeedbackList.size());
        this.parseBML(this.createEmptyBML("bml3", "bmlt:onStart=\"bml1\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)2L, (long)this.startFeedbackList.size());
        Assert.assertEquals((Object)"bml3", (Object)this.startFeedbackList.get((int)0).bmlId);
        Assert.assertEquals((Object)"bml1", (Object)this.startFeedbackList.get((int)1).bmlId);
        this.scheduler.blockStopFeedback("bml1");
        Assert.assertEquals((long)3L, (long)this.startFeedbackList.size());
        Assert.assertEquals((Object)"bml2", (Object)this.startFeedbackList.get((int)2).bmlId);
    }

    @Test
    public void testAppendPrePlanned() {
        this.parseBML(this.createNonEmptyBML("bml1", "bmlt:preplan=\"true\""));
        this.scheduler.schedule();
        this.parseBML(this.createNonEmptyBML("bml2", "scheduling=\"append\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)0L, (long)this.startFeedbackList.size());
        this.parseBML(this.createEmptyBML("bml3", "bmlt:onStart=\"bml1\""));
        this.scheduler.schedule();
        Assert.assertEquals((long)2L, (long)this.startFeedbackList.size());
        Assert.assertEquals((Object)"bml3", (Object)this.startFeedbackList.get((int)0).bmlId);
        Assert.assertEquals((Object)"bml1", (Object)this.startFeedbackList.get((int)1).bmlId);
        this.scheduler.blockStopFeedback("bml1");
        Assert.assertEquals((long)3L, (long)this.startFeedbackList.size());
        Assert.assertEquals((Object)"bml2", (Object)this.startFeedbackList.get((int)2).bmlId);
    }

    @Test
    public void testReplace2() {
        this.scheduler.getPegBoard().addBMLBlockPeg(new BMLBlockPeg("bml1", 1.0));
        this.parseBML(this.createNonEmptyBML("bml2", "scheduling=\"replace\""));
        this.scheduler.schedule();
        Assert.assertNull((Object)this.scheduler.getPegBoard().getBMLBlockPeg("bml1"));
    }

    private static class StubPlanner
    implements Planner {
        private Map<String, Set<String>> behMap = new HashMap<String, Set<String>>();

        private StubPlanner() {
        }

        public void addBehaviour(String bmlId, String id) {
            if (this.behMap.get(bmlId) == null) {
                this.behMap.put(bmlId, new HashSet());
            }
            this.behMap.get(bmlId).add(id);
        }

        @Override
        public Player getPlayer() {
            return null;
        }

        @Override
        public List<SyncAndTimePeg> addBehaviour(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sac, TimedPlanUnit planElement) throws BehaviourPlanningException {
            this.addBehaviour(b.bmlId, b.id);
            return new ArrayList<SyncAndTimePeg>();
        }

        @Override
        public TimedPlanUnit resolveSynchs(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sac) throws BehaviourPlanningException {
            return null;
        }

        @Override
        public void clearAll(double time) {
            this.behMap.clear();
        }

        @Override
        public void reset() {
        }

        @Override
        public Set<String> getInvalidBehaviours() {
            return new HashSet<String>();
        }

        @Override
        public void removeBehaviour(String behaviourId, String bmlId) {
            if (this.behMap.get(bmlId) != null) {
                this.behMap.get(bmlId).remove(behaviourId);
            }
        }

        @Override
        public void interruptBehaviour(String behaviourId, String bmlId, double globalTime) {
            if (this.behMap.get(bmlId) != null) {
                this.behMap.get(bmlId).remove(behaviourId);
            }
        }

        @Override
        public void interruptBehaviourBlock(String bmlId, double globalTime) {
            this.behMap.remove(bmlId);
        }

        @Override
        public List<Class<? extends Behaviour>> getSupportedBehaviours() {
            return new ArrayList<Class<? extends Behaviour>>();
        }

        @Override
        public List<Class<? extends Behaviour>> getSupportedDescriptionExtensions() {
            return new ArrayList<Class<? extends Behaviour>>();
        }

        @Override
        public void removeFeedbackListener(BMLFeedbackListener fb) {
        }

        @Override
        public void removeAllFeedbackListeners() {
        }

        @Override
        public void addFeedbackListener(BMLFeedbackListener fb) {
        }

        @Override
        public List<BMLFeedbackListener> getFeedbackListeners() {
            return new ArrayList<BMLFeedbackListener>();
        }

        @Override
        public void removeAllExceptionListeners() {
        }

        @Override
        public void addExceptionListener(BMLExceptionListener war) {
        }

        @Override
        public void setBMLBlockState(String bmlId, TimedPlanUnitState state) {
        }

        @Override
        public Set<String> getBehaviours(String bmlId) {
            if (this.behMap.get(bmlId) == null) {
                return new HashSet<String>();
            }
            return this.behMap.get(bmlId);
        }

        @Override
        public double getEndTime(String behId, String bmlId) {
            return 1.0E7;
        }

        @Override
        public void setParameterValue(String behId, String bmlId, String paramId, float value) {
        }

        @Override
        public void setParameterValue(String behId, String bmlId, String paramId, String value) {
        }

        @Override
        public void shutdown() {
        }
    }

    private static class StubSchedulingClock
    implements SchedulingClock {
        private double time = 0.0;

        private StubSchedulingClock() {
        }

        @Override
        public double getTime() {
            return this.time;
        }
    }
}

